(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1051326,      22528]
NotebookOptionsPosition[   1029627,      22024]
NotebookOutlinePosition[   1030759,      22063]
CellTagsIndexPosition[   1030716,      22060]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{
          SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", "1"}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5026719192141376`*^9, 
   3.5026719206441393`*^9}, {3.5027639618236465`*^9, 3.5027639715424633`*^9}, 
   3.5040443744413013`*^9, 3.5047258778634586`*^9, 3.5047259304635324`*^9, {
   3.5047296968488054`*^9, 3.5047297039888153`*^9}, {3.5047304827399054`*^9, 
   3.5047304905499163`*^9}, {3.5053445891537113`*^9, 3.505344590523713*^9}, {
   3.5100199895018682`*^9, 3.5100200070206995`*^9}, {3.510020038236354*^9, 
   3.510020038236354*^9}, {3.510170385415208*^9, 3.510170385415208*^9}, {
   3.5101743640143356`*^9, 3.5101743640143356`*^9}, {3.5134440458483133`*^9, 
   3.5134440464283147`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[StyleBox["Domain Map ",
  FontSize->24]], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5026719192141376`*^9, 
   3.5026719206441393`*^9}, {3.5027639618236465`*^9, 3.5027639715424633`*^9}, 
   3.5040443744413013`*^9, 3.5047258778634586`*^9, 3.5047259304635324`*^9, {
   3.5047296968488054`*^9, 3.5047297039888153`*^9}, {3.5047304827399054`*^9, 
   3.5047304905499163`*^9}, {3.5053445891537113`*^9, 3.505344590523713*^9}, {
   3.5100199895018682`*^9, 3.5100200070206995`*^9}, {3.510020038236354*^9, 
   3.510020038236354*^9}, {3.510170385415208*^9, 3.510170385415208*^9}, {
   3.5101743640143356`*^9, 3.5101743640143356`*^9}, {3.510420573081676*^9, 
   3.510420573081676*^9}, {3.510420642421773*^9, 3.510420642421773*^9}, {
   3.510430918288175*^9, 3.51043092210818*^9}, {3.510430958528231*^9, 
   3.510430958528231*^9}, {3.514435726645997*^9, 3.5144357958633184`*^9}, {
   3.5144359444535794`*^9, 3.514435964172014*^9}, {3.514436016057705*^9, 
   3.514436016057705*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1., 0.3, 0.3], RectangleBox[{-4, 1}, {-1, 4}]}, 
   {GrayLevel[0], InsetBox[
     StyleBox["\<\"Rule 1a\\n\[LowerRightArrow]\[DownArrow]\[Diamond]\"\>",
      StripOnInput->False,
      FontSize->10], NCache[{Rational[-5, 2], Rational[5, 2]}, {-2.5, 2.5}]]}, 
   {RGBColor[1., 0.5, 0.5], RectangleBox[{-4, 0}, {-1, 1}]}, 
   {GrayLevel[0], InsetBox[
     StyleBox["\<\"Rule 1b \[LowerRightArrow]\[Diamond]\"\>",
      StripOnInput->False,
      FontSize->10], NCache[{Rational[-5, 2], Rational[1, 2]}, {-2.5, 0.5}]]}, 
   {GrayLevel[1], Thickness[Large], LineBox[{{-1, 0}, {-1, 1}}], 
    {RGBColor[0.5, 0.5, 1.], RectangleBox[{-1, 1}, {0, 4}]}, 
    {GrayLevel[0], InsetBox[
      StyleBox["\<\"Rule 2\\n\[DownArrow]\[DownArrow]\[Diamond] \"\>",
       StripOnInput->False,
       FontSize->10], 
      NCache[{Rational[-1, 2], Rational[5, 2]}, {-0.5, 2.5}]]}, 
    {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
     LineBox[{{-0.98, 3.98}, {-0.98, 1}}], 
     {RGBColor[0.2, 1., 0.2], Dashing[{}], RectangleBox[{1, -1}, {4, 4}], 
      {GrayLevel[0], InsetBox[
        StyleBox["\<\"Rule 3a\\n\[LeftArrow]\[LeftArrow]\[Diamond]\"\>",
         StripOnInput->False,
         FontSize->10], 
        NCache[{Rational[5, 2], Rational[5, 2]}, {2.5, 2.5}]]}, 
      {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
       LineBox[{{1.02, -0.98}, {3.98, -0.98}}], 
       {RGBColor[0.7, 1., 0.7], Dashing[{}], RectangleBox[{0, 0}, {1, 4}], 
        {GrayLevel[0], InsetBox[
          StyleBox["\<\"Rule 3b\\n\[LowerLeftArrow]\[Diamond]\"\>",
           StripOnInput->False,
           FontSize->10], 
          NCache[{Rational[1, 2], Rational[5, 2]}, {0.5, 2.5}]]}, 
        {RGBColor[1, 0.5, 0.5], RectangleBox[{1, -4}, {4, -1}]}, 
        {GrayLevel[0], InsetBox[
          StyleBox["\<\"Rule 4a\\n\[UpperLeftArrow]\[LeftArrow]\[Diamond]\"\>",
           StripOnInput->False,
           FontSize->10], 
          NCache[{Rational[5, 2], Rational[-5, 2]}, {2.5, -2.5}]]}, 
        {RGBColor[1., 0.8, 0.8], RectangleBox[{0, -4}, {1, -1}]}, 
        {GrayLevel[0], InsetBox[
          StyleBox["\<\"Rule 4b\\n\[UpperLeftArrow]\[Diamond]\"\>",
           StripOnInput->False,
           FontSize->10], 
          NCache[{Rational[1, 2], Rational[-5, 2]}, {0.5, -2.5}]]}, 
        {RGBColor[1, 0, 1], RectangleBox[{-1, -4}, {0, -1.02}]}, 
        {GrayLevel[0], InsetBox[
          StyleBox["\<\"Rule 5\\n\[UpArrow]\[Diamond]\"\>",
           StripOnInput->False,
           FontSize->10], 
          NCache[{Rational[-1, 2], Rational[-5, 2]}, {-0.5, -2.5}]]}, 
        {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
         LineBox[{{-0.98, -1.04}, {-0.98, -3.98}}], 
         {RGBColor[1, 0.5, 0], Dashing[{}], RectangleBox[{-4, -4}, {-1, 0}], 
          {GrayLevel[0], InsetBox[
            StyleBox["\<\"Rule 6\\n\[RightArrow]\[Diamond]\"\>",
             StripOnInput->False,
             FontSize->10], 
            NCache[{Rational[-5, 2], Rational[-5, 2]}, {-2.5, -2.5}]]}, 
          {GrayLevel[1], Thickness[Large], LineBox[{{-1, -0.02}, {-1, -1}}]}, 
          {RGBColor[0.2, 1., 0.2], Thickness[Large], 
           LineBox[{{0, -3.98}, {0, -1.02}}], 
           {GrayLevel[0], GeometricTransformationBox[InsetBox[
              StyleBox["\<\"Rule 7 \[LeftArrow]\"\>",
               StripOnInput->False,
               FontSize->10], {0.15, -3.25}], {{{0, 1}, {-1, 0}}, Center}]}, 
           {RGBColor[0, 0, 1], Thickness[Large], LineBox[{{0, 0}, {0, 3.98}}], 
            {GrayLevel[0], GeometricTransformationBox[InsetBox[
               StyleBox["\<\"Rule 8 \[RightArrow]\"\>",
                StripOnInput->False,
                FontSize->10], {0.15, 1.7}], {{{0, 1}, {-1, 0}}, Center}]}, 
            {RGBColor[0.2, 1., 0.2], Thickness[Large], 
             LineBox[{{-3.98, 0}, {-1, 0}}], 
             {GrayLevel[0], InsetBox[
               StyleBox["\<\"Rule 9 \[RightArrow]\"\>",
                StripOnInput->False,
                FontSize->10], 
               NCache[{Rational[-5, 2], 0.13}, {-2.5, 0.13}]]}, 
             {RGBColor[0, 0, 1], Thickness[Large], 
              LineBox[{{0.02, 0}, {3.98, 0}}], 
              {GrayLevel[0], InsetBox[
                StyleBox["\<\"Rule 10 \[LeftArrow]\"\>",
                 StripOnInput->False,
                 FontSize->10], NCache[{Rational[5, 2], 0.13}, {2.5, 0.13}]]}, 
              {RGBColor[1, 1, 0], Thickness[Large], 
               LineBox[{{1, -1.02}, {1, -3.98}}], 
               {GrayLevel[0], GeometricTransformationBox[InsetBox[
                  StyleBox["\<\"Rule 11 \[LowerLeftArrow]\"\>",
                   StripOnInput->False,
                   FontSize->10], 
                  NCache[{1.15, Rational[-5, 2]}, {1.15, -2.5}]], {{{0, 
                  1}, {-1, 0}}, Center}]}, 
               {RGBColor[1., 0.5, 1.], Thickness[Large], 
                LineBox[{{1, 3.98}, {1, -1}}], 
                {GrayLevel[0], GeometricTransformationBox[InsetBox[
                   StyleBox["\<\"Rule 12 \[DownArrow]\"\>",
                    StripOnInput->False,
                    FontSize->10], {1.15, 2}], {{{0, 1}, {-1, 0}}, Center}]}, 
                {RGBColor[1, 1, 0], Thickness[Large], 
                 LineBox[{{-3.98, 1}, {-1.04, 1}}], 
                 {GrayLevel[0], InsetBox[
                   StyleBox["\<\"Rule 13 \[LowerRightArrow]\"\>",
                    StripOnInput->False,
                    FontSize->10], 
                   NCache[{Rational[-5, 2], 1.13}, {-2.5, 1.13}]]}, 
                 {RGBColor[1., 0.5, 1.], Thickness[Large], 
                  LineBox[{{-1, 1}, {3.98, 1}}], 
                  {GrayLevel[0], InsetBox[
                    StyleBox["\<\"Rule 14 \[DownArrow]\"\>",
                    StripOnInput->False,
                    FontSize->10], 
                    NCache[{Rational[5, 2], 1.13}, {2.5, 1.13}]]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[{0, -1}, Scaled[Rational[1, 60]]]}, 
                  {GrayLevel[0], InsetBox["\<\"a\"\>", {0.01, -1}]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[NCache[{0, Rational[1, 2]}, {0, 0.5}], Scaled[
                    Rational[1, 60]]]}, 
                  {GrayLevel[0], 
                   InsetBox["\<\"b\"\>", 
                    NCache[{0.01, Rational[1, 2]}, {0.01, 0.5}]]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[NCache[{0, Rational[-1, 2]}, {0, -0.5}], Scaled[
                    Rational[1, 60]]]}, 
                  {GrayLevel[0], 
                   InsetBox["\<\"b\"\>", 
                    NCache[{0.01, Rational[-1, 2]}, {0.01, -0.5}]]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[{1, 0}, Scaled[Rational[1, 60]]]}, 
                  {GrayLevel[0], InsetBox["\<\"c\"\>", {1.01, 0}]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[{-1, 0}, Scaled[Rational[1, 60]]]}, 
                  {GrayLevel[0], InsetBox["\<\"d\"\>", {-0.99, 0}]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[NCache[{Rational[-1, 2], 0}, {-0.5, 0}], Scaled[
                    Rational[1, 60]]]}, 
                  {GrayLevel[0], InsetBox["\<\"e\"\>", {-0.49, 0}]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[NCache[{Rational[-3, 2], 0}, {-1.5, 0}], Scaled[
                    Rational[1, 60]]]}, 
                  {GrayLevel[0], InsetBox["\<\"f\"\>", {-1.49, 0}]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[NCache[{Rational[1, 2], 0}, {0.5, 0}], Scaled[
                    Rational[1, 60]]]}, 
                  {GrayLevel[0], InsetBox["\<\"f\"\>", {0.51, 0}]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[{-1, -1}, Scaled[Rational[1, 60]]]}, 
                  {GrayLevel[0], InsetBox["\<\"g\"\>", {-0.99, -1}]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[NCache[{-1, Rational[1, 2]}, {-1, 0.5}], Scaled[
                    Rational[1, 60]]]}, 
                  {GrayLevel[0], 
                   InsetBox["\<\"h\"\>", 
                    NCache[{-0.99, Rational[1, 2]}, {-0.99, 0.5}]]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[NCache[{-1, Rational[-1, 2]}, {-1, -0.5}], Scaled[
                    Rational[1, 60]]]}, 
                  {GrayLevel[0], 
                   InsetBox["\<\"h\"\>", 
                    NCache[{-0.99, Rational[-1, 2]}, {-0.99, -0.5}]]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[NCache[{Rational[1, 2], -1}, {0.5, -1}], Scaled[
                    Rational[1, 60]]]}, 
                  {GrayLevel[0], InsetBox["\<\"i\"\>", {0.51, -1}]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[NCache[{Rational[-1, 2], -1}, {-0.5, -1}], Scaled[
                    Rational[1, 60]]]}, 
                  {GrayLevel[0], InsetBox["\<\"i\"\>", {-0.49, -1}]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[
                    NCache[{Rational[-1, 2], Rational[-1, 2]}, {-0.5, -0.5}], 
                    Scaled[Rational[1, 60]]]}, 
                  {GrayLevel[0], 
                   InsetBox["\<\"j\"\>", 
                    NCache[{-0.49, Rational[-1, 2]}, {-0.49, -0.5}]]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[
                    NCache[{Rational[1, 2], Rational[-1, 2]}, {0.5, -0.5}], 
                    Scaled[Rational[1, 60]]]}, 
                  {GrayLevel[0], 
                   InsetBox["\<\"k\"\>", 
                    NCache[{0.51, Rational[-1, 2]}, {0.51, -0.5}]]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[
                    NCache[{Rational[-1, 2], Rational[1, 2]}, {-0.5, 0.5}], 
                    Scaled[Rational[1, 60]]]}, 
                  {GrayLevel[0], 
                   InsetBox["\<\"k\"\>", 
                    NCache[{-0.49, Rational[1, 2]}, {-0.49, 0.5}]]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[
                    NCache[{Rational[-1, 2], Rational[-3, 2]}, {-0.5, -1.5}], 
                    Scaled[Rational[1, 60]]]}, 
                  {GrayLevel[0], 
                   InsetBox["\<\"l\"\>", 
                    NCache[{-0.49, Rational[-3, 2]}, {-0.49, -1.5}]]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[
                    NCache[{Rational[-3, 2], Rational[-1, 2]}, {-1.5, -0.5}], 
                    Scaled[Rational[1, 60]]]}, 
                  {GrayLevel[0], 
                   InsetBox["\<\"m\"\>", 
                    NCache[{-1.49, Rational[-1, 2]}, {-1.49, -0.5}]]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[
                    NCache[{Rational[1, 2], Rational[-3, 2]}, {0.5, -1.5}], 
                    Scaled[Rational[1, 60]]]}, 
                  {GrayLevel[0], 
                   InsetBox["\<\"n\"\>", 
                    NCache[{0.51, Rational[-3, 2]}, {0.51, -1.5}]]}, 
                  {RGBColor[0, 1, 1], 
                   DiskBox[
                    NCache[{Rational[-3, 2], Rational[1, 2]}, {-1.5, 0.5}], 
                    Scaled[Rational[1, 60]]]}, 
                  {GrayLevel[0], 
                   InsetBox["\<\"o\"\>", 
                    NCache[{-1.49, Rational[1, 2]}, {-1.49, 
                    0.5}]]}}}}}}}}}}}}}}}}},
  Axes->True,
  AxesLabel->{
    FormBox["n", TraditionalForm], 
    FormBox[
     RowBox[{"j", " ", "k", " ", "m"}], TraditionalForm]},
  ImageSize->Medium]], "Input",
 TextAlignment->Center],

Cell[TextData[{
 StyleBox["Legend:",
  FontWeight->"Bold"],
 "\n\[Bullet]  The rule number in a colored region indicates the rule to use \
for integrals in that region.\n\[Bullet]  The rule number next to a colored \
line indicates the rule to use for integrals on that line.\n\[Bullet]  A \
white region or line indicates there is no rule for integrals in that region \
or on that line.\n\[Bullet]  A solid black line indicates integrals on that \
line are handled by rules in another section.\n\[Bullet]  A dashed black line \
on the border of a region indicates integrals on that border are handled by \
the rule for that region.\n\[Bullet]  The arrow(s) following a rule number \
indicates the direction the rule drives integrands in the n\[Cross]m exponent \
plane.\n\[Bullet]  A \[Diamond] following a rule number indicates the rule \
transforms the integrand into a form handled by another section.\n\[Bullet]  \
A red (stop) disk indicates the terminal rule to use for the point at the \
center of the disk.\n\[Bullet]  A cyan disk indicates the non-terminal rule \
to use for the point at the center of the disk."
}], "Text",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQvWx2qt8BmVeOAtpmKSBazPxXBoguPqZWAKJ3VvSW
gGje1yvrQXTvPN4WEL3DULwVRHNs1u0G0VVfRSeD6EsSC6eD6FV9WrNAtOHV
+HkgWv9Q6k4QHetWuh9EH7w48QCIdohIPgqin689BaaXtdWcBdEb3DovgOjl
RslXQHQI+4X7IPr7BK7nINq2WwJMfxN6/hpEt0g2vAfRR7xefgbRXudamA4C
6WcX4tlBtAzPSx4QbVPAJwSir/yqkwLROQtY5EG0j6SgFohmi8k0AdH7HrBZ
gOjD1z65gOiAl39dQfTDAstoEB2x+BuY7v4bmg6i5+RVgWkAeVypcw==
  "],
 FontSize->14],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{
          SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", "1"}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5026719192141376`*^9, 
   3.5026719206441393`*^9}, {3.5027639618236465`*^9, 3.5027639715424633`*^9}, 
   3.5040443744413013`*^9, 3.5047258778634586`*^9, 3.5047259304635324`*^9, {
   3.5047296968488054`*^9, 3.5047297039888153`*^9}, {3.5047304827399054`*^9, 
   3.5047304905499163`*^9}, {3.5053445891537113`*^9, 3.505344590523713*^9}, {
   3.5100199895018682`*^9, 3.5100200070206995`*^9}, {3.510020038236354*^9, 
   3.510020038236354*^9}, {3.510170385415208*^9, 3.510170385415208*^9}, {
   3.5101743640143356`*^9, 3.5101743640143356`*^9}, {3.510420573081676*^9, 
   3.510420573081676*^9}, {3.510420642421773*^9, 3.510420642421773*^9}, {
   3.510430918288175*^9, 3.51043092210818*^9}, {3.510430958528231*^9, 
   3.510430958528231*^9}, {3.514435726645997*^9, 3.5144357958633184`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["a",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "j"}]]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511617733184*^9, 3.510511622272792*^9}, 
   3.5111158844118*^9, 3.511115946281887*^9, {3.5111203990981207`*^9, 
   3.5111204206481504`*^9}, {3.5130402783197694`*^9, 3.51304027853817*^9}, {
   3.514668984356907*^9, 3.5146689857765093`*^9}, {3.5146803564896903`*^9, 
   3.5146803573196917`*^9}, {3.5146856001670527`*^9, 
   3.5146856004634533`*^9}, {3.5146856360315156`*^9, 
   3.5146856718335786`*^9}, {3.514830334527244*^9, 3.514830344407258*^9}, 
   3.5148383589958673`*^9, {3.515187511960174*^9, 3.5151875175201817`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5076647229436293`*^9, 3.507664727563636*^9}, 
   3.509987368148217*^9, {3.5104261125494456`*^9, 3.510426116279451*^9}}],

Cell[TextData[{
 "Rule a: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4992133873636045`*^9, 3.4992133892036066`*^9}, {3.4992162641476316`*^9, 
   3.499216265707634*^9}, {3.4993685410928354`*^9, 3.4993685488628464`*^9}, {
   3.50031970240469*^9, 3.5003197069046965`*^9}, {3.5004320341975737`*^9, 
   3.5004320353096375`*^9}, {3.5026784535032854`*^9, 3.502678461573297*^9}, {
   3.5027657904804587`*^9, 3.5027657904804587`*^9}, {3.5027672190193686`*^9, 
   3.5027672190193686`*^9}, {3.5035496199411335`*^9, 
   3.5035496486311736`*^9}, {3.504028649276944*^9, 3.5040286502597466`*^9}, 
   3.50403187501501*^9, 3.5043107662485094`*^9, {3.5047476342426376`*^9, 
   3.504747635372639*^9}, {3.509473798840955*^9, 3.509473798840955*^9}, {
   3.509934658346775*^9, 3.5099346733567963`*^9}, 3.509938528846196*^9, {
   3.5099390241689568`*^9, 3.509939026446561*^9}, {3.5099391248983335`*^9, 
   3.509939129625142*^9}, {3.5101741545371675`*^9, 3.5101741545371675`*^9}, {
   3.5101804637230964`*^9, 3.510180464175497*^9}, {3.5104262123495855`*^9, 
   3.5104262133995867`*^9}, {3.510426298579706*^9, 3.510426298789706*^9}, {
   3.5104290997956295`*^9, 3.5104291289556704`*^9}, {3.5104291657057214`*^9, 
   3.510429166845723*^9}, {3.5104539390709763`*^9, 3.5104539499209914`*^9}, {
   3.510611346015913*^9, 3.5106113513979225`*^9}, {3.510611672181286*^9, 
   3.510611672181286*^9}, {3.513022605917926*^9, 3.5130226522968073`*^9}, 
   3.51302989565353*^9, {3.513030319459474*^9, 3.513030323234681*^9}, {
   3.513030734123802*^9, 3.5130307346542034`*^9}, {3.513040428345233*^9, 
   3.5130404289848337`*^9}, {3.513052831810176*^9, 3.513052832150176*^9}, 
   3.5148303982873335`*^9, {3.5148314575508957`*^9, 3.514831492920945*^9}, 
   3.514831557801036*^9, {3.5148316194311223`*^9, 3.514831619611122*^9}, {
   3.514838321095814*^9, 3.5148383225058165`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "j"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"-", "j"}]]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "B"}]}], " ", "x"}]}], "+", 
  RowBox[{"A", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.4987607563116155`*^9, 3.498760763041625*^9}, {
   3.499305498308893*^9, 3.499305517262926*^9}, {3.5059666670951004`*^9, 
   3.505966716827945*^9}, {3.5061955618794093`*^9, 3.506195570159421*^9}, {
   3.5072431872612705`*^9, 3.5072432404261637`*^9}, {3.5072432976002645`*^9, 
   3.507243301266271*^9}, {3.5073303069156404`*^9, 3.507330321715661*^9}, 
   3.507580775876561*^9, {3.5075808517266674`*^9, 3.5075808618066816`*^9}, {
   3.507771267886224*^9, 3.507771338306322*^9}, {3.5077750940895863`*^9, 
   3.5077750969995904`*^9}, {3.5077754105500293`*^9, 3.5077754262100515`*^9}, 
   3.5077754729201164`*^9, {3.5077759620108013`*^9, 3.5077759784608245`*^9}, {
   3.5077776770532026`*^9, 3.5077777072532444`*^9}, {3.509985239743236*^9, 
   3.50998526384327*^9}, {3.509987215038003*^9, 3.509987346898187*^9}, 
   3.5104260735393915`*^9, {3.510428784095187*^9, 3.510428803355214*^9}, {
   3.5104289858954697`*^9, 3.5104289956154833`*^9}, {3.5104512488532076`*^9, 
   3.5104512676132336`*^9}, 3.5104513282733183`*^9, {3.5104525757750654`*^9, 
   3.51045259385509*^9}, {3.510453876910889*^9, 3.510453922550953*^9}, {
   3.510454085761182*^9, 3.510454091071189*^9}, {3.5104541579412823`*^9, 
   3.510454168161297*^9}, {3.510530323854356*^9, 3.510530330164365*^9}, {
   3.510611025794151*^9, 3.510611090050664*^9}, 3.5130296375354767`*^9, {
   3.51302977621972*^9, 3.513029778341324*^9}, {3.513030224892108*^9, 
   3.5130302345953255`*^9}, {3.5148313683207707`*^9, 3.514831372190776*^9}, {
   3.514831483550932*^9, 3.5148315131609735`*^9}, {3.514831545801019*^9, 
   3.5148315530710297`*^9}, 3.514831587801078*^9, {3.515187519580185*^9, 
   3.5151875222801886`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"B", "*", "x"}], " ", "+", " ", 
    RowBox[{"Dist", "[", 
     RowBox[{"A", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "B"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.4982401285726357`*^9, 3.4982401313526397`*^9}, {
   3.4987611327521424`*^9, 3.4987611393821516`*^9}, {3.4987611708821955`*^9, 
   3.498761277792345*^9}, {3.498761669522894*^9, 3.4987616788229065`*^9}, {
   3.4987619391432714`*^9, 3.498761943263277*^9}, {3.499183308350725*^9, 
   3.4991833124847326`*^9}, {3.499185161474782*^9, 3.499185164828788*^9}, {
   3.499305530288949*^9, 3.4993055385257635`*^9}, {3.505966844688258*^9, 
   3.50596686517743*^9}, {3.5059669219046745`*^9, 3.5059669229497347`*^9}, {
   3.50596738600922*^9, 3.5059673883963566`*^9}, {3.5061955820294375`*^9, 
   3.506195592559452*^9}, {3.507243361763177*^9, 3.5072433812008114`*^9}, {
   3.5073303887157545`*^9, 3.507330393995762*^9}, {3.507330454915848*^9, 
   3.50733048518589*^9}, {3.507330529445952*^9, 3.5073305427059703`*^9}, {
   3.507330812806349*^9, 3.507330823296363*^9}, {3.5073309520265436`*^9, 
   3.5073309814665847`*^9}, {3.5073313288470707`*^9, 
   3.5073313330470767`*^9}, {3.5073320683081064`*^9, 
   3.5073320876581335`*^9}, {3.5073327496090603`*^9, 
   3.5073327527890644`*^9}, {3.5073328122591476`*^9, 
   3.5073328126791487`*^9}, {3.5073328632292194`*^9, 
   3.5073328824192457`*^9}, {3.5073338298225737`*^9, 3.507333833852579*^9}, {
   3.5073961002459946`*^9, 3.5073961026559973`*^9}, {3.5074422952495613`*^9, 
   3.507442320646406*^9}, {3.507486395872465*^9, 3.50748644954254*^9}, {
   3.5074944725478563`*^9, 3.507494494559495*^9}, {3.5074946945677853`*^9, 
   3.5074946980877905`*^9}, {3.507494901148075*^9, 3.5074949419981318`*^9}, {
   3.5074957249818935`*^9, 3.5074957317835054`*^9}, {3.507498957682372*^9, 
   3.507498975294803*^9}, 3.5075767853545046`*^9, 3.507580831786639*^9, {
   3.5075809662868276`*^9, 3.5075809692668324`*^9}, {3.5077712489761972`*^9, 
   3.5077712551362057`*^9}, {3.5077717557849126`*^9, 3.507771816284997*^9}, 
   3.507775224829769*^9, {3.507775455140092*^9, 3.5077754653101063`*^9}, 
   3.5077757871805563`*^9, {3.507775916570738*^9, 3.5077759642408047`*^9}, 
   3.507776008880867*^9, {3.50777771104325*^9, 3.5077777236732674`*^9}, {
   3.5099853835154386`*^9, 3.509985429525503*^9}, {3.5099854711155615`*^9, 
   3.5099854898355875`*^9}, {3.50998619167657*^9, 3.5099861963665767`*^9}, {
   3.5099874380583153`*^9, 3.509987492538391*^9}, {3.51042615829951*^9, 
   3.5104261867395496`*^9}, 3.5104262188695946`*^9, {3.510426269739666*^9, 
   3.5104262761096745`*^9}, {3.5104290794356003`*^9, 
   3.5104290888356133`*^9}, {3.5104291536757045`*^9, 3.510429159565713*^9}, {
   3.5104292694358664`*^9, 3.510429275025874*^9}, {3.5104293070859194`*^9, 
   3.5104293377959623`*^9}, 3.510451422603451*^9, {3.5104515553536367`*^9, 
   3.51045158679368*^9}, 3.5104518165940027`*^9, {3.5104518510140505`*^9, 
   3.510451852984053*^9}, {3.5104520740643625`*^9, 3.5104520772343674`*^9}, {
   3.5104522225545707`*^9, 3.510452235864589*^9}, {3.5104526595251827`*^9, 
   3.5104527673753333`*^9}, {3.5104536273705397`*^9, 
   3.5104536289005423`*^9}, {3.510453910900937*^9, 3.5104539149709425`*^9}, {
   3.5104539640810113`*^9, 3.5104539889210463`*^9}, {3.5104542120713587`*^9, 
   3.51045435582156*^9}, {3.5105298808437357`*^9, 3.510529881153736*^9}, {
   3.510530346304387*^9, 3.5105303713644223`*^9}, {3.510599863079664*^9, 
   3.5105998667696695`*^9}, {3.510600124900031*^9, 3.510600127900035*^9}, {
   3.5106054943864355`*^9, 3.5106054979900417`*^9}, {3.5106059737876773`*^9, 
   3.5106059774380836`*^9}, {3.510608000184437*^9, 3.5106080045836444`*^9}, {
   3.51060840628435*^9, 3.510608409139155*^9}, {3.5106111149639072`*^9, 
   3.5106111844620295`*^9}, 3.5106112168320866`*^9, {3.5106112484377418`*^9, 
   3.5106112639753695`*^9}, 3.5106116786084976`*^9, {3.513022655494813*^9, 
   3.5130226559628134`*^9}, 3.5130232039761763`*^9, 3.513029881223504*^9, {
   3.513030062027822*^9, 3.513030064336626*^9}, 3.513030218511697*^9, {
   3.5130302803658056`*^9, 3.513030293703829*^9}, 3.5130317217067375`*^9, {
   3.5148305581175575`*^9, 3.5148305608375607`*^9}, {3.514830696437751*^9, 
   3.514830725977792*^9}, 3.514831439900871*^9, 3.5148315261909914`*^9, {
   3.514831583961073*^9, 3.5148315978910923`*^9}, {3.5148317145012555`*^9, 
   3.514831721421265*^9}, 3.5168210106869583`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["b",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "/", "2"}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "j"}]]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511617733184*^9, 3.510511622272792*^9}, 
   3.5111158844118*^9, 3.511115946281887*^9, {3.5111203990981207`*^9, 
   3.5111204206481504`*^9}, {3.5130402783197694`*^9, 3.51304027853817*^9}, {
   3.514668984356907*^9, 3.5146689857765093`*^9}, {3.5146803564896903`*^9, 
   3.5146803573196917`*^9}, {3.5146856001670527`*^9, 
   3.5146856004634533`*^9}, {3.5146856360315156`*^9, 
   3.5146856718335786`*^9}, {3.514830334527244*^9, 3.514830344407258*^9}, 
   3.5148382862057657`*^9, {3.5148384183159504`*^9, 3.514838419045951*^9}, {
   3.5151876020403*^9, 3.5151876036403027`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5076647229436293`*^9, 3.507664727563636*^9}, 
   3.509987368148217*^9, {3.5104261125494456`*^9, 3.510426116279451*^9}}],

Cell["Rule b1:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4992133873636045`*^9, 3.4992133892036066`*^9}, {3.4992162641476316`*^9, 
   3.499216265707634*^9}, {3.4993685410928354`*^9, 3.4993685488628464`*^9}, {
   3.50031970240469*^9, 3.5003197069046965`*^9}, {3.5004320341975737`*^9, 
   3.5004320353096375`*^9}, {3.5026784535032854`*^9, 3.502678461573297*^9}, {
   3.5027657904804587`*^9, 3.5027657904804587`*^9}, {3.5027672190193686`*^9, 
   3.5027672190193686`*^9}, {3.5035496199411335`*^9, 
   3.5035496486311736`*^9}, {3.504028649276944*^9, 3.5040286502597466`*^9}, 
   3.50403187501501*^9, 3.5043107662485094`*^9, {3.5047476342426376`*^9, 
   3.504747635372639*^9}, {3.509473798840955*^9, 3.509473798840955*^9}, {
   3.509934658346775*^9, 3.5099346733567963`*^9}, 3.509938528846196*^9, {
   3.5099390241689568`*^9, 3.509939026446561*^9}, {3.5099391248983335`*^9, 
   3.509939129625142*^9}, {3.5101741545371675`*^9, 3.5101741545371675`*^9}, {
   3.5101804637230964`*^9, 3.510180464175497*^9}, {3.5104262123495855`*^9, 
   3.5104262133995867`*^9}, {3.510426298579706*^9, 3.510426298789706*^9}, {
   3.5104290997956295`*^9, 3.5104291289556704`*^9}, {3.5104291657057214`*^9, 
   3.510429166845723*^9}, {3.5104539390709763`*^9, 3.5104539499209914`*^9}, {
   3.510611346015913*^9, 3.5106113513979225`*^9}, {3.510611672181286*^9, 
   3.510611672181286*^9}, {3.513022605917926*^9, 3.5130226522968073`*^9}, 
   3.51302989565353*^9, 3.513030787429096*^9, 3.513040433118841*^9, {
   3.513052835420181*^9, 3.513052875430237*^9}, {3.514686362229992*^9, 
   3.5146863734464116`*^9}, {3.514687691246727*^9, 3.514687705598752*^9}, 
   3.5148301098069296`*^9, {3.5148301976770525`*^9, 3.5148301986470537`*^9}, {
   3.514838387405907*^9, 3.5148383876059074`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "A"}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], " ", "+", 
  RowBox[{"B", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.4987607563116155`*^9, 3.498760763041625*^9}, {
   3.499305498308893*^9, 3.499305517262926*^9}, {3.5059666670951004`*^9, 
   3.505966716827945*^9}, {3.5061955618794093`*^9, 3.506195570159421*^9}, {
   3.5072431872612705`*^9, 3.5072432404261637`*^9}, {3.5072432976002645`*^9, 
   3.507243301266271*^9}, {3.5073303069156404`*^9, 3.507330321715661*^9}, 
   3.507580775876561*^9, {3.5075808517266674`*^9, 3.5075808618066816`*^9}, {
   3.507771267886224*^9, 3.507771338306322*^9}, {3.5077750940895863`*^9, 
   3.5077750969995904`*^9}, {3.5077754105500293`*^9, 3.5077754262100515`*^9}, 
   3.5077754729201164`*^9, {3.5077759620108013`*^9, 3.5077759784608245`*^9}, {
   3.5077776770532026`*^9, 3.5077777072532444`*^9}, {3.509985239743236*^9, 
   3.50998526384327*^9}, {3.509987215038003*^9, 3.509987346898187*^9}, 
   3.5104260735393915`*^9, {3.510428784095187*^9, 3.510428803355214*^9}, {
   3.5104289858954697`*^9, 3.5104289956154833`*^9}, {3.5104512488532076`*^9, 
   3.5104512676132336`*^9}, 3.5104513282733183`*^9, {3.5104525757750654`*^9, 
   3.51045259385509*^9}, {3.510453876910889*^9, 3.510453922550953*^9}, {
   3.510454085761182*^9, 3.510454091071189*^9}, {3.5104541579412823`*^9, 
   3.510454168161297*^9}, {3.510530323854356*^9, 3.510530330164365*^9}, {
   3.510611025794151*^9, 3.510611090050664*^9}, 3.5130296375354767`*^9, {
   3.51302977621972*^9, 3.513029778341324*^9}, {3.5146863659895983`*^9, 
   3.514686382307227*^9}, {3.5146867096738024`*^9, 3.5146867264438314`*^9}, {
   3.5148299940067673`*^9, 3.514830002346779*^9}, {3.514830047986843*^9, 
   3.5148300908769026`*^9}, {3.515187578650267*^9, 3.5151875974302936`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{"A", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "]"}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"B", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "d", ",", "A", ",", "B"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.4982401285726357`*^9, 3.4982401313526397`*^9}, {
   3.4987611327521424`*^9, 3.4987611393821516`*^9}, {3.4987611708821955`*^9, 
   3.498761277792345*^9}, {3.498761669522894*^9, 3.4987616788229065`*^9}, {
   3.4987619391432714`*^9, 3.498761943263277*^9}, {3.499183308350725*^9, 
   3.4991833124847326`*^9}, {3.499185161474782*^9, 3.499185164828788*^9}, {
   3.499305530288949*^9, 3.4993055385257635`*^9}, {3.505966844688258*^9, 
   3.50596686517743*^9}, {3.5059669219046745`*^9, 3.5059669229497347`*^9}, {
   3.50596738600922*^9, 3.5059673883963566`*^9}, {3.5061955820294375`*^9, 
   3.506195592559452*^9}, {3.507243361763177*^9, 3.5072433812008114`*^9}, {
   3.5073303887157545`*^9, 3.507330393995762*^9}, {3.507330454915848*^9, 
   3.50733048518589*^9}, {3.507330529445952*^9, 3.5073305427059703`*^9}, {
   3.507330812806349*^9, 3.507330823296363*^9}, {3.5073309520265436`*^9, 
   3.5073309814665847`*^9}, {3.5073313288470707`*^9, 
   3.5073313330470767`*^9}, {3.5073320683081064`*^9, 
   3.5073320876581335`*^9}, {3.5073327496090603`*^9, 
   3.5073327527890644`*^9}, {3.5073328122591476`*^9, 
   3.5073328126791487`*^9}, {3.5073328632292194`*^9, 
   3.5073328824192457`*^9}, {3.5073338298225737`*^9, 3.507333833852579*^9}, {
   3.5073961002459946`*^9, 3.5073961026559973`*^9}, {3.5074422952495613`*^9, 
   3.507442320646406*^9}, {3.507486395872465*^9, 3.50748644954254*^9}, {
   3.5074944725478563`*^9, 3.507494494559495*^9}, {3.5074946945677853`*^9, 
   3.5074946980877905`*^9}, {3.507494901148075*^9, 3.5074949419981318`*^9}, {
   3.5074957249818935`*^9, 3.5074957317835054`*^9}, {3.507498957682372*^9, 
   3.507498975294803*^9}, 3.5075767853545046`*^9, 3.507580831786639*^9, {
   3.5075809662868276`*^9, 3.5075809692668324`*^9}, {3.5077712489761972`*^9, 
   3.5077712551362057`*^9}, {3.5077717557849126`*^9, 3.507771816284997*^9}, 
   3.507775224829769*^9, {3.507775455140092*^9, 3.5077754653101063`*^9}, 
   3.5077757871805563`*^9, {3.507775916570738*^9, 3.5077759642408047`*^9}, 
   3.507776008880867*^9, {3.50777771104325*^9, 3.5077777236732674`*^9}, {
   3.5099853835154386`*^9, 3.509985429525503*^9}, {3.5099854711155615`*^9, 
   3.5099854898355875`*^9}, {3.50998619167657*^9, 3.5099861963665767`*^9}, {
   3.5099874380583153`*^9, 3.509987492538391*^9}, {3.51042615829951*^9, 
   3.5104261867395496`*^9}, 3.5104262188695946`*^9, {3.510426269739666*^9, 
   3.5104262761096745`*^9}, {3.5104290794356003`*^9, 
   3.5104290888356133`*^9}, {3.5104291536757045`*^9, 3.510429159565713*^9}, {
   3.5104292694358664`*^9, 3.510429275025874*^9}, {3.5104293070859194`*^9, 
   3.5104293377959623`*^9}, 3.510451422603451*^9, {3.5104515553536367`*^9, 
   3.51045158679368*^9}, 3.5104518165940027`*^9, {3.5104518510140505`*^9, 
   3.510451852984053*^9}, {3.5104520740643625`*^9, 3.5104520772343674`*^9}, {
   3.5104522225545707`*^9, 3.510452235864589*^9}, {3.5104526595251827`*^9, 
   3.5104527673753333`*^9}, {3.5104536273705397`*^9, 
   3.5104536289005423`*^9}, {3.510453910900937*^9, 3.5104539149709425`*^9}, {
   3.5104539640810113`*^9, 3.5104539889210463`*^9}, {3.5104542120713587`*^9, 
   3.51045435582156*^9}, {3.5105298808437357`*^9, 3.510529881153736*^9}, {
   3.510530346304387*^9, 3.5105303713644223`*^9}, {3.510599863079664*^9, 
   3.5105998667696695`*^9}, {3.510600124900031*^9, 3.510600127900035*^9}, {
   3.5106054943864355`*^9, 3.5106054979900417`*^9}, {3.5106059737876773`*^9, 
   3.5106059774380836`*^9}, {3.510608000184437*^9, 3.5106080045836444`*^9}, {
   3.51060840628435*^9, 3.510608409139155*^9}, {3.5106111149639072`*^9, 
   3.5106111844620295`*^9}, 3.5106112168320866`*^9, {3.5106112484377418`*^9, 
   3.5106112639753695`*^9}, 3.5106116786084976`*^9, {3.513022655494813*^9, 
   3.5130226559628134`*^9}, 3.5130232039761763`*^9, 3.513029881223504*^9, {
   3.513030062027822*^9, 3.513030064336626*^9}, {3.5130304180672474`*^9, 
   3.513030466801733*^9}, {3.5130308460771995`*^9, 3.5130308478088026`*^9}, {
   3.5146673699537354`*^9, 3.5146673893437624`*^9}, {3.514667606319686*^9, 
   3.514667654991771*^9}, {3.5146698303307924`*^9, 3.5146698317971954`*^9}, {
   3.514670305663508*^9, 3.5146703358835506`*^9}, {3.5146704479137073`*^9, 
   3.5146704630337286`*^9}, 3.5146709820744553`*^9, {3.5146759715354824`*^9, 
   3.5146760019655247`*^9}, {3.51467676301659*^9, 3.5146767697566*^9}, {
   3.5146859006703806`*^9, 3.5146859603716855`*^9}, {3.514686011914176*^9, 
   3.5146860166409845`*^9}, {3.5146863874552364`*^9, 
   3.5146864315877137`*^9}, {3.5146875848857403`*^9, 3.514687614057791*^9}, {
   3.5148248808272715`*^9, 3.514824884967277*^9}, {3.514824916447321*^9, 
   3.514824919087325*^9}, {3.514825054837515*^9, 3.5148250635975275`*^9}, {
   3.514828109601799*^9, 3.514828113021804*^9}, {3.514828162133874*^9, 
   3.514828163773876*^9}, {3.5148284380665493`*^9, 3.5148284440465574`*^9}, {
   3.5148300119167924`*^9, 3.5148300156267977`*^9}, {3.5148302555571337`*^9, 
   3.5148303032572002`*^9}, 3.514830361697282*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5076647229436293`*^9, 3.507664727563636*^9}, 
   3.5106050409560385`*^9, {3.5106127371639566`*^9, 3.510612741360364*^9}, 
   3.5120867669592376`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"f", "[", "z", "]"}], "m"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"f", "[", "z", "]"}]}], ")"}], "m"]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}, {
   3.5072605288062344`*^9, 3.5072605314582396`*^9}, {3.5075717121274023`*^9, 
   3.507571727117423*^9}, {3.50758176808795*^9, 3.5075817732679577`*^9}, {
   3.507583363755458*^9, 3.5075833689814672`*^9}, {3.510507619932962*^9, 
   3.51050763590739*^9}, {3.5106050833413134`*^9, 3.510605087834121*^9}, 
   3.51060524079239*^9, {3.514680379659723*^9, 3.514680388989736*^9}, {
   3.5146850469328804`*^9, 3.514685091548959*^9}, {3.5146851370698385`*^9, 
   3.514685139503443*^9}}],

Cell[TextData[{
 "Note: For some strange reason, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " overly agressively evaluates ",
 Cell[BoxData[
  FractionBox["1", 
   RowBox[{
    SqrtBox[
     RowBox[{"f", "[", "z", "]"}]], " ", 
    SqrtBox[
     RowBox[{"1", "/", 
      RowBox[{"f", "[", "z", "]"}]}]]}]]], "Input",
  CellChangeTimes->{{3.514685306751337*^9, 3.5146853186073575`*^9}}],
 " to ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    RowBox[{"f", "[", "z", "]"}]], " ", 
   SqrtBox[
    RowBox[{"1", "/", 
     RowBox[{"f", "[", "z", "]"}]}]]}]],
  CellChangeTimes->{{3.514685306751337*^9, 3.5146853186073575`*^9}}],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}, {
   3.5072605288062344`*^9, 3.5072605314582396`*^9}, {3.5075717121274023`*^9, 
   3.507571727117423*^9}, {3.50758176808795*^9, 3.5075817732679577`*^9}, {
   3.507583363755458*^9, 3.5075833689814672`*^9}, {3.510507619932962*^9, 
   3.51050763590739*^9}, {3.5106050833413134`*^9, 3.510605087834121*^9}, 
   3.51060524079239*^9, {3.514680379659723*^9, 3.514680388989736*^9}, {
   3.5146850469328804`*^9, 3.514685091548959*^9}, {3.5146851370698385`*^9, 
   3.514685139503443*^9}, {3.5146853345973854`*^9, 3.514685523841318*^9}, {
   3.5146855702462*^9, 3.514685571385002*^9}}],

Cell[TextData[{
 "Rule b2: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["m", "2"], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.505936081778288*^9, 
   3.5059360824123244`*^9}, 3.50596679279029*^9, 3.506195715879625*^9, {
   3.5072434262848907`*^9, 3.507243426534491*^9}, {3.5073303681657257`*^9, 
   3.507330407975782*^9}, {3.5075715513171773`*^9, 3.5075715650271964`*^9}, {
   3.5075716142272654`*^9, 3.507571619647273*^9}, {3.507580938536789*^9, 
   3.50758093920679*^9}, {3.5075833309018*^9, 3.507583346985429*^9}, {
   3.5075993071840444`*^9, 3.507599307904045*^9}, 3.510604515079115*^9, {
   3.5120867401191998`*^9, 3.5120867401191998`*^9}, {3.5121653627166405`*^9, 
   3.5121653698266497`*^9}, {3.513040122163495*^9, 3.5130401346279173`*^9}, {
   3.5146803614996977`*^9, 3.5146803616796975`*^9}, {3.5148302010170574`*^9, 
   3.5148302019770584`*^9}, {3.514838390305911*^9, 3.514838390935912*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    RowBox[{"m", "/", "2"}]], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"m", "/", "2"}]]}]}], 
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    RowBox[{"m", "/", "2"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "/", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.4987607563116155`*^9, 3.498760763041625*^9}, {
   3.499305498308893*^9, 3.499305517262926*^9}, {3.5059666670951004`*^9, 
   3.505966716827945*^9}, {3.5061955618794093`*^9, 3.506195570159421*^9}, {
   3.5072431872612705`*^9, 3.5072432404261637`*^9}, {3.5072432976002645`*^9, 
   3.507243301266271*^9}, {3.5073303069156404`*^9, 3.507330321715661*^9}, {
   3.507442381782913*^9, 3.507442392375332*^9}, 3.5075807801865673`*^9, {
   3.5075809222567663`*^9, 3.5075809253967705`*^9}, {3.507581708877867*^9, 
   3.5075817131678734`*^9}, 3.507583132911872*^9, {3.507583209907988*^9, 
   3.5075832236516123`*^9}, {3.5075992725639963`*^9, 
   3.5075992769640017`*^9}, {3.510507751378793*^9, 3.510507771081628*^9}, 
   3.510508890991995*^9, {3.510508922036049*^9, 3.5105089452800903`*^9}, 
   3.5105089757001433`*^9, {3.5105110545409946`*^9, 3.510511103852681*^9}, {
   3.51051176345304*^9, 3.5105117985999017`*^9}, {3.5106043728536654`*^9, 
   3.510604416424542*^9}, {3.51060446662543*^9, 3.5106045234095297`*^9}, {
   3.5106045874476423`*^9, 3.5106045904272475`*^9}, {3.5106049685875115`*^9, 
   3.5106049732519197`*^9}, {3.510605507412458*^9, 3.5106055256644897`*^9}, {
   3.510607000643881*^9, 3.5106070113610997`*^9}, {3.5120865198388915`*^9, 
   3.512086541508922*^9}, {3.513040094785447*^9, 3.5130400955030484`*^9}, {
   3.513040157949958*^9, 3.5130401584179587`*^9}, {3.5146803431396713`*^9, 
   3.514680347339678*^9}, {3.5146804028697553`*^9, 3.514680410419766*^9}, {
   3.5146805372899437`*^9, 3.5146805512699633`*^9}, {3.515187545650221*^9, 
   3.515187576300264*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", "m"}], "*", 
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", "m"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "m"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "B"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"m", "^", "2"}], "-", 
      RowBox[{"1", "/", "4"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.4982401285726357`*^9, 3.4982401313526397`*^9}, {
   3.4987611327521424`*^9, 3.4987611393821516`*^9}, {3.4987611708821955`*^9, 
   3.498761277792345*^9}, {3.498761669522894*^9, 3.4987616788229065`*^9}, {
   3.4987619391432714`*^9, 3.498761943263277*^9}, {3.499183308350725*^9, 
   3.4991833124847326`*^9}, {3.499185161474782*^9, 3.499185164828788*^9}, {
   3.499305530288949*^9, 3.4993055385257635`*^9}, {3.505966844688258*^9, 
   3.50596686517743*^9}, {3.5059669219046745`*^9, 3.5059669229497347`*^9}, {
   3.50596738600922*^9, 3.5059673883963566`*^9}, {3.5061955820294375`*^9, 
   3.506195592559452*^9}, {3.507243361763177*^9, 3.5072433812008114`*^9}, {
   3.5073303887157545`*^9, 3.507330393995762*^9}, {3.507330454915848*^9, 
   3.50733048518589*^9}, {3.507330529445952*^9, 3.5073305427059703`*^9}, {
   3.507330812806349*^9, 3.507330823296363*^9}, {3.5073309520265436`*^9, 
   3.5073309814665847`*^9}, {3.5073313288470707`*^9, 
   3.5073313330470767`*^9}, {3.5073320683081064`*^9, 
   3.5073320876581335`*^9}, {3.5073327496090603`*^9, 
   3.5073327527890644`*^9}, {3.5073328122591476`*^9, 
   3.5073328126791487`*^9}, {3.5073328632292194`*^9, 
   3.5073328824192457`*^9}, {3.5073338298225737`*^9, 3.507333833852579*^9}, {
   3.5073961002459946`*^9, 3.5073961026559973`*^9}, {3.5074422952495613`*^9, 
   3.507442320646406*^9}, {3.5074424047149534`*^9, 3.5074424054637547`*^9}, {
   3.507442805760458*^9, 3.5074428128896704`*^9}, 3.5074861142120705`*^9, {
   3.5074864950826035`*^9, 3.507486496282605*^9}, {3.5074944863850803`*^9, 
   3.507494489973087*^9}, {3.5074963472513857`*^9, 3.507496349076589*^9}, {
   3.5075808096266084`*^9, 3.507580833566642*^9}, 3.507580978416845*^9, {
   3.507581788827979*^9, 3.50758179663799*^9}, {3.5075820427603455`*^9, 
   3.507582043290346*^9}, {3.507583272495298*^9, 3.507583311432966*^9}, {
   3.507599282044009*^9, 3.5075992908940215`*^9}, 3.5075993572241144`*^9, {
   3.507661921989708*^9, 3.507661925799713*^9}, {3.5076646483035245`*^9, 
   3.5076646494435263`*^9}, {3.510507847693362*^9, 3.510507881217821*^9}, {
   3.5105087569097595`*^9, 3.510508781089802*^9}, {3.510509139453631*^9, 
   3.5105091408108335`*^9}, {3.5105091901069202`*^9, 3.510509235112999*^9}, {
   3.510511179341214*^9, 3.5105111819776187`*^9}, {3.510511213442874*^9, 
   3.5105112341129103`*^9}, 3.5105113311138806`*^9, {3.5105118645592175`*^9, 
   3.5105118933724685`*^9}, 3.510604217243392*^9, {3.5106043604360437`*^9, 
   3.5106043628072476`*^9}, {3.510604536747553*^9, 3.510604543455565*^9}, {
   3.5106047214206777`*^9, 3.510604766535957*^9}, {3.51060501329719*^9, 
   3.51060503037922*^9}, {3.5106055112344646`*^9, 3.5106055178800764`*^9}, {
   3.5106070214075174`*^9, 3.510607029581932*^9}, {3.5106071384233227`*^9, 
   3.510607138610523*^9}, 3.512086681459118*^9, {3.512086750779215*^9, 
   3.512086759259227*^9}, {3.5120869327294693`*^9, 3.51208693298947*^9}, {
   3.512165308076564*^9, 3.512165352006625*^9}, {3.513038830378426*^9, 
   3.5130388348400335`*^9}, {3.513039419851462*^9, 3.513039428415877*^9}, {
   3.5130394743423576`*^9, 3.513039483437174*^9}, {3.5130396748483095`*^9, 
   3.513039691680739*^9}, {3.5130398913454895`*^9, 3.513039911360325*^9}, {
   3.513040025646126*^9, 3.513040027112528*^9}, {3.513040169384778*^9, 
   3.513040174985188*^9}, {3.513040240614503*^9, 3.5130402408797035`*^9}, {
   3.5130402920633936`*^9, 3.5130402932645955`*^9}, {3.514677604227768*^9, 
   3.5146776058177705`*^9}, {3.5146776372778144`*^9, 
   3.5146776603378468`*^9}, {3.514679324716182*^9, 3.5146793300461893`*^9}, {
   3.5146799305290937`*^9, 3.514679955229129*^9}, {3.5146804466098166`*^9, 
   3.514680458489833*^9}, {3.5146804988798895`*^9, 3.5146805033598957`*^9}, {
   3.514680612650049*^9, 3.514680642640091*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "7"}], "-", "8"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511617733184*^9, 3.510511622272792*^9}, 
   3.5111158844118*^9, {3.5111203140380015`*^9, 3.5111203142280016`*^9}, {
   3.5121540095122423`*^9, 3.5121540162022514`*^9}, 3.513040529745411*^9, 
   3.5148304396073914`*^9, {3.514838597566201*^9, 3.514838599046203*^9}, {
   3.51518765183037*^9, 3.515187653760372*^9}, 3.5151961495616226`*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 5 with ",
 Cell[BoxData[
  RowBox[{"a", "=", "1"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"b", "=", "0"}]]],
 " and  ",
 Cell[BoxData[
  RowBox[{"n", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017236918158064`*^9, 3.5017236959186134`*^9}, 
   3.503014859355447*^9, {3.50301718243629*^9, 3.5030172032263184`*^9}, 
   3.505677202804861*^9, {3.5099345182965794`*^9, 3.5099345191065807`*^9}, {
   3.5099387367264876`*^9, 3.5099387455765*^9}, 3.5120642608923984`*^9, {
   3.5141577257023115`*^9, 3.514157736552327*^9}}],

Cell[TextData[{
 "Rule 7: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "<", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4992133873636045`*^9, 3.4992133892036066`*^9}, {3.4992162641476316`*^9, 
   3.499216265707634*^9}, {3.4993685410928354`*^9, 3.4993685488628464`*^9}, {
   3.50031970240469*^9, 3.5003197069046965`*^9}, {3.5004320341975737`*^9, 
   3.5004320353096375`*^9}, {3.5026784535032854`*^9, 3.502678461573297*^9}, {
   3.5027657904804587`*^9, 3.5027657904804587`*^9}, {3.5027672190193686`*^9, 
   3.5027672190193686`*^9}, {3.5035496199411335`*^9, 
   3.5035496486311736`*^9}, {3.504028649276944*^9, 3.5040286502597466`*^9}, 
   3.50403187501501*^9, 3.5043107662485094`*^9, {3.5047476342426376`*^9, 
   3.504747635372639*^9}, {3.509473798840955*^9, 3.509473798840955*^9}, {
   3.509934658346775*^9, 3.5099346733567963`*^9}, 3.509938528846196*^9, {
   3.5099390241689568`*^9, 3.509939026446561*^9}, {3.5099391248983335`*^9, 
   3.509939129625142*^9}, {3.5101741545371675`*^9, 3.5101741545371675`*^9}, {
   3.5101804637230964`*^9, 3.510180464175497*^9}, {3.5104307281279087`*^9, 
   3.5104307283379087`*^9}, {3.510596793572122*^9, 3.5105967962521257`*^9}, {
   3.5105973346061244`*^9, 3.5105973348661246`*^9}, {3.5105983595375595`*^9, 
   3.5105983595375595`*^9}, {3.511721168434842*^9, 3.511721168434842*^9}, {
   3.512153856312028*^9, 3.512153856982029*^9}, {3.5121539269621267`*^9, 
   3.512153929892131*^9}, 3.513052839510186*^9, 3.514838602356208*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"A", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "1"}], "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "+", 
       RowBox[{"j", " ", "k"}]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"B", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
       RowBox[{"A", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "3"}], "2"]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], " ", ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, 
   3.4991797926481485`*^9, {3.4991798252678056`*^9, 3.499179837935028*^9}, {
   3.499180927976143*^9, 3.499180938599762*^9}, {3.4991810132614927`*^9, 
   3.4991810250395136`*^9}, {3.4991962578715715`*^9, 
   3.4991962790096083`*^9}, {3.499196703083153*^9, 3.4991967615208554`*^9}, {
   3.499197192643613*^9, 3.499197222845266*^9}, {3.4991977240625467`*^9, 
   3.4991977407233753`*^9}, {3.499197780737446*^9, 3.4991977890990605`*^9}, {
   3.4991980290346823`*^9, 3.4991980546967273`*^9}, {3.499198191403367*^9, 
   3.499198208017396*^9}, {3.499198305326367*^9, 3.4991983055447674`*^9}, {
   3.499198375223689*^9, 3.4991983899189153`*^9}, 3.499198439702202*^9, {
   3.4992136675539966`*^9, 3.4992137193140693`*^9}, 3.499213754044118*^9, {
   3.4992161931675324`*^9, 3.499216193677533*^9}, {3.4992162414576*^9, 
   3.4992163332577286`*^9}, {3.4992164987579603`*^9, 
   3.4992165531380367`*^9}, {3.4993646678093863`*^9, 
   3.4993647284894705`*^9}, {3.499364780039543*^9, 3.499364804929578*^9}, {
   3.499364846769636*^9, 3.4993648633396597`*^9}, {3.499404320916315*^9, 
   3.499404323956319*^9}, {3.499404813317004*^9, 3.499404815097007*^9}, {
   3.5003179817729173`*^9, 3.5003179820537176`*^9}, 3.5003181967000947`*^9, 
   3.505344641443784*^9, {3.505344693233857*^9, 3.5053447150538874`*^9}, 
   3.5053535583452115`*^9, {3.509473422445426*^9, 3.5094734793846827`*^9}, {
   3.509473628380205*^9, 3.5094737191313953`*^9}, {3.509934575406659*^9, 
   3.5099346370467453`*^9}, {3.509934700046834*^9, 3.509934715466855*^9}, {
   3.50993518320751*^9, 3.5099351838075113`*^9}, {3.509938539656212*^9, 
   3.5099385963962913`*^9}, {3.510173955262418*^9, 3.5101739813768635`*^9}, {
   3.514160488306179*^9, 3.5141604911561832`*^9}, {3.514853861614709*^9, 
   3.5148539075723896`*^9}, {3.515187660650382*^9, 3.5151876631703854`*^9}, {
   3.517073753786433*^9, 3.517073789120495*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k"}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"B", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{"A", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "B"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.4991796252286544`*^9, 3.499179629191061*^9}, {
   3.4991799423928113`*^9, 3.499179956230036*^9}, {3.499179994189703*^9, 
   3.49918001520294*^9}, 3.4991802628689747`*^9, {3.4991809464777756`*^9, 
   3.499180955822192*^9}, {3.499181041294742*^9, 3.499181080638011*^9}, 
   3.4991882648154335`*^9, {3.4992137616941285`*^9, 3.4992137626741295`*^9}, 
   3.4992139059543304`*^9, {3.4992140832345786`*^9, 3.4992141086946144`*^9}, 
   3.499214216934766*^9, {3.499216208717554*^9, 3.4992162138475614`*^9}, {
   3.4992164326178675`*^9, 3.499216489837948*^9}, {3.499216616588125*^9, 
   3.4992166411581593`*^9}, 3.4992167074782524`*^9, {3.499216790438369*^9, 
   3.4992167911383696`*^9}, 3.499216873638485*^9, {3.4993649181097364`*^9, 
   3.4993649626097984`*^9}, {3.499365011309867*^9, 3.4993650116798673`*^9}, {
   3.499365165120082*^9, 3.499365167950086*^9}, {3.4993654481904783`*^9, 
   3.499365494270543*^9}, {3.4993661831115074`*^9, 3.499366184461509*^9}, {
   3.5003179820849175`*^9, 3.500317982365718*^9}, 3.5003187900234127`*^9, {
   3.5003190903738327`*^9, 3.5003191035638514`*^9}, 3.5003192263540235`*^9, 
   3.5003207542961626`*^9, {3.5003443675174456`*^9, 3.5003443741274548`*^9}, {
   3.5004320294293013`*^9, 3.5004320304863615`*^9}, {3.501043261265483*^9, 
   3.501043262773569*^9}, 3.50267712088142*^9, {3.5026774368118625`*^9, 
   3.502677454531887*^9}, 3.502765652732217*^9, 3.502767119506794*^9, {
   3.503071848758074*^9, 3.503071858708088*^9}, {3.503071992168275*^9, 
   3.5030719924982753`*^9}, {3.5035495943210974`*^9, 
   3.5035496113511214`*^9}, {3.504156566262847*^9, 3.5041565676356487`*^9}, 
   3.505344641463784*^9, {3.505344693263857*^9, 3.505344715073887*^9}, 
   3.505353560095214*^9, 3.50947378686127*^9, {3.509473818845099*^9, 
   3.509473822845328*^9}, 3.5094739102633276`*^9, 3.5099352328575797`*^9, 
   3.5099352665776267`*^9, 3.509935343097734*^9, {3.5099360765987606`*^9, 
   3.509936089578779*^9}, {3.5099369144199343`*^9, 3.5099369145899343`*^9}, 
   3.509936945449977*^9, 3.5099379641334047`*^9, 3.509938088693579*^9, {
   3.509938569036253*^9, 3.509938569246253*^9}, {3.509938650976368*^9, 
   3.5099386512163677`*^9}, {3.509938683576413*^9, 3.5099387145864563`*^9}, {
   3.5099389979453106`*^9, 3.509939001127716*^9}, {3.50993913410235*^9, 
   3.509939134663951*^9}, {3.510174197608843*^9, 3.5101742466865296`*^9}, 
   3.5101804715855103`*^9, {3.5101817224505076`*^9, 3.510181731779324*^9}, {
   3.5105967831221075`*^9, 3.5105967855521107`*^9}, {3.510597265166027*^9, 
   3.5105972655460277`*^9}, 3.510598342257535*^9, 3.510607992634023*^9, {
   3.5106107550556755`*^9, 3.5106107603752847`*^9}, 3.5106112886078124`*^9, {
   3.510626128422782*^9, 3.510626130996787*^9}, {3.5106264132828827`*^9, 
   3.5106264134544826`*^9}, {3.510626450629348*^9, 3.5106264516901493`*^9}, 
   3.5141604580361366`*^9, {3.514853960476883*^9, 3.5148539915053377`*^9}, {
   3.514854040739024*^9, 3.514854041222625*^9}, 3.516667357826965*^9, 
   3.5168207036265283`*^9, {3.516842602129083*^9, 3.516842642588397*^9}, {
   3.5168433328568783`*^9, 3.5168433390152307`*^9}, {3.517073825608959*^9, 
   3.5170738531430073`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 3b with ",
 Cell[BoxData[
  RowBox[{"n", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, {
   3.505866068185237*^9, 3.505866068655238*^9}, 3.5058664962858367`*^9, {
   3.509986401026863*^9, 3.5099864013768635`*^9}, 3.512064224502348*^9, {
   3.5141578450024786`*^9, 3.5141578490424843`*^9}, {3.514158119172862*^9, 
   3.5141581235428686`*^9}}],

Cell[TextData[{
 "Rule 8: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], ">", "0"}], " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["m", "2"], "\[NotEqual]", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.500410576940289*^9, 3.5004105779663477`*^9}, {
   3.5004106327664824`*^9, 3.500410643898119*^9}, {3.500429569940626*^9, 
   3.500429571675726*^9}, {3.502204840167862*^9, 3.502204842617066*^9}, 
   3.5023038294281306`*^9, {3.502304233812041*^9, 3.502304236136445*^9}, {
   3.502304759361364*^9, 3.5023047597201643`*^9}, {3.5043626668289185`*^9, 
   3.5043626677489195`*^9}, {3.5043646583713655`*^9, 3.5043646586613655`*^9}, 
   3.504983272623348*^9, {3.50998709885784*^9, 3.509987106607851*^9}, {
   3.5100062419539967`*^9, 3.510006272514039*^9}, 3.510010796070372*^9, {
   3.510174143882349*^9, 3.5101741470023546`*^9}, {3.5101804759067183`*^9, 
   3.5101804893071413`*^9}, {3.5104307316379137`*^9, 3.510430731807914*^9}, {
   3.5105973261861124`*^9, 3.5105973292861166`*^9}, {3.511721178384856*^9, 
   3.511721178384856*^9}, {3.5121538603520336`*^9, 3.5121538614720345`*^9}, {
   3.5121539389621434`*^9, 3.512153939172144*^9}, {3.5122503382905245`*^9, 
   3.512250350645746*^9}, {3.5130307579294443`*^9, 3.5130307579294443`*^9}, 
   3.513052842850191*^9, {3.514688167894765*^9, 3.514688167894765*^9}, {
   3.514694752832763*^9, 3.514694753799965*^9}, 3.514838605806213*^9, {
   3.5148391701670027`*^9, 3.514839181807019*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"B", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "1"}], "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "-", 
       RowBox[{"j", " ", "k"}]}]], "  ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"B", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "-", "1"}], "2"]}], ")"}]}], "+", 
       RowBox[{"A", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5030149938276834`*^9, 
   3.5030149992252927`*^9}, 3.505344641363784*^9, {3.505344693023856*^9, 
   3.5053447149738874`*^9}, 3.5053535459551945`*^9, {3.5094696268243294`*^9, 
   3.509469698805446*^9}, {3.509469791674758*^9, 3.509469802752392*^9}, {
   3.509469914234768*^9, 3.5094699164558954`*^9}, {3.509470445456152*^9, 
   3.509470483604334*^9}, {3.5094706454305897`*^9, 3.50947066641179*^9}, {
   3.5094707559529114`*^9, 3.5094707698497066`*^9}, 3.5094708527324467`*^9, {
   3.5094710367959747`*^9, 3.5094710383620644`*^9}, 3.5094711873785877`*^9, 
   3.5094801966418877`*^9, {3.5099865155570235`*^9, 3.509986761477368*^9}, {
   3.509986860137506*^9, 3.5099869091975746`*^9}, {3.5101740450405755`*^9, 
   3.510174069392218*^9}, {3.5148538677299194`*^9, 3.5148538694459224`*^9}, {
   3.514853915434803*^9, 3.514853935657239*^9}, {3.5151876658603897`*^9, 
   3.515187668210393*^9}, {3.517073796171707*^9, 3.517073813503338*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "B"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
      "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", "\n", 
      "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"B", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", "*", "k", "*", "m"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
           RowBox[{"A", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", "*", "k", "*", "m"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "B"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], ">", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "^", "2"}], "\[NotEqual]", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 3.5018079845979548`*^9}, 
   3.501808368327429*^9, {3.5018084216015224`*^9, 3.501808427217532*^9}, {
   3.501819528072632*^9, 3.50181953253424*^9}, {3.5018203432520638`*^9, 
   3.501820344032065*^9}, {3.501881265548032*^9, 3.5018812668180337`*^9}, 
   3.501954460051543*^9, 3.501971563043559*^9, 3.5019827456029906`*^9, {
   3.50214074052378*^9, 3.502140747840193*^9}, {3.5021450168361893`*^9, 
   3.5021450210561953`*^9}, {3.5021460089975786`*^9, 3.502146012607583*^9}, {
   3.502153532412318*^9, 3.502153535502322*^9}, {3.50216125483313*^9, 
   3.502161259523136*^9}, {3.502162868575389*^9, 3.502162875845399*^9}, {
   3.502202835273939*^9, 3.502202835492339*^9}, {3.502203167621723*^9, 
   3.5022032332978387`*^9}, {3.502297742162639*^9, 3.5022977428490405`*^9}, {
   3.502298208119858*^9, 3.502298209024659*^9}, {3.502298632971004*^9, 
   3.502298633751005*^9}, 3.5023047825586047`*^9, 3.5023048356766977`*^9, {
   3.502304911817232*^9, 3.502304913174434*^9}, {3.503260889555503*^9, 
   3.5032608960451145`*^9}, {3.503260948102406*^9, 3.5032609516904125`*^9}, {
   3.503261011126517*^9, 3.503261015712925*^9}, {3.5099870734078045`*^9, 
   3.509987083807819*^9}, {3.5099876947586746`*^9, 3.5099877101386957`*^9}, {
   3.5099877862788024`*^9, 3.50998779175881*^9}, 3.510011502991362*^9, {
   3.51017418428642*^9, 3.5101742072808604`*^9}, {3.510174311239443*^9, 
   3.5101743228926635`*^9}, {3.5101804939091496`*^9, 
   3.5101805080895743`*^9}, {3.5101833911186385`*^9, 3.5101834335963125`*^9}, 
   3.510597169545893*^9, 3.5105972779360447`*^9, 3.5105983351775255`*^9, {
   3.510600225090171*^9, 3.510600254380212*^9}, {3.510609660666953*^9, 
   3.5106096647853603`*^9}, {3.5106097415842953`*^9, 
   3.5106097440178995`*^9}, {3.510610139384994*^9, 3.5106101422553988`*^9}, {
   3.510610535032889*^9, 3.510610537497693*^9}, {3.510610669380325*^9, 
   3.510610669567525*^9}, {3.510610707569192*^9, 3.5106107082555933`*^9}, 
   3.5106112920086184`*^9, {3.5106261401852026`*^9, 3.510626164443246*^9}, {
   3.510626498022231*^9, 3.5106264998630342`*^9}, 3.5130305639899035`*^9, 
   3.5146881210322824`*^9, {3.514688291134981*^9, 3.514688296688591*^9}, 
   3.514694744330748*^9, {3.514832433128267*^9, 3.514832444928283*^9}, {
   3.514832501312375*^9, 3.514832534152421*^9}, {3.514839124416939*^9, 
   3.5148391408269615`*^9}, {3.5148539993833513`*^9, 
   3.5148540205837884`*^9}, {3.5148540516902432`*^9, 3.5148540525482445`*^9}, 
   3.5166673636925755`*^9, 3.516820703636528*^9, {3.517073858603017*^9, 
   3.517073874951846*^9}, 3.5170739082111044`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{
          SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["k", "2"], "=", "1"}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5026719192141376`*^9, 
   3.5026719206441393`*^9}, {3.5027639618236465`*^9, 3.5027639715424633`*^9}, 
   3.5040443744413013`*^9, 3.5047258778634586`*^9, 3.5047259304635324`*^9, {
   3.5047296968488054`*^9, 3.5047297039888153`*^9}, {3.5047304827399054`*^9, 
   3.5047304905499163`*^9}, {3.5053445891537113`*^9, 3.505344590523713*^9}, {
   3.5100199895018682`*^9, 3.5100200070206995`*^9}, {3.510020038236354*^9, 
   3.510020038236354*^9}, {3.510170385415208*^9, 3.510170385415208*^9}, {
   3.5101743640143356`*^9, 3.5101743640143356`*^9}, {3.510419516272189*^9, 
   3.5104195312022095`*^9}, {3.51344405045832*^9, 3.513444050888321*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["c",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5122512996358128`*^9, 3.512251303067819*^9}, {
   3.5122570707311516`*^9, 3.512257070980752*^9}, {3.514662688791566*^9, 
   3.5146626901015677`*^9}, {3.51476385339592*^9, 3.514763854025921*^9}, 
   3.514839222267076*^9, {3.515187701090439*^9, 3.5151877015704393`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 3a with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", "1"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, {
   3.5049231258994436`*^9, 3.504923126359444*^9}, 3.504923176059514*^9, 
   3.505345123284459*^9, 3.512064237812366*^9, {3.5130548358249903`*^9, 
   3.513054840454997*^9}, {3.5141583179931407`*^9, 3.514158320583144*^9}, {
   3.514158400413256*^9, 3.514158416833279*^9}, {3.5141585703134937`*^9, 
   3.51415858905352*^9}, 3.5141587735537786`*^9}],

Cell[TextData[{
 "Rule c: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018079315890617`*^9, 
   3.5018079522746983`*^9}, {3.5018088942823524`*^9, 3.5018088954991546`*^9}, 
   3.50180892701121*^9, {3.501812061374316*^9, 3.501812073838738*^9}, 
   3.5018863542456627`*^9, 3.5018867160661693`*^9, 3.5018867827462626`*^9, {
   3.504365459732487*^9, 3.5043654610124893`*^9}, 3.5043678305478106`*^9, {
   3.504371105022394*^9, 3.504371105262395*^9}, {3.5044712437106595`*^9, 
   3.504471245530662*^9}, {3.504983291663375*^9, 3.504983292633376*^9}, {
   3.510009988719242*^9, 3.5100099974392543`*^9}, {3.510505212253933*^9, 
   3.5105052130495343`*^9}, {3.5122511894872193`*^9, 3.512251190516821*^9}, 
   3.514839224797079*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", " ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "a", " ", "A"}], "+", 
          RowBox[{"b", " ", "B", 
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}]}]}], ")"}], "x"}], "4"]}]}]}]}], 
  "-", 
  FractionBox[
   RowBox[{"2", "b", " ", "B", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], 
   RowBox[{"d", 
    RowBox[{"(", 
     RowBox[{"k", "+", "3"}], ")"}]}]], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"b", " ", "A"}], "+", 
     RowBox[{"a", " ", "B"}]}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "k"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501807660242185*^9, 3.5018076682761993`*^9}, {3.5018077767119894`*^9, 
   3.5018078381604977`*^9}, {3.501807870358954*^9, 3.5018078706397543`*^9}, {
   3.5018085031116657`*^9, 3.5018086153694625`*^9}, {3.5018087435704875`*^9, 
   3.5018087487340965`*^9}, {3.501808975870496*^9, 3.5018090631370487`*^9}, {
   3.5018862142654667`*^9, 3.5018863148756075`*^9}, {3.5018865378659196`*^9, 
   3.5018865717259674`*^9}, {3.5051544316431403`*^9, 3.505154494253228*^9}, {
   3.5053446405237827`*^9, 3.505344640533783*^9}, {3.505344690673853*^9, 
   3.505344714153886*^9}, {3.5053519968430257`*^9, 3.505351998513028*^9}, {
   3.509895226973665*^9, 3.5098952272336655`*^9}, {3.5100083414469357`*^9, 
   3.510008346106942*^9}, {3.510008406587027*^9, 3.510008449397087*^9}, {
   3.510008606537307*^9, 3.5100086077073083`*^9}, {3.5100087248674726`*^9, 
   3.5100087336874847`*^9}, {3.5100088392076325`*^9, 3.510008843127638*^9}, {
   3.5100089619978046`*^9, 3.510009053057932*^9}, {3.5100091013379993`*^9, 
   3.510009150148068*^9}, {3.5100092196281652`*^9, 3.5100092204681664`*^9}, 
   3.510009321598308*^9, {3.5100093775483866`*^9, 3.5100094043384237`*^9}, {
   3.5100094516384897`*^9, 3.5100094558184958`*^9}, 3.510009834599026*^9, 
   3.510010050049328*^9, {3.5130525209297404`*^9, 3.5130525231897435`*^9}, {
   3.5151877024404407`*^9, 3.5151877039604425`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", "*", "a", "*", "A"}], "+", 
       RowBox[{"b", "*", "B", "*", 
        RowBox[{"(", 
         RowBox[{"k", "+", "1"}], ")"}]}]}], ")"}], "*", 
     RowBox[{"x", "/", "4"}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "*", "b", "*", "B", "*", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "*", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"(", 
        RowBox[{"k", "+", "3"}], ")"}]}], ")"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "A"}], "+", 
       RowBox[{"a", "*", "B"}]}], ")"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ",", "x"}], "]"}]}]}],
    " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018079781707435`*^9, 
   3.5018079845979548`*^9}, {3.501808142938233*^9, 3.501808157227858*^9}, {
   3.501808857045087*^9, 3.501808860570693*^9}, {3.501808898962361*^9, 
   3.501808916137991*^9}, {3.5018091789952526`*^9, 3.5018091989008875`*^9}, {
   3.501819685414508*^9, 3.501819688050913*^9}, {3.5018866309060497`*^9, 
   3.501886700176147*^9}, 3.501886800256287*^9, {3.503118899764467*^9, 
   3.503118916799697*^9}, {3.5031574990976562`*^9, 3.503157503840064*^9}, {
   3.5046423326413803`*^9, 3.504642339981391*^9}, 3.5046424228515067`*^9, {
   3.5046426988618927`*^9, 3.50464271107191*^9}, {3.5053446405437827`*^9, 
   3.5053446405437827`*^9}, {3.5053446906938534`*^9, 
   3.5053447141738863`*^9}, {3.505352007973041*^9, 3.505352018683056*^9}, {
   3.505352074223134*^9, 3.505352074893135*^9}, {3.5098952305136704`*^9, 
   3.5098952309636707`*^9}, {3.510009965059209*^9, 3.510009967019212*^9}, {
   3.5100105690500546`*^9, 3.5100106192301245`*^9}, 3.5104305269376273`*^9, 
   3.510515204946285*^9, 3.513046586827976*^9, {3.51305252758975*^9, 
   3.513052529369752*^9}, {3.5130542609941854`*^9, 3.5130542658541927`*^9}, {
   3.5130552682355957`*^9, 3.5130552715656004`*^9}, 3.5148247824971333`*^9, 
   3.5168211627171707`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["d",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, {
   3.512256142654321*^9, 3.512256144947525*^9}, {3.5122561871143994`*^9, 
   3.512256229733674*^9}, {3.5144137669500422`*^9, 3.514413768119109*^9}, {
   3.5144144744945116`*^9, 3.5144144750495434`*^9}, 3.51483926055713*^9, {
   3.5151877086104493`*^9, 3.51518770912045*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, {3.4979866726025763`*^9, 
   3.497986673616578*^9}, {3.5006614307985444`*^9, 3.5006614323585463`*^9}}],

Cell[TextData[{
 "Basis:",
 " If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "A"}], "-", 
    RowBox[{"a", " ", "B"}]}], "=", "0"}]]],
 ", then",
 " ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", "z"}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}]], "=", 
   FractionBox["B", "b"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.497989934892706*^9, 
   3.49798993732631*^9}, {3.5006615536287165`*^9, 3.5006615979187784`*^9}, {
   3.5027670038793907`*^9, 3.5027670131458073`*^9}, {3.5027679251438093`*^9, 
   3.5027679269222126`*^9}, {3.514414512561689*^9, 3.514414520547146*^9}}],

Cell[TextData[{
 "Rule d1: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}]}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.497990130017849*^9, 3.497990130017849*^9}, {3.49843802295825*^9, 
   3.49843802295825*^9}, {3.498674382973672*^9, 3.498674382973672*^9}, {
   3.49867446038378*^9, 3.498674488383819*^9}, {3.498677308017767*^9, 
   3.4986773174477797`*^9}, 3.500661530668684*^9, 3.5006616774488897`*^9, {
   3.504983348793455*^9, 3.5049833534434614`*^9}, {3.5104559200937495`*^9, 
   3.5104559335737686`*^9}, {3.510505215498739*^9, 3.51050521598234*^9}, {
   3.512256822862316*^9, 3.512256827230324*^9}, {3.514413430650807*^9, 
   3.5144134393783064`*^9}, {3.5144141286487303`*^9, 
   3.5144141301528163`*^9}, {3.514414453339301*^9, 3.514414453543313*^9}, {
   3.5144145639406276`*^9, 3.5144145682868757`*^9}, {3.514641157278159*^9, 
   3.5146411584013615`*^9}, {3.514839262407132*^9, 3.514839263197133*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"B", " ", "x"}], "b"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497986264165859*^9, 3.4979862650706606`*^9}, {
   3.50065955661592*^9, 3.500659559295924*^9}, {3.5006614622785883`*^9, 
   3.5006614724286027`*^9}, {3.505344690603853*^9, 3.505344690603853*^9}, {
   3.509895238753682*^9, 3.509895241013685*^9}, {3.510455839463637*^9, 
   3.5104558434336424`*^9}, {3.5144143567727785`*^9, 3.5144143642562065`*^9}, 
   3.5144144456568623`*^9, {3.515187709760451*^9, 3.5151877103104515`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"B", "*", 
    RowBox[{"x", "/", "b"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, {3.497986265944262*^9, 3.497986266927064*^9}, 
   3.4979863675440407`*^9, {3.4979898830226145`*^9, 3.497989898497842*^9}, 
   3.498679361436646*^9, {3.5006592743055253`*^9, 3.5006592786455317`*^9}, {
   3.5006615196186686`*^9, 3.5006615252886767`*^9}, {3.5006616594288645`*^9, 
   3.5006616867589025`*^9}, 3.5012666522100496`*^9, {3.505344690613853*^9, 
   3.505344690623853*^9}, {3.509895241823686*^9, 3.5098952424836874`*^9}, {
   3.510455878063691*^9, 3.5104558800736933`*^9}, {3.51045594181378*^9, 
   3.5104559554637995`*^9}, {3.5114602677280397`*^9, 
   3.5114602739180484`*^9}, {3.5130464938278465`*^9, 3.5130464972178507`*^9}, 
   3.514413417801072*^9, {3.5144141233954296`*^9, 3.5144141249175167`*^9}, 
   3.5144143492203465`*^9, {3.5144145898611097`*^9, 3.5144146158915987`*^9}, 
   3.516821165077174*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.551.2", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, {3.4979864214265356`*^9, 
   3.497986422409337*^9}, {3.50535441443641*^9, 3.5053544148464108`*^9}}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, {3.4979864214265356`*^9, 
   3.497986422409337*^9}, {3.4979866389377174`*^9, 3.49798665193254*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", "z"}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}]], "=", 
   RowBox[{
    FractionBox["B", "b"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}]}], 
     RowBox[{"b", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.510456932005166*^9, 3.510456936635173*^9}}],

Cell[TextData[{
 "Rule d2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497663553088928*^9, 3.4976635622149444`*^9}, {
   3.4979894880299215`*^9, 3.4979894894339237`*^9}, {3.5043655322225885`*^9, 
   3.50436553318259*^9}, 3.5043711377624407`*^9, 3.504469700248499*^9, 
   3.504986690178133*^9, {3.5104560807139745`*^9, 3.5104560807139745`*^9}, {
   3.5104568937951126`*^9, 3.5104568953851147`*^9}, {3.510505219757546*^9, 
   3.5105052199759464`*^9}, {3.512254387989639*^9, 3.5122543889880404`*^9}, 
   3.512255731234799*^9, {3.5122561484263315`*^9, 3.512256149221933*^9}, {
   3.514641160772566*^9, 3.5146411614745665`*^9}, {3.514839265757137*^9, 
   3.514839266367138*^9}, {3.516589003639002*^9, 3.516589003639002*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"B", " ", "x"}], "b"]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979862492990327`*^9, 
   3.4979862502662344`*^9}, {3.497987000218752*^9, 3.4979870022311554`*^9}, {
   3.5053446902338524`*^9, 3.5053446902338524`*^9}, {3.509895243243688*^9, 
   3.5098952441236897`*^9}, {3.510456131784046*^9, 3.5104561346040497`*^9}, {
   3.5104568997651215`*^9, 3.5104569042851276`*^9}, {3.5151877148704576`*^9, 
   3.5151877159404593`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"B", "*", 
     RowBox[{"x", "/", "b"}]}], " ", "+", " ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "A"}], "-", 
         RowBox[{"a", "*", "B"}]}], ")"}], "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.497986253963441*^9, 
   3.4979862552738433`*^9}, 3.4979863375295877`*^9, {3.497986505495083*^9, 
   3.497986507819487*^9}, {3.49798706165166*^9, 3.497987068765272*^9}, {
   3.497987706708393*^9, 3.497987708642796*^9}, {3.4979879276983805`*^9, 
   3.497987930365986*^9}, 3.4979880679114275`*^9, 3.498497171646879*^9, {
   3.5053446902438526`*^9, 3.5053446902538524`*^9}, {3.509895249233697*^9, 
   3.5098952515737*^9}, 3.509897436117895*^9, 3.5104305387476435`*^9, 
   3.5104337771841784`*^9, {3.510456046673927*^9, 3.510456071713962*^9}, {
   3.5104568899251075`*^9, 3.5104569155951433`*^9}, 3.510505721922428*^9, {
   3.512256405077982*^9, 3.512256405608383*^9}, 3.51304661790802*^9, 
   3.5130469591284976`*^9, {3.513609435095108*^9, 3.513609444673525*^9}, {
   3.5136099353074865`*^9, 3.5136099484375052`*^9}, 3.516588993598988*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, {3.4979864214265356`*^9, 
   3.497986422409337*^9}, {3.4979866389377174`*^9, 3.49798665193254*^9}, {
   3.51198092332861*^9, 3.5119809284639034`*^9}, {3.513609260172001*^9, 
   3.513609261622803*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", "/", "z"}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", "/", "z"}]}]], "=", 
   RowBox[{
    FractionBox["A", "a"], "-", 
    FractionBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "A"}], "-", 
       RowBox[{"a", " ", "B"}]}], ")"}], 
     RowBox[{"a", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.510456932005166*^9, 3.510456936635173*^9}, {
   3.5136092874564486`*^9, 3.5136093125100927`*^9}, {3.5142277010546503`*^9, 
   3.514227718791881*^9}}],

Cell[TextData[{
 "Rule d3: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497663553088928*^9, 3.4976635622149444`*^9}, {
   3.4979894880299215`*^9, 3.4979894894339237`*^9}, {3.5043655322225885`*^9, 
   3.50436553318259*^9}, 3.5043711377624407`*^9, 3.504469700248499*^9, 
   3.504986690178133*^9, {3.5104560807139745`*^9, 3.5104560807139745`*^9}, {
   3.5104568937951126`*^9, 3.5104568953851147`*^9}, {3.510505219757546*^9, 
   3.5105052199759464`*^9}, {3.512254387989639*^9, 3.5122543889880404`*^9}, 
   3.512255731234799*^9, {3.5122561484263315`*^9, 3.512256149221933*^9}, {
   3.5122563619439063`*^9, 3.512256362614708*^9}, {3.514641164376172*^9, 
   3.5146411652497735`*^9}, {3.514737218835315*^9, 3.514737218835315*^9}, {
   3.514839268817141*^9, 3.514839269437142*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"A", " ", "x"}], "a"]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"b", "+", 
       RowBox[{"a", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979862492990327`*^9, 
   3.4979862502662344`*^9}, {3.497987000218752*^9, 3.4979870022311554`*^9}, {
   3.5053446902338524`*^9, 3.5053446902338524`*^9}, {3.509895243243688*^9, 
   3.5098952441236897`*^9}, {3.510456131784046*^9, 3.5104561346040497`*^9}, {
   3.5104567717849417`*^9, 3.510456808194993*^9}, {3.511980873398754*^9, 
   3.5119809155401645`*^9}, {3.513609169847842*^9, 3.5136092275679436`*^9}, 
   3.5142276897290297`*^9, {3.5151877287104774`*^9, 3.5151877417404957`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "*", 
     RowBox[{"x", "/", "a"}]}], " ", "-", " ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "A"}], "-", 
         RowBox[{"a", "*", "B"}]}], ")"}], "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"a", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.497986253963441*^9, 
   3.4979862552738433`*^9}, 3.4979863375295877`*^9, {3.497986505495083*^9, 
   3.497986507819487*^9}, {3.49798706165166*^9, 3.497987068765272*^9}, {
   3.497987706708393*^9, 3.497987708642796*^9}, {3.4979879276983805`*^9, 
   3.497987930365986*^9}, 3.4979880679114275`*^9, 3.498497171646879*^9, {
   3.5053446902438526`*^9, 3.5053446902538524`*^9}, {3.509895249233697*^9, 
   3.5098952515737*^9}, 3.509897436117895*^9, 3.5104305387476435`*^9, 
   3.5104337771841784`*^9, {3.510456046673927*^9, 3.510456071713962*^9}, {
   3.51045684185504*^9, 3.5104568751650867`*^9}, 3.5104570887053857`*^9, 
   3.510505800967767*^9, {3.51050583687903*^9, 3.5105058468630476`*^9}, {
   3.511980955100427*^9, 3.5119809773386993`*^9}, 3.511981056695238*^9, 
   3.512256347513881*^9, 3.513046627978034*^9, 3.513609526136868*^9, {
   3.513609954837514*^9, 3.5136099644775276`*^9}, 3.514227750615937*^9, 
   3.514260090007335*^9, {3.5147343166710167`*^9, 3.514734321366625*^9}, {
   3.5147371398055763`*^9, 3.514737143362383*^9}, 3.5147371861376576`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["e",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509853498085*^9}, {3.5121867835994377`*^9, 3.5121867889346466`*^9}, {
   3.5122544619337687`*^9, 3.512254474538591*^9}, {3.5122562056628323`*^9, 
   3.512256209001238*^9}, {3.512257002247031*^9, 3.5122570123090487`*^9}, {
   3.5122587557109146`*^9, 3.512258757286517*^9}, {3.5148392850671635`*^9, 
   3.514839286577166*^9}, {3.514848353299031*^9, 3.514848355795035*^9}, {
   3.5151877481305046`*^9, 3.5151877484705048`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, {3.497986739620294*^9, 
   3.497986740665496*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", "z"}]}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "z"}]}]]], "=", 
   RowBox[{
    RowBox[{
     FractionBox["B", "b"], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}]]}], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "A"}], "-", 
        RowBox[{"a", " ", "B"}]}], ")"}], "b"], 
     FractionBox["1", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979901569434958`*^9, 
   3.4979901589402995`*^9}, {3.498674630504018*^9, 3.49867468184409*^9}}],

Cell[TextData[{
 "Rule e: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.497990130017849*^9, 3.497990130017849*^9}, {3.49843802295825*^9, 
   3.49843802295825*^9}, {3.4986746031239796`*^9, 3.498674605653983*^9}, {
   3.504365650162754*^9, 3.504365651122755*^9}, 3.5043706222317185`*^9, 
   3.5043711413524456`*^9, 3.504469709868512*^9, 3.5049866981881447`*^9, {
   3.5104561955541353`*^9, 3.5104561955541353`*^9}, {3.5105096959690084`*^9, 
   3.5105096975758114`*^9}, {3.5121871754221277`*^9, 3.51218717652973*^9}, {
   3.5122544319505157`*^9, 3.5122544327617173`*^9}, 3.512258845192672*^9, {
   3.514839288397168*^9, 3.51483928921717*^9}, 3.5148569448761263`*^9, {
   3.5150014793992767`*^9, 3.5150014793992767`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["B", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.498674512223852*^9, 3.4986745900339613`*^9}, {
   3.4986792478664875`*^9, 3.498679248946489*^9}, {3.5053446902638526`*^9, 
   3.5053446902738523`*^9}, {3.509895253463702*^9, 3.5098952543937035`*^9}, {
   3.510456152264075*^9, 3.5104561574440823`*^9}, {3.510509702006219*^9, 
   3.5105097118498363`*^9}, {3.5151877488705053`*^9, 3.515187750560508*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"B", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], ",", "x"}], "]"}]}],
      "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "A"}], "-", 
         RowBox[{"a", "*", "B"}]}], ")"}], "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, {3.497990132482653*^9, 3.4979901406570673`*^9}, 
   3.4986745773039436`*^9, {3.4986787675998096`*^9, 3.498678777519824*^9}, {
   3.4986788309798985`*^9, 3.498678845569919*^9}, {3.49867924992649*^9, 
   3.498679252046493*^9}, {3.5031153583578453`*^9, 3.503115386016694*^9}, {
   3.503119924089466*^9, 3.5031199310938787`*^9}, {3.5053446902838526`*^9, 
   3.505344690293853*^9}, {3.509895255133705*^9, 3.509895256113706*^9}, 
   3.5098975030420127`*^9, 3.5104337999942102`*^9, {3.5104561655940933`*^9, 
   3.5104561873341236`*^9}, {3.5105097169822454`*^9, 3.5105097323950725`*^9}, 
   3.510514470528195*^9, 3.511807262392017*^9, 3.511807696142624*^9, 
   3.5130466375580473`*^9, 3.51304749207069*^9, 3.514615103990465*^9, 
   3.514654521490132*^9, 3.5150014686992617`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["f",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "/", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661951449715*^9, 3.497661953243718*^9}, 3.4979216298462095`*^9, {
   3.504470970480277*^9, 3.504470974790283*^9}, {3.504988512420684*^9, 
   3.5049885147006874`*^9}, 3.505344689173851*^9, 3.509847506058957*^9, 
   3.5100197256274047`*^9, 3.5105084716008577`*^9, {3.5120540754101243`*^9, 
   3.512054075710125*^9}, {3.5130944045676327`*^9, 3.513094442101299*^9}, {
   3.5130950994180164`*^9, 3.5130951030580215`*^9}, 3.5141478502481556`*^9, {
   3.5142562504919596`*^9, 3.5142562591719723`*^9}, {3.5145980640465336`*^9, 
   3.5145980656365356`*^9}, 3.5146038698446617`*^9, {3.514637996427806*^9, 
   3.5146379971298075`*^9}, {3.5148394111473403`*^9, 
   3.5148394283573647`*^9}, {3.5151877641305265`*^9, 3.5151877666405306`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5076647229436293`*^9, 3.507664727563636*^9}, 
   3.514253181887664*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox["1", 
     RowBox[{
      SqrtBox[
       RowBox[{"f", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"b", "/", 
        RowBox[{"f", "[", "z", "]"}]}]]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}, {
   3.5072605288062344`*^9, 3.5072605314582396`*^9}, {3.5075717121274023`*^9, 
   3.507571727117423*^9}, {3.50758176808795*^9, 3.5075817732679577`*^9}, {
   3.507583363755458*^9, 3.5075833689814672`*^9}, {3.510507619932962*^9, 
   3.51050763590739*^9}, {3.514253208507701*^9, 3.5142532278877277`*^9}, {
   3.5145906419142942`*^9, 3.514590647794303*^9}, {3.5145910204648247`*^9, 
   3.514591065314887*^9}, {3.514591115034957*^9, 3.514591118734962*^9}, {
   3.5145982272067623`*^9, 3.514598232546769*^9}, {3.5146788712755475`*^9, 
   3.514678891705576*^9}}],

Cell["Rule f1:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.505936081778288*^9, 
   3.5059360824123244`*^9}, 3.50596679279029*^9, 3.506195715879625*^9, {
   3.5072434262848907`*^9, 3.507243426534491*^9}, {3.5073303681657257`*^9, 
   3.507330407975782*^9}, {3.5075715513171773`*^9, 3.5075715650271964`*^9}, {
   3.5075716142272654`*^9, 3.507571619647273*^9}, {3.507580938536789*^9, 
   3.50758093920679*^9}, {3.5075833309018*^9, 3.507583346985429*^9}, {
   3.5075993071840444`*^9, 3.507599307904045*^9}, {3.5136238475607247`*^9, 
   3.5136238475607247`*^9}, {3.5142259248823304`*^9, 
   3.5142259248823304`*^9}, {3.5142522403563457`*^9, 3.514252266126382*^9}, {
   3.514252365746521*^9, 3.51425237200653*^9}, 3.5142526257268853`*^9, 
   3.5142558168413525`*^9, {3.514591220365104*^9, 3.5145912332651224`*^9}, {
   3.5146039606247888`*^9, 3.514603969234801*^9}, {3.5146381054251976`*^9, 
   3.514638105659198*^9}, 3.514678836305498*^9, {3.5148392983971825`*^9, 
   3.5148393005371857`*^9}, {3.515196193148099*^9, 3.5151961950825024`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
    SqrtBox[
     RowBox[{"b", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], 
       SqrtBox[
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"B", "+", 
       RowBox[{"A", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.4987607563116155`*^9, 3.498760763041625*^9}, {
   3.499305498308893*^9, 3.499305517262926*^9}, {3.5059666670951004`*^9, 
   3.505966716827945*^9}, {3.5061955618794093`*^9, 3.506195570159421*^9}, {
   3.5072431872612705`*^9, 3.5072432404261637`*^9}, {3.5072432976002645`*^9, 
   3.507243301266271*^9}, {3.5073303069156404`*^9, 3.507330321715661*^9}, {
   3.507442381782913*^9, 3.507442392375332*^9}, 3.5075807801865673`*^9, {
   3.5075809222567663`*^9, 3.5075809253967705`*^9}, {3.507581708877867*^9, 
   3.5075817131678734`*^9}, 3.507583132911872*^9, {3.507583209907988*^9, 
   3.5075832236516123`*^9}, {3.5075992725639963`*^9, 
   3.5075992769640017`*^9}, {3.510507751378793*^9, 3.510507771081628*^9}, 
   3.510508890991995*^9, {3.510508922036049*^9, 3.5105089452800903`*^9}, 
   3.5105089757001433`*^9, {3.5142257979137073`*^9, 3.5142258077261243`*^9}, {
   3.5142526409569063`*^9, 3.5142526458869133`*^9}, {3.5142558354813786`*^9, 
   3.514255880171441*^9}, {3.5145904078139668`*^9, 3.514590422863988*^9}, {
   3.514590487924079*^9, 3.5145905069341054`*^9}, {3.514590825104551*^9, 
   3.5145908275345545`*^9}, {3.5145909363647065`*^9, 
   3.5145909822547708`*^9}, {3.514591243025136*^9, 3.5145912521451488`*^9}, {
   3.514603877404672*^9, 3.514603920424732*^9}, {3.514637939456506*^9, 
   3.5146379660545526`*^9}, {3.5146783354347973`*^9, 3.514678353874823*^9}, {
   3.514678405354895*^9, 3.5146784173749123`*^9}, {3.514678449754957*^9, 
   3.514678482385003*^9}, {3.514678569615125*^9, 3.51467858015514*^9}, {
   3.5146790411857853`*^9, 3.51467905892581*^9}, {3.515187769920535*^9, 
   3.515187788500561*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"b_.", "*", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], "]"}]}], ")"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"B", "+", 
          RowBox[{"A", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", "x"}], "]"}]}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.4982401285726357`*^9, 3.4982401313526397`*^9}, {
   3.4987611327521424`*^9, 3.4987611393821516`*^9}, {3.4987611708821955`*^9, 
   3.498761277792345*^9}, {3.498761669522894*^9, 3.4987616788229065`*^9}, {
   3.4987619391432714`*^9, 3.498761943263277*^9}, {3.499183308350725*^9, 
   3.4991833124847326`*^9}, {3.499185161474782*^9, 3.499185164828788*^9}, {
   3.499305530288949*^9, 3.4993055385257635`*^9}, {3.505966844688258*^9, 
   3.50596686517743*^9}, {3.5059669219046745`*^9, 3.5059669229497347`*^9}, {
   3.50596738600922*^9, 3.5059673883963566`*^9}, {3.5061955820294375`*^9, 
   3.506195592559452*^9}, {3.507243361763177*^9, 3.5072433812008114`*^9}, {
   3.5073303887157545`*^9, 3.507330393995762*^9}, {3.507330454915848*^9, 
   3.50733048518589*^9}, {3.507330529445952*^9, 3.5073305427059703`*^9}, {
   3.507330812806349*^9, 3.507330823296363*^9}, {3.5073309520265436`*^9, 
   3.5073309814665847`*^9}, {3.5073313288470707`*^9, 
   3.5073313330470767`*^9}, {3.5073320683081064`*^9, 
   3.5073320876581335`*^9}, {3.5073327496090603`*^9, 
   3.5073327527890644`*^9}, {3.5073328122591476`*^9, 
   3.5073328126791487`*^9}, {3.5073328632292194`*^9, 
   3.5073328824192457`*^9}, {3.5073338298225737`*^9, 3.507333833852579*^9}, {
   3.5073961002459946`*^9, 3.5073961026559973`*^9}, {3.5074422952495613`*^9, 
   3.507442320646406*^9}, {3.5074424047149534`*^9, 3.5074424054637547`*^9}, {
   3.507442805760458*^9, 3.5074428128896704`*^9}, 3.5074861142120705`*^9, {
   3.5074864950826035`*^9, 3.507486496282605*^9}, {3.5074944863850803`*^9, 
   3.507494489973087*^9}, {3.5074963472513857`*^9, 3.507496349076589*^9}, {
   3.5075808096266084`*^9, 3.507580833566642*^9}, 3.507580978416845*^9, {
   3.507581788827979*^9, 3.50758179663799*^9}, {3.5075820427603455`*^9, 
   3.507582043290346*^9}, {3.507583272495298*^9, 3.507583311432966*^9}, {
   3.507599282044009*^9, 3.5075992908940215`*^9}, 3.5075993572241144`*^9, {
   3.507661921989708*^9, 3.507661925799713*^9}, {3.5076646483035245`*^9, 
   3.5076646494435263`*^9}, {3.510507847693362*^9, 3.510507881217821*^9}, {
   3.5105087569097595`*^9, 3.510508781089802*^9}, 3.5114915571842628`*^9, 
   3.5118058688600655`*^9, {3.512054723081031*^9, 3.5120547404210553`*^9}, 
   3.513624193491332*^9, 3.514220936683169*^9, {3.514225945177966*^9, 
   3.5142259557547846`*^9}, 3.514255913511488*^9, 3.514589901303258*^9, {
   3.5145906710443354`*^9, 3.51459070299438*^9}, 3.514591184375054*^9, {
   3.514591264545166*^9, 3.514591305395223*^9}, 3.5145958016633663`*^9, {
   3.5146039224947357`*^9, 3.5146039356547537`*^9}, {3.514604083824961*^9, 
   3.514604139395039*^9}, {3.5146381175776186`*^9, 3.5146381442224655`*^9}, {
   3.5146775828777385`*^9, 3.514677588327746*^9}, {3.5146787405153646`*^9, 
   3.5146787519953804`*^9}, {3.5146787971154437`*^9, 3.514678832485493*^9}, {
   3.514679095175861*^9, 3.514679099345867*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5076647229436293`*^9, 3.507664727563636*^9}, 
   3.514253181887664*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{"a", " ", 
        RowBox[{"f", "[", "z", "]"}]}]}]], 
     RowBox[{
      SqrtBox[
       RowBox[{"f", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", "/", 
         RowBox[{"f", "[", "z", "]"}]}]}]]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}, {
   3.5072605288062344`*^9, 3.5072605314582396`*^9}, {3.5075717121274023`*^9, 
   3.507571727117423*^9}, {3.50758176808795*^9, 3.5075817732679577`*^9}, {
   3.507583363755458*^9, 3.5075833689814672`*^9}, {3.510507619932962*^9, 
   3.51050763590739*^9}, {3.514253208507701*^9, 3.5142532278877277`*^9}}],

Cell[TextData[{
 "Rule f2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"n", "-", 
     FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{
    RowBox[{"-", "2"}], "<", "n", "<", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.505936081778288*^9, 
   3.5059360824123244`*^9}, 3.50596679279029*^9, 3.506195715879625*^9, {
   3.5072434262848907`*^9, 3.507243426534491*^9}, {3.5073303681657257`*^9, 
   3.507330407975782*^9}, {3.5075715513171773`*^9, 3.5075715650271964`*^9}, {
   3.5075716142272654`*^9, 3.507571619647273*^9}, {3.507580938536789*^9, 
   3.50758093920679*^9}, {3.5075833309018*^9, 3.507583346985429*^9}, {
   3.5075993071840444`*^9, 3.507599307904045*^9}, {3.5136238475607247`*^9, 
   3.5136238475607247`*^9}, {3.5142259248823304`*^9, 
   3.5142259248823304`*^9}, {3.5142522403563457`*^9, 3.514252266126382*^9}, {
   3.514252365746521*^9, 3.51425237200653*^9}, 3.5142526257268853`*^9, {
   3.514839416587348*^9, 3.5148394170673485`*^9}, {3.514847714440708*^9, 
   3.514847714440708*^9}, 3.5151961981713076`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      SqrtBox[
       RowBox[{"b", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B", "+", 
         RowBox[{"A", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"a", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"n", "+", "1"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.4987607563116155`*^9, 3.498760763041625*^9}, {
   3.499305498308893*^9, 3.499305517262926*^9}, {3.5059666670951004`*^9, 
   3.505966716827945*^9}, {3.5061955618794093`*^9, 3.506195570159421*^9}, {
   3.5072431872612705`*^9, 3.5072432404261637`*^9}, {3.5072432976002645`*^9, 
   3.507243301266271*^9}, {3.5073303069156404`*^9, 3.507330321715661*^9}, {
   3.507442381782913*^9, 3.507442392375332*^9}, 3.5075807801865673`*^9, {
   3.5075809222567663`*^9, 3.5075809253967705`*^9}, {3.507581708877867*^9, 
   3.5075817131678734`*^9}, 3.507583132911872*^9, {3.507583209907988*^9, 
   3.5075832236516123`*^9}, {3.5075992725639963`*^9, 
   3.5075992769640017`*^9}, {3.510507751378793*^9, 3.510507771081628*^9}, 
   3.510508890991995*^9, {3.510508922036049*^9, 3.5105089452800903`*^9}, 
   3.5105089757001433`*^9, {3.5142257979137073`*^9, 3.5142258077261243`*^9}, {
   3.5142526409569063`*^9, 3.5142526458869133`*^9}, {3.515187779060548*^9, 
   3.515187793400568*^9}, 3.515351202036727*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
     "\n", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"B", "+", 
          RowBox[{"A", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"a", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}]}], ",", "x"}], "]"}]}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "2"}], "<", "n", "<", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.4982401285726357`*^9, 3.4982401313526397`*^9}, {
   3.4987611327521424`*^9, 3.4987611393821516`*^9}, {3.4987611708821955`*^9, 
   3.498761277792345*^9}, {3.498761669522894*^9, 3.4987616788229065`*^9}, {
   3.4987619391432714`*^9, 3.498761943263277*^9}, {3.499183308350725*^9, 
   3.4991833124847326`*^9}, {3.499185161474782*^9, 3.499185164828788*^9}, {
   3.499305530288949*^9, 3.4993055385257635`*^9}, {3.505966844688258*^9, 
   3.50596686517743*^9}, {3.5059669219046745`*^9, 3.5059669229497347`*^9}, {
   3.50596738600922*^9, 3.5059673883963566`*^9}, {3.5061955820294375`*^9, 
   3.506195592559452*^9}, {3.507243361763177*^9, 3.5072433812008114`*^9}, {
   3.5073303887157545`*^9, 3.507330393995762*^9}, {3.507330454915848*^9, 
   3.50733048518589*^9}, {3.507330529445952*^9, 3.5073305427059703`*^9}, {
   3.507330812806349*^9, 3.507330823296363*^9}, {3.5073309520265436`*^9, 
   3.5073309814665847`*^9}, {3.5073313288470707`*^9, 
   3.5073313330470767`*^9}, {3.5073320683081064`*^9, 
   3.5073320876581335`*^9}, {3.5073327496090603`*^9, 
   3.5073327527890644`*^9}, {3.5073328122591476`*^9, 
   3.5073328126791487`*^9}, {3.5073328632292194`*^9, 
   3.5073328824192457`*^9}, {3.5073338298225737`*^9, 3.507333833852579*^9}, {
   3.5073961002459946`*^9, 3.5073961026559973`*^9}, {3.5074422952495613`*^9, 
   3.507442320646406*^9}, {3.5074424047149534`*^9, 3.5074424054637547`*^9}, {
   3.507442805760458*^9, 3.5074428128896704`*^9}, 3.5074861142120705`*^9, {
   3.5074864950826035`*^9, 3.507486496282605*^9}, {3.5074944863850803`*^9, 
   3.507494489973087*^9}, {3.5074963472513857`*^9, 3.507496349076589*^9}, {
   3.5075808096266084`*^9, 3.507580833566642*^9}, 3.507580978416845*^9, {
   3.507581788827979*^9, 3.50758179663799*^9}, {3.5075820427603455`*^9, 
   3.507582043290346*^9}, {3.507583272495298*^9, 3.507583311432966*^9}, {
   3.507599282044009*^9, 3.5075992908940215`*^9}, 3.5075993572241144`*^9, {
   3.507661921989708*^9, 3.507661925799713*^9}, {3.5076646483035245`*^9, 
   3.5076646494435263`*^9}, {3.510507847693362*^9, 3.510507881217821*^9}, {
   3.5105087569097595`*^9, 3.510508781089802*^9}, {3.510509139453631*^9, 
   3.5105091408108335`*^9}, {3.5105091901069202`*^9, 3.510509235112999*^9}, {
   3.510511251600541*^9, 3.510511252645743*^9}, 3.5105113219722643`*^9, 
   3.510604140881258*^9, 3.511492106112727*^9, 3.5118128183458023`*^9, {
   3.5122663090612917`*^9, 3.5122663139597*^9}, {3.5122708458288584`*^9, 
   3.512270855928872*^9}, {3.5122720531105485`*^9, 3.512272058090555*^9}, 
   3.513046761528221*^9, 3.513047971531361*^9, 3.5136236027494946`*^9, 
   3.514222312789586*^9, 3.51422597027841*^9, {3.5142526739369526`*^9, 
   3.514252678056958*^9}, {3.5144332890993156`*^9, 3.5144333038881416`*^9}, {
   3.514613296196089*^9, 3.5146133018276987`*^9}, {3.514637216738036*^9, 
   3.514637221277644*^9}, 3.5146372597473116`*^9, 3.5148477385427504`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509853498085*^9}, {3.5121867835994377`*^9, 3.5121867889346466`*^9}, {
   3.5122544619337687`*^9, 3.512254474538591*^9}, {3.5122562056628323`*^9, 
   3.512256209001238*^9}, {3.512256962560561*^9, 3.5122569627321615`*^9}, {
   3.5122690531783423`*^9, 3.5122690550883455`*^9}, {3.513022714759317*^9, 
   3.513022715274118*^9}, {3.5130527428700514`*^9, 3.5130527451300545`*^9}, {
   3.5148394756774306`*^9, 3.514839478037434*^9}, {3.5151878050905848`*^9, 
   3.515187805520585*^9}, {3.516556475132826*^9, 3.5165564759752274`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, {3.4979866726025763`*^9, 
   3.497986673616578*^9}, {3.5006614307985444`*^9, 3.5006614323585463`*^9}}],

Cell[TextData[{
 "Basis:",
 " If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "A"}], "-", 
    RowBox[{"a", " ", "B"}]}], "=", "0"}]]],
 ", then",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", "z"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], ")"}], "n"]}], "=", 
   RowBox[{
    FractionBox["B", "b"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.497989934892706*^9, 
   3.49798993732631*^9}, {3.5006615536287165`*^9, 3.5006615979187784`*^9}, {
   3.5122568170903063`*^9, 3.5122568201635113`*^9}, {3.514414754950553*^9, 
   3.514414760888892*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{"b", " ", "A"}]}], "=", 
    RowBox[{
     RowBox[{"a", " ", "B"}], " ", "\[And]", " ", 
     RowBox[{"n", "<", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.497990130017849*^9, 3.497990130017849*^9}, {3.49843802295825*^9, 
   3.49843802295825*^9}, {3.498674382973672*^9, 3.498674382973672*^9}, {
   3.49867446038378*^9, 3.498674488383819*^9}, {3.498677308017767*^9, 
   3.4986773174477797`*^9}, 3.500661530668684*^9, 3.5006616774488897`*^9, {
   3.504983348793455*^9, 3.5049833534434614`*^9}, {3.5104559200937495`*^9, 
   3.5104559335737686`*^9}, {3.510505215498739*^9, 3.51050521598234*^9}, {
   3.512256822862316*^9, 3.512256827230324*^9}, {3.514413430650807*^9, 
   3.5144134393783064`*^9}, {3.5144141286487303`*^9, 3.5144141301528163`*^9}, 
   3.5144143308662963`*^9, {3.5144329887675877`*^9, 3.5144329965364017`*^9}, {
   3.514647997175522*^9, 3.514647998860325*^9}, {3.5146627259316177`*^9, 
   3.514662726501619*^9}, {3.5148395142574844`*^9, 3.5148395195574923`*^9}, {
   3.51655651176169*^9, 3.5165565122920914`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["B", "b"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497986264165859*^9, 3.4979862650706606`*^9}, {
   3.50065955661592*^9, 3.500659559295924*^9}, {3.5006614622785883`*^9, 
   3.5006614724286027`*^9}, {3.505344690603853*^9, 3.505344690603853*^9}, {
   3.509895238753682*^9, 3.509895241013685*^9}, {3.510455839463637*^9, 
   3.5104558434336424`*^9}, {3.5151878062405863`*^9, 3.515187807030587*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"B", "/", "b"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, {3.497986265944262*^9, 3.497986266927064*^9}, 
   3.4979863675440407`*^9, {3.4979898830226145`*^9, 3.497989898497842*^9}, 
   3.498679361436646*^9, {3.5006592743055253`*^9, 3.5006592786455317`*^9}, {
   3.5006615196186686`*^9, 3.5006615252886767`*^9}, {3.5006616594288645`*^9, 
   3.5006616867589025`*^9}, 3.5012666522100496`*^9, {3.505344690613853*^9, 
   3.505344690623853*^9}, {3.509895241823686*^9, 3.5098952424836874`*^9}, {
   3.510455878063691*^9, 3.5104558800736933`*^9}, {3.51045594181378*^9, 
   3.5104559554637995`*^9}, {3.5114602677280397`*^9, 
   3.5114602739180484`*^9}, {3.5130464938278465`*^9, 3.5130464972178507`*^9}, 
   3.514413417801072*^9, {3.5144141233954296`*^9, 3.5144141249175167`*^9}, {
   3.5144143237768908`*^9, 3.514414326850067*^9}, {3.5144326670270233`*^9, 
   3.514432668243825*^9}, {3.5144329684875526`*^9, 3.5144329742751627`*^9}, {
   3.5144823553098326`*^9, 3.5144823593970394`*^9}, {3.5146480030879326`*^9, 
   3.5146480045231347`*^9}, {3.5146627219416122`*^9, 3.514662722511613*^9}, 
   3.5168211652671747`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "17"}], "-", "18"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509853498085*^9}, {3.5121867835994377`*^9, 3.5121867889346466`*^9}, {
   3.5122544619337687`*^9, 3.512254474538591*^9}, {3.5122562056628323`*^9, 
   3.512256209001238*^9}, {3.512256962560561*^9, 3.5122569627321615`*^9}, {
   3.5122690531783423`*^9, 3.5122690550883455`*^9}, {3.513022714759317*^9, 
   3.513022715274118*^9}, {3.5130527428700514`*^9, 3.5130527451300545`*^9}, {
   3.5148394756774306`*^9, 3.514839478037434*^9}, {3.5151878050905848`*^9, 
   3.515187805520585*^9}, {3.5165565449517484`*^9, 3.516556546995352*^9}, {
   3.5165902568888474`*^9, 3.51659025863885*^9}, {3.5165907198194957`*^9, 
   3.516590721449498*^9}, {3.516591373510411*^9, 3.516591376660415*^9}, {
   3.5165914253804836`*^9, 3.5165914278804865`*^9}, {3.5165914670205417`*^9, 
   3.5165914837805653`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 6 with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.5017264195673985`*^9, 
   3.5017264509546537`*^9}, {3.5017265299999924`*^9, 
   3.5017265322151966`*^9}, {3.5017266933478794`*^9, 
   3.5017267053755007`*^9}, {3.5017269204530783`*^9, 3.501726921030279*^9}, 
   3.505345123274459*^9, {3.510265138242697*^9, 3.5102651438627043`*^9}, {
   3.510265545503267*^9, 3.5102655461032677`*^9}, {3.510267045035366*^9, 
   3.5102670837254205`*^9}, {3.5102672363556337`*^9, 
   3.5102672378556356`*^9}, {3.510422526090422*^9, 3.510422526090422*^9}, 
   3.5120641949823065`*^9, {3.5141592435144367`*^9, 3.514159287314498*^9}}],

Cell[TextData[{
 "Rule 17: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.504364584041261*^9, 3.504364585481263*^9}, {
   3.5043646357213335`*^9, 3.5043646359213343`*^9}, {3.5043679570379877`*^9, 
   3.504367958197989*^9}, 3.5049832861833677`*^9, 3.5049833569634666`*^9, {
   3.5051849569721966`*^9, 3.5051849812355843`*^9}, {3.510267996386698*^9, 
   3.5102679966666985`*^9}, {3.510501504176943*^9, 3.5105015062769456`*^9}, {
   3.5105052365899754`*^9, 3.5105052370579767`*^9}, {3.51226904412833*^9, 
   3.512269044828331*^9}, {3.513052700629992*^9, 3.5130527022199945`*^9}, {
   3.514432888865013*^9, 3.514432890331415*^9}, {3.514612687061819*^9, 
   3.5146126877638206`*^9}, {3.514839557537545*^9, 3.5148395577875457`*^9}, 
   3.5165565533445635`*^9, {3.516590265258859*^9, 3.5165902654688597`*^9}, {
   3.5165915663606806`*^9, 3.5165915668506813`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"a", " ", "B"}]}], ")"}], " ", 
        RowBox[{"Cot", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Csc", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], ")"}]}]], " ", "\[CenterDot]", 
   "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "-", 
       RowBox[{"a", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"a", " ", "B"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"a", " ", "B"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.499404301116287*^9, 
   3.49940430323629*^9}, {3.4994048006769867`*^9, 3.4994048025069895`*^9}, {
   3.5003179811489162`*^9, 3.5003179814297166`*^9}, 3.5003181853432746`*^9, {
   3.5003185563630857`*^9, 3.500318557803087*^9}, {3.5013586287231283`*^9, 
   3.5013586400931444`*^9}, 3.5027672052757444`*^9, 3.5035556969716425`*^9, 
   3.5053446414737844`*^9, {3.505344693303857*^9, 3.505344708433878*^9}, 
   3.5053535619252167`*^9, {3.5094747245329013`*^9, 3.509474861672745*^9}, {
   3.5095533946779337`*^9, 3.509553415627963*^9}, {3.509553538668135*^9, 
   3.5095535518681536`*^9}, {3.5095535889582057`*^9, 
   3.5095536266082582`*^9}, {3.5101725552067585`*^9, 
   3.5101725573127623`*^9}, {3.5101728674101067`*^9, 
   3.5101728711385136`*^9}, {3.510173662715104*^9, 3.510173677129529*^9}, 
   3.5102536435885286`*^9, {3.5102670877154255`*^9, 3.510267146355508*^9}, 
   3.510267191105571*^9, {3.51026722622562*^9, 3.5102673128457413`*^9}, {
   3.5102675653560944`*^9, 3.5102675698361006`*^9}, {3.515187834140625*^9, 
   3.5151878418506355`*^9}, {3.5151879136307364`*^9, 3.515187919510744*^9}, {
   3.515351261800432*^9, 3.5153512751820555`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "A"}], "-", 
       RowBox[{"a", "*", "B"}]}], ")"}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"A", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "^", "2"}], "-", 
               RowBox[{"b", "^", "2"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"b", "*", "A"}], "-", 
                 RowBox[{"a", "*", "B"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}], "+", "\n", "        ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"b", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"b", "*", "A"}], "-", 
                 RowBox[{"a", "*", "B"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "2"}], ")"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "2"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, 
   3.4979862281609955`*^9, {3.4979862780186834`*^9, 3.4979862991255207`*^9}, 
   3.4979863964508915`*^9, {3.497990453203616*^9, 3.497990473936053*^9}, 
   3.4986794274067383`*^9, {3.498763920866046*^9, 3.4987639593560996`*^9}, {
   3.4991312222624083`*^9, 3.49913122341241*^9}, {3.5010427775038137`*^9, 
   3.501042778515871*^9}, {3.5030725326890316`*^9, 3.5030725406290426`*^9}, 
   3.5038761341846743`*^9, 3.5043679506879787`*^9, {3.5051850204098253`*^9, 
   3.505185024399053*^9}, 3.5053446405137825`*^9, {3.5053446906538534`*^9, 
   3.505344714143886*^9}, 3.5053519910530176`*^9, 3.508782980727106*^9, {
   3.5098952623037148`*^9, 3.509895264533718*^9}, {3.510267358245805*^9, 
   3.510267363695812*^9}, 3.5102674525359364`*^9, {3.51026851924743*^9, 
   3.510268522147434*^9}, 3.510433807394221*^9, {3.510501494356929*^9, 
   3.510501495866931*^9}, 3.5105518395253057`*^9, 3.511812957266004*^9, {
   3.512269213268567*^9, 3.5122692375086007`*^9}, {3.512584181242534*^9, 
   3.512584185492777*^9}, {3.5125842663083997`*^9, 3.5125842882586555`*^9}, 
   3.5130467202081633`*^9, 3.513048046941467*^9, {3.5144328756361895`*^9, 
   3.514432880082197*^9}, {3.5146126632873774`*^9, 3.5146126639113784`*^9}, {
   3.515350115898819*^9, 3.515350118082823*^9}, 3.5165689605090117`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 3a with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.5017264195673985`*^9, 
   3.5017264509546537`*^9}, {3.5017265299999924`*^9, 3.5017265322151966`*^9}, 
   3.505345123284459*^9, 3.512064236782365*^9, {3.5141593635446043`*^9, 
   3.5141594128246737`*^9}, {3.5141595842549133`*^9, 3.51415959593493*^9}}],

Cell[TextData[{
 "Rule 18: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.504364584041261*^9, 3.504364585481263*^9}, {
   3.5043646357213335`*^9, 3.5043646359213343`*^9}, {3.5043679570379877`*^9, 
   3.504367958197989*^9}, 3.5049832861833677`*^9, 3.5049833569634666`*^9, {
   3.5051849569721966`*^9, 3.5051849812355843`*^9}, {3.5102679880166864`*^9, 
   3.5102679904066896`*^9}, {3.5102687753677883`*^9, 3.510268782577799*^9}, {
   3.510505240115582*^9, 3.5105052405679827`*^9}, {3.5122688667080812`*^9, 
   3.512268870648087*^9}, {3.5122690795083795`*^9, 3.512269081048382*^9}, {
   3.5130527114500074`*^9, 3.5130527117500076`*^9}, {3.5146063996882033`*^9, 
   3.514606400028204*^9}, {3.5146493440350876`*^9, 3.514649345033489*^9}, {
   3.5146502645771046`*^9, 3.5146502645771046`*^9}, {3.514839603187609*^9, 
   3.51483960371761*^9}, {3.5148434467544093`*^9, 3.5148434467544093`*^9}, 
   3.5165565559185677`*^9, {3.516590268108863*^9, 3.5165902683488636`*^9}, {
   3.5165915688406844`*^9, 3.5165915696906853`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "B", " ", 
         RowBox[{"Cot", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Csc", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"d", " ", "n"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "n"], "\[CenterDot]", "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], " ", "A", " ", "n"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["b", "2"], " ", "B", " ", 
           RowBox[{"(", 
            RowBox[{"n", "-", "1"}], ")"}]}], "+", 
          RowBox[{"2", " ", "a", " ", "A", " ", "b", " ", "n"}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B", " ", "n"}]}], ")"}], 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A", " ", "n"}], "+", 
          RowBox[{"a", " ", "B", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "n"}], "-", "1"}], ")"}]}]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095562652147536`*^9, 3.5095563252848377`*^9}, {3.50955638387492*^9, 
   3.5095564136949615`*^9}, {3.5095564499650126`*^9, 
   3.5095565745651865`*^9}, {3.509556659575306*^9, 3.5095566816053367`*^9}, {
   3.5095567320554075`*^9, 3.5095567407354193`*^9}, {3.509556895905637*^9, 
   3.5095569251456776`*^9}, {3.510172496160655*^9, 3.510172513227085*^9}, {
   3.5101727774135485`*^9, 3.5101727805647545`*^9}, {3.5101732386595592`*^9, 
   3.51017323937716*^9}, {3.510173272480418*^9, 3.510173288844847*^9}, 
   3.5102680174567275`*^9, {3.510268078456813*^9, 3.5102681014568453`*^9}, {
   3.510268150966914*^9, 3.510268299197122*^9}, {3.510268367137217*^9, 
   3.510268412957281*^9}, {3.5102684572773433`*^9, 3.5102684593973465`*^9}, {
   3.5151878507206483`*^9, 3.5151878693906746`*^9}, {3.5153512984104967`*^9, 
   3.5153513358661623`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "B", "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", "n"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "n"}], ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", "A", "*", "n"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"b", "^", "2"}], "*", "B", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "-", "1"}], ")"}]}], "+", 
               RowBox[{"2", "*", "a", "*", "A", "*", "b", "*", "n"}], "+", 
               RowBox[{
                RowBox[{"a", "^", "2"}], "*", "B", "*", "n"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}], "+", "\n", "        ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"b", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"b", "*", "A", "*", "n"}], "+", 
                 RowBox[{"a", "*", "B", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", "*", "n"}], "-", "1"}], ")"}]}]}], ")"}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "2"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, 
   3.4979862281609955`*^9, {3.4979862780186834`*^9, 3.4979862991255207`*^9}, 
   3.4979863964508915`*^9, {3.497990453203616*^9, 3.497990473936053*^9}, 
   3.4986794274067383`*^9, {3.498763920866046*^9, 3.4987639593560996`*^9}, {
   3.4991312222624083`*^9, 3.49913122341241*^9}, {3.5010427775038137`*^9, 
   3.501042778515871*^9}, {3.5030725326890316`*^9, 3.5030725406290426`*^9}, 
   3.5038761341846743`*^9, 3.5043679506879787`*^9, {3.5051850204098253`*^9, 
   3.505185024399053*^9}, 3.5053446405137825`*^9, {3.5053446906538534`*^9, 
   3.505344714143886*^9}, 3.5053519910530176`*^9, 3.508782980727106*^9, {
   3.5098952623037148`*^9, 3.509895264533718*^9}, {3.510267358245805*^9, 
   3.510267363695812*^9}, 3.5102674525359364`*^9, {3.51026851924743*^9, 
   3.510268522147434*^9}, 3.510268653627618*^9, {3.5102687229377155`*^9, 
   3.510268727847722*^9}, 3.5104338089442234`*^9, 3.510551850155321*^9, 
   3.511813064886154*^9, {3.5122683607373734`*^9, 3.5122683623773756`*^9}, {
   3.512269300568689*^9, 3.51226932295872*^9}, 3.5130467332981815`*^9, 
   3.5130480218014317`*^9, 3.514403683091278*^9, {3.514415080567177*^9, 
   3.514415082629295*^9}, 3.5146137127328215`*^9, {3.514650259179495*^9, 
   3.514650260131097*^9}, 3.514843454538823*^9, {3.5153501405936623`*^9, 
   3.515350142637266*^9}, 3.516568964369017*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "15"}], "-", "16"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509853498085*^9}, {3.5121867835994377`*^9, 3.5121867889346466`*^9}, {
   3.5122544619337687`*^9, 3.512254474538591*^9}, {3.5122562056628323`*^9, 
   3.512256209001238*^9}, {3.512256962560561*^9, 3.5122569627321615`*^9}, {
   3.5122690531783423`*^9, 3.5122690550883455`*^9}, {3.513022714759317*^9, 
   3.513022715274118*^9}, {3.5130527428700514`*^9, 3.5130527451300545`*^9}, {
   3.5148394756774306`*^9, 3.514839478037434*^9}, {3.5151878050905848`*^9, 
   3.515187805520585*^9}, {3.516556243112819*^9, 3.5165562462640247`*^9}, {
   3.516556294280909*^9, 3.5165562944837093`*^9}, {3.5165902796288795`*^9, 
   3.516590281408882*^9}, {3.5165907230095*^9, 3.5165907240995016`*^9}, {
   3.516591367100402*^9, 3.516591370410406*^9}, {3.516591434290496*^9, 
   3.5165914657305403`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Rule 10a inverted", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, 3.5053451232244587`*^9, 
   3.5120643314424973`*^9, {3.5141470715870657`*^9, 3.5141471052171125`*^9}, {
   3.5144869477857265`*^9, 3.5144869622357464`*^9}, {3.514487331846264*^9, 
   3.5144873614563055`*^9}, {3.5145874907671595`*^9, 3.514587527910825*^9}, {
   3.5145983012468653`*^9, 3.514598302946868*^9}, {3.514613128168194*^9, 
   3.514613132941802*^9}, {3.514645771410413*^9, 3.5146457852944374`*^9}, 
   3.514646343401017*^9, {3.5146528122377386`*^9, 3.5146528160677443`*^9}, {
   3.514839523897498*^9, 3.5148395249574995`*^9}}],

Cell[TextData[{
 "Rule 15: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.504364584041261*^9, 3.504364585481263*^9}, {
   3.5043646357213335`*^9, 3.5043646359213343`*^9}, {3.5043679570379877`*^9, 
   3.504367958197989*^9}, 3.5049832861833677`*^9, 3.5049833569634666`*^9, {
   3.5051849569721966`*^9, 3.5051849812355843`*^9}, {3.5102679880166864`*^9, 
   3.5102679904066896`*^9}, {3.5102687753677883`*^9, 3.510268782577799*^9}, {
   3.5102868863104877`*^9, 3.5102868869032884`*^9}, {3.5102869285553617`*^9, 
   3.5102869294913635`*^9}, {3.510508500086508*^9, 3.5105085005233088`*^9}, {
   3.5141472920273743`*^9, 3.5141472938373766`*^9}, {3.514147377677494*^9, 
   3.5141473784874954`*^9}, {3.5141527536711903`*^9, 
   3.5141527536711903`*^9}, {3.5144864172649837`*^9, 3.5144864182949853`*^9}, 
   3.5144877987669177`*^9, {3.5145870601068025`*^9, 3.514587068593217*^9}, {
   3.5146126372977314`*^9, 3.5146126381869335`*^9}, {3.514839529427506*^9, 
   3.51483953236751*^9}, {3.516556280708885*^9, 3.516556281098886*^9}, {
   3.516590283568885*^9, 3.5165902838388853`*^9}, {3.516591576740695*^9, 
   3.516591577040696*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
    RowBox[{
     RowBox[{"\[DifferentialD]", "x"}], " ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"2", " ", "A", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], 
        RowBox[{"n", "+", "1"}]]}], 
      RowBox[{"b", " ", "d", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "n"}], "+", "k", "+", "1"}], ")"}]}]]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n"}], "+", "k", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"B", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n"}], "+", "k", "+", "1"}], ")"}]}], "+", 
       RowBox[{"A", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "k", "+", "3"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.509555746174027*^9, 3.509555943204303*^9}, {3.510172505473871*^9, 
   3.5101725090150776`*^9}, {3.5101727905331717`*^9, 3.510172794152378*^9}, {
   3.510173309249683*^9, 3.510173334771328*^9}, {3.513051092777741*^9, 
   3.5130511452278147`*^9}, {3.5146056661571765`*^9, 
   3.5146058525074377`*^9}, {3.5146059389075584`*^9, 
   3.5146059755076094`*^9}, {3.5146060141676636`*^9, 
   3.5146060429077044`*^9}, {3.5146066062684927`*^9, 3.514606620238512*^9}, {
   3.5146118221546993`*^9, 3.514611835555123*^9}, {3.5146118809512024`*^9, 
   3.5146119726169634`*^9}, {3.514612059743117*^9, 3.5146121620324965`*^9}, {
   3.5146121985677605`*^9, 3.51461221529099*^9}, {3.5146122629334736`*^9, 
   3.5146122641814756`*^9}, {3.51461235782844*^9, 3.5146123733348675`*^9}, {
   3.51461243766938*^9, 3.514612529719943*^9}, 3.5146125794060297`*^9, {
   3.51518780953059*^9, 3.515187811500593*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "A", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}]}], ")"}]}], 
      ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"B", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}]}], "+", 
            RowBox[{"A", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "n"}], "+", "k", "+", "3"}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976406000756187`*^9, 
   3.4976407755003276`*^9, {3.497641256215172*^9, 3.4976412598187785`*^9}, 
   3.4976414964243937`*^9, 3.4976416664178925`*^9, 3.497641799704527*^9, {
   3.497641972467231*^9, 3.497641974682435*^9}, 3.497642107953469*^9, {
   3.4976421580451565`*^9, 3.49764215997956*^9}, {3.4979216146361823`*^9, 
   3.4979216448378353`*^9}, 3.4979241751310797`*^9, {3.4979242573432245`*^9, 
   3.497924266984041*^9}, {3.498241439764471*^9, 3.4982414602545*^9}, {
   3.5031146206925497`*^9, 3.503114629912166*^9}, {3.5031577379184756`*^9, 
   3.5031577418808823`*^9}, {3.503158883390085*^9, 3.503158888428894*^9}, 
   3.5053446400137825`*^9, {3.5053446892738514`*^9, 3.505344713643885*^9}, 
   3.505345556345065*^9, 3.508439139200802*^9, {3.5098475120089655`*^9, 
   3.5098475136889677`*^9}, 3.5114592311065884`*^9, 3.5118056919098177`*^9, 
   3.5141779771176*^9, {3.514487423866393*^9, 3.5144874773564677`*^9}, {
   3.5144875091265125`*^9, 3.5144875099565134`*^9}, 3.5144876512067113`*^9, {
   3.514487694756772*^9, 3.514487698386777*^9}, {3.514488103627344*^9, 
   3.5144881038173447`*^9}, {3.5145864869461956`*^9, 3.514586511703439*^9}, {
   3.5145870925236597`*^9, 3.514587094458063*^9}, {3.5145871435357485`*^9, 
   3.514587157279373*^9}, {3.5146126464237475`*^9, 3.5146126479057503`*^9}, {
   3.5146127110546613`*^9, 3.5146127220838804`*^9}, {3.514612826104863*^9, 
   3.514612919923428*^9}, 3.514613777036134*^9, 3.516821165357175*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 3a or 3b with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"a", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.5017264195673985`*^9, 
   3.5017264509546537`*^9}, {3.5017265299999924`*^9, 3.5017265322151966`*^9}, 
   3.505345123284459*^9, 3.512064236782365*^9, {3.5141593635446043`*^9, 
   3.5141594128246737`*^9}, {3.514605571897044*^9, 3.514605574277048*^9}, {
   3.514607455309681*^9, 3.5146074574796844`*^9}}],

Cell[TextData[{
 "Rule 16: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.5004322533111067`*^9, 
   3.5004322794606023`*^9}, {3.5030203943207865`*^9, 
   3.5030203943207865`*^9}, {3.5043646078512945`*^9, 3.504364638711338*^9}, 
   3.504471249250667*^9, {3.504983297263383*^9, 3.504983298043384*^9}, {
   3.505185059347052*^9, 3.5051850634142847`*^9}, {3.510010655210175*^9, 
   3.510010661460184*^9}, {3.5105052330331697`*^9, 3.510505233813171*^9}, {
   3.512186750070178*^9, 3.51218675138058*^9}, {3.512254288430264*^9, 
   3.512254290224267*^9}, 3.5122690611683536`*^9, {3.5130527066400003`*^9, 
   3.5130527081400023`*^9}, {3.5146068262688007`*^9, 
   3.5146068262688007`*^9}, {3.5146069044289103`*^9, 3.51460695440898*^9}, {
   3.514839592227594*^9, 3.514839594457597*^9}, {3.5165562843904915`*^9, 
   3.5165562849208927`*^9}, {3.5165902858588877`*^9, 3.5165902861388884`*^9},
    {3.5165915791306987`*^9, 3.5165915797206993`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", "B", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "n"}], "+", "k", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"2", "n"}], "+", "k", "+", "1"}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "B", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "k", "-", "1"}], ")"}]}], "+", 
       RowBox[{"b", " ", "A", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "k", "+", "1"}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.509555746174027*^9, 3.509555943204303*^9}, {3.510172505473871*^9, 
   3.5101725090150776`*^9}, {3.5101727905331717`*^9, 3.510172794152378*^9}, {
   3.510173309249683*^9, 3.510173334771328*^9}, {3.513051092777741*^9, 
   3.5130511452278147`*^9}, {3.5146056661571765`*^9, 
   3.5146058525074377`*^9}, {3.5146059389075584`*^9, 
   3.5146059755076094`*^9}, {3.5146060141676636`*^9, 
   3.5146060429077044`*^9}, {3.5146066062684927`*^9, 3.514606620238512*^9}, {
   3.515188017743307*^9, 3.5151880197633095`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", "B", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", "n"}],
       "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}]}], ",", "\n", 
      "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"b", "*", "B", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "n"}], "+", "k", "-", "1"}], ")"}]}], "+", 
            RowBox[{"b", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4979862253061905`*^9, {
   3.497986271107871*^9, 3.497986297799518*^9}, 3.497986386903675*^9, 
   3.4986794582767816`*^9, {3.500419863725463*^9, 3.5004198652605505`*^9}, 
   3.5004202566819386`*^9, {3.500432258158384*^9, 3.5004322592084436`*^9}, 
   3.503020185000493*^9, 3.503020369830752*^9, {3.5030725476090527`*^9, 
   3.5030725694590836`*^9}, 3.503876142483889*^9, {3.505185046002289*^9, 
   3.5051850551548123`*^9}, 3.505344640573783*^9, {3.5053446907338533`*^9, 
   3.505344714193886*^9}, 3.505352025233065*^9, 3.5087829424446387`*^9, {
   3.509895272053728*^9, 3.509895275953734*^9}, 3.510433804704217*^9, 
   3.510513659779171*^9, 3.511807932152954*^9, {3.5121872577122717`*^9, 
   3.512187260473477*^9}, {3.5122693811788015`*^9, 3.5122693823488035`*^9}, 
   3.5130467260581713`*^9, 3.5130480309114447`*^9, {3.5144150721536956`*^9, 
   3.514415073159753*^9}, 3.5144740613848653`*^9, {3.5146064392882586`*^9, 
   3.5146064403682604`*^9}, {3.5146065012883453`*^9, 3.5146065378183966`*^9}, 
   3.51460656896844*^9, {3.514606696748619*^9, 3.514606787928747*^9}, {
   3.51461276128675*^9, 3.514612763049553*^9}, 3.5168211653871746`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{
          SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", "1"}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5026719192141376`*^9, 
   3.5026719206441393`*^9}, {3.5027639618236465`*^9, 3.5027639715424633`*^9}, 
   3.5040443744413013`*^9, 3.5047258778634586`*^9, 3.5047259304635324`*^9, {
   3.5047296968488054`*^9, 3.5047297039888153`*^9}, {3.5047304827399054`*^9, 
   3.5047304905499163`*^9}, {3.5053445891537113`*^9, 3.505344590523713*^9}, {
   3.5100199895018682`*^9, 3.5100200070206995`*^9}, {3.510020038236354*^9, 
   3.510020038236354*^9}, {3.510170385415208*^9, 3.510170385415208*^9}, {
   3.5101743640143356`*^9, 3.5101743640143356`*^9}, {3.5134440458483133`*^9, 
   3.5134440464283147`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["g",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044136451914988`*^9, 3.50441429638241*^9, {3.5044703271693764`*^9, 
   3.504470336329389*^9}, {3.507605026068486*^9, 3.507605039298505*^9}, 
   3.5076058897996955`*^9, 3.507612730976883*^9, {3.5076833980984545`*^9, 
   3.5076834144316835`*^9}, {3.5076841143581123`*^9, 3.507684129458939*^9}, 
   3.5077429780811357`*^9, {3.5077509482580748`*^9, 3.507750951268079*^9}, {
   3.507752914548833*^9, 3.5077529156288347`*^9}, {3.5083803730605345`*^9, 
   3.5083803752405376`*^9}, {3.5084343251540623`*^9, 3.508434327354065*^9}, {
   3.5084350718951073`*^9, 3.508435076975115*^9}, {3.5086310587757254`*^9, 
   3.508631059696127*^9}, 3.508684761506933*^9, 3.5086849462816324`*^9, 
   3.5087278176184263`*^9, 3.5087278632485065`*^9, 3.508727955943869*^9, {
   3.5087281208361588`*^9, 3.5087281279809713`*^9}, {3.5087811392187877`*^9, 
   3.5087811399587884`*^9}, {3.5087812182888985`*^9, 
   3.5087812191188993`*^9}, {3.50989505179342*^9, 3.5098950847434664`*^9}, {
   3.510585688098961*^9, 3.510585693578969*^9}, {3.511370195524361*^9, 
   3.511370201052677*^9}, {3.512153982992205*^9, 3.5121539832322054`*^9}, 
   3.5148396512876763`*^9, {3.515188086343403*^9, 3.515188087043404*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, {3.4979864214265356`*^9, 
   3.497986422409337*^9}, {3.4979866389377174`*^9, 3.49798665193254*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", "z"}]}], 
    RowBox[{"z", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], ")"}]}]], "=", 
   RowBox[{
    FractionBox["A", 
     RowBox[{"a", " ", "z"}]], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}]}], 
     RowBox[{"a", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.5004274880015464`*^9, 3.500427526248734*^9}, {
   3.500577748166791*^9, 3.5005777941712723`*^9}, {3.5005778953918495`*^9, 
   3.5005778978566537`*^9}, {3.5006681103278956`*^9, 3.500668167617976*^9}, {
   3.5006682214480515`*^9, 3.500668278938132*^9}, {3.500668429098342*^9, 
   3.5006684314183455`*^9}, {3.5007438770458975`*^9, 3.500743899705929*^9}, {
   3.5007439773260374`*^9, 3.5007440143660893`*^9}, {3.500744077676178*^9, 
   3.5007440802161818`*^9}, {3.508781140228789*^9, 3.5087811407387896`*^9}, {
   3.5087812197089005`*^9, 3.5087812205389013`*^9}, {3.510585830679161*^9, 
   3.510585864979209*^9}}],

Cell[TextData[{
 "Rule g: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "B"}], "-", 
    RowBox[{"b", " ", "A"}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497663553088928*^9, 3.4976635622149444`*^9}, {
   3.4979894880299215`*^9, 3.4979894894339237`*^9}, {3.5006681122778983`*^9, 
   3.500668141397939*^9}, 3.5006681866680026`*^9, 3.500668490938429*^9, {
   3.5007439793360405`*^9, 3.500744015306091*^9}, {3.504807080336423*^9, 
   3.504807081266424*^9}, 3.5050081195556927`*^9, 3.505010078567789*^9, 
   3.508728130133775*^9, 3.510585741759036*^9, 3.5113701834696712`*^9, 
   3.51483965375768*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["A", "a"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979862492990327`*^9, 
   3.4979862502662344`*^9}, {3.497987000218752*^9, 3.4979870022311554`*^9}, {
   3.500427423095834*^9, 3.5004274236088634`*^9}, {3.5004275574055157`*^9, 
   3.5004276042171936`*^9}, {3.5004328122050734`*^9, 3.500432862882972*^9}, 
   3.500577560076061*^9, {3.5005776542858267`*^9, 3.5005776585134335`*^9}, {
   3.5005778782474194`*^9, 3.5005778816794252`*^9}, {3.5006678781275706`*^9, 
   3.500667895627595*^9}, {3.5006681130078993`*^9, 3.500668142907941*^9}, {
   3.5006681874880037`*^9, 3.5006681887380056`*^9}, {3.5006684144183216`*^9, 
   3.500668421898332*^9}, {3.500743805725797*^9, 3.5007438221458206`*^9}, {
   3.5007439801660414`*^9, 3.5007440164760923`*^9}, {3.5007440718961697`*^9, 
   3.5007440743961735`*^9}, {3.5087280178135777`*^9, 
   3.5087280439592237`*^9}, {3.50878114099879*^9, 3.508781142348792*^9}, {
   3.5087812207389016`*^9, 3.508781221528903*^9}, {3.509895115193509*^9, 
   3.5098951196935153`*^9}, {3.515188087593405*^9, 3.515188089123407*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"A", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "A"}], "-", 
         RowBox[{"a", "*", "B"}]}], ")"}], "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.497986253963441*^9, 
   3.4979862552738433`*^9}, 3.4979863375295877`*^9, {3.497986505495083*^9, 
   3.497986507819487*^9}, {3.49798706165166*^9, 3.497987068765272*^9}, {
   3.497987706708393*^9, 3.497987708642796*^9}, {3.4979879276983805`*^9, 
   3.497987930365986*^9}, 3.4979880679114275`*^9, 3.498497171646879*^9, {
   3.5004276750552454`*^9, 3.5004276923832364`*^9}, {3.500427741061021*^9, 
   3.5004277415710497`*^9}, 3.5004329174270916`*^9, {3.500432950987011*^9, 
   3.500433005771145*^9}, {3.5005779794447966`*^9, 3.5005780180236645`*^9}, 
   3.500578063248144*^9, 3.500578099767808*^9, {3.5006681154379025`*^9, 
   3.5006681452379446`*^9}, {3.5006681900380073`*^9, 3.500668193138012*^9}, {
   3.5006682384080753`*^9, 3.5006682387180758`*^9}, {3.5006684478883686`*^9, 
   3.5006684560683794`*^9}, {3.500672493914033*^9, 3.5006724959640355`*^9}, {
   3.500678094671874*^9, 3.5006781072418914`*^9}, 3.5006781402019377`*^9, 
   3.5006784811624146`*^9, {3.500743844265851*^9, 3.5007438570258694`*^9}, {
   3.500743982496045*^9, 3.5007440553061466`*^9}, 3.500744134916258*^9, 
   3.50074660052971*^9, {3.5087280039763536`*^9, 3.5087280126031685`*^9}, {
   3.508781142598792*^9, 3.508781143258793*^9}, {3.5087812217089033`*^9, 
   3.5087812227689047`*^9}, {3.5098951225335193`*^9, 
   3.5098951251835227`*^9}, {3.5148410029785156`*^9, 3.5148410036337166`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["h",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"m", "/", "2"}]], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044136451914988`*^9, 3.50441429638241*^9, {3.5044703271693764`*^9, 
   3.504470336329389*^9}, {3.507605026068486*^9, 3.507605039298505*^9}, 
   3.5076058897996955`*^9, 3.507612730976883*^9, {3.5076833980984545`*^9, 
   3.5076834144316835`*^9}, {3.5076841143581123`*^9, 3.507684129458939*^9}, 
   3.5077429780811357`*^9, {3.5077509482580748`*^9, 3.507750951268079*^9}, {
   3.507752914548833*^9, 3.5077529156288347`*^9}, {3.5083803730605345`*^9, 
   3.5083803752405376`*^9}, {3.5084343251540623`*^9, 3.508434327354065*^9}, {
   3.5084350718951073`*^9, 3.508435076975115*^9}, {3.5086310587757254`*^9, 
   3.508631059696127*^9}, 3.508684761506933*^9, 3.5086849462816324`*^9, 
   3.5087278176184263`*^9, 3.5087278632485065`*^9, 3.508727955943869*^9, {
   3.5087281208361588`*^9, 3.5087281279809713`*^9}, {3.508728448866336*^9, 
   3.5087284524231424`*^9}, {3.5087811884588566`*^9, 3.508781189028857*^9}, {
   3.5098952046636343`*^9, 3.509895205193635*^9}, {3.5121539918022175`*^9, 
   3.5121539920022173`*^9}, 3.512779598946293*^9, 3.5127800912769823`*^9, 
   3.512780178117104*^9, {3.5127804033674192`*^9, 3.5127804307674575`*^9}, {
   3.513046210047449*^9, 3.5130462133074536`*^9}, 3.514839663407694*^9, {
   3.515188092663412*^9, 3.5151880932934127`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, {3.4979866726025763`*^9, 
   3.497986673616578*^9}, {3.5006614307985444`*^9, 3.5006614323585463`*^9}, {
   3.5038516766032543`*^9, 3.5038516777264566`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", "z"}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}]], "=", 
   RowBox[{
    FractionBox["B", "b"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}]}], 
     RowBox[{"b", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.5004274880015464`*^9, 3.500427526248734*^9}, {
   3.500577748166791*^9, 3.5005777941712723`*^9}, {3.5005778953918495`*^9, 
   3.5005778978566537`*^9}, {3.5006681103278956`*^9, 3.500668167617976*^9}, {
   3.5006682214480515`*^9, 3.500668278938132*^9}, {3.500668429098342*^9, 
   3.5006684314183455`*^9}, {3.5007438770458975`*^9, 3.500743899705929*^9}, {
   3.5007439773260374`*^9, 3.5007440143660893`*^9}, {3.500744077676178*^9, 
   3.5007440802161818`*^9}, {3.508781140228789*^9, 3.5087811407387896`*^9}, {
   3.5087812197089005`*^9, 3.5087812205389013`*^9}, {3.510585830679161*^9, 
   3.510585864979209*^9}, {3.5127800968769903`*^9, 3.5127801321370397`*^9}}],

Cell[TextData[{
 "Rule h: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    SuperscriptBox["m", "2"]}], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.502677309791684*^9, 3.502677315931693*^9}, {
   3.502767275678668*^9, 3.502767275678668*^9}, {3.5027682258967376`*^9, 
   3.502768240248763*^9}, 3.502768355688966*^9, {3.5033578653664684`*^9, 
   3.50335786655207*^9}, {3.5033582359295187`*^9, 3.5033582359295187`*^9}, 
   3.5033587716500597`*^9, {3.5033592366772776`*^9, 3.5033592415912857`*^9}, {
   3.5034170926496334`*^9, 3.5034170932396345`*^9}, {3.50341731863995*^9, 
   3.5034173205599527`*^9}, {3.503851953644141*^9, 3.5038519544085426`*^9}, {
   3.5040546329056635`*^9, 3.5040546350056667`*^9}, 3.504313250194517*^9, 
   3.504371836973419*^9, {3.504986705898155*^9, 3.5049867077581577`*^9}, 
   3.508728456073549*^9, 3.512779601076296*^9, 3.5127801457070584`*^9, {
   3.5127802233571672`*^9, 3.5127802235871677`*^9}, {3.51278025408721*^9, 
   3.512780265277226*^9}, {3.512780335667324*^9, 3.512780345447338*^9}, {
   3.5130461983174324`*^9, 3.5130461983174324`*^9}, 3.5148396661076975`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "/", "2"}]], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", " ", 
      FractionBox["B", "b"]}]}], " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "/", "2"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"m", "/", "2"}]], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497986264165859*^9, 3.4979862650706606`*^9}, {
   3.50065955661592*^9, 3.500659559295924*^9}, {3.5006614622785883`*^9, 
   3.5006614724286027`*^9}, {3.5012664315897408`*^9, 
   3.5012664362597475`*^9}, {3.503851593345908*^9, 3.5038516176195507`*^9}, {
   3.503851659318424*^9, 3.503851669396042*^9}, {3.5038960491291866`*^9, 
   3.5038961614393435`*^9}, {3.508781189538858*^9, 3.508781191398861*^9}, {
   3.5098952060836363`*^9, 3.5098952076436386`*^9}, {3.512779909836728*^9, 
   3.5127799680168095`*^9}, {3.513046174367399*^9, 3.513046193577426*^9}, {
   3.515188097343418*^9, 3.515188121273452*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_", "+", 
        RowBox[{"B_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"B", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "m"}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "A"}], "-", 
         RowBox[{"a", "*", "B"}]}], ")"}], "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "m"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"m", "^", "2"}], "-", 
      RowBox[{"1", "/", "4"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, {3.497986265944262*^9, 3.497986266927064*^9}, 
   3.4979863675440407`*^9, {3.4979898830226145`*^9, 3.497989898497842*^9}, 
   3.498679361436646*^9, {3.5006592743055253`*^9, 3.5006592786455317`*^9}, {
   3.5006615196186686`*^9, 3.5006615252886767`*^9}, {3.5006616594288645`*^9, 
   3.5006616867589025`*^9}, {3.5012664627097845`*^9, 3.501266465839789*^9}, {
   3.501266520899866*^9, 3.501266533939884*^9}, 3.501266611849993*^9, {
   3.5038519476069307`*^9, 3.503851965609362*^9}, {3.5038519998670225`*^9, 
   3.5038520230642633`*^9}, {3.50385206705634*^9, 3.5038520751995544`*^9}, {
   3.5038961987193956`*^9, 3.503896203789403*^9}, 3.5038962631794863`*^9, {
   3.5087811920788617`*^9, 3.5087811936588635`*^9}, {3.509895208283639*^9, 
   3.5098952098536415`*^9}, {3.5127798768366823`*^9, 3.512779899586714*^9}, {
   3.5127800409369116`*^9, 3.512780050486925*^9}, {3.5127803121472917`*^9, 
   3.5127803271373124`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["i",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
        RowBox[{"n", "/", "2"}]]}], 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044136451914988`*^9, 3.50441429638241*^9, {3.5044703271693764`*^9, 
   3.504470336329389*^9}, {3.507605026068486*^9, 3.507605039298505*^9}, 
   3.5076058897996955`*^9, 3.507612730976883*^9, {3.5076833980984545`*^9, 
   3.5076834144316835`*^9}, {3.5076841143581123`*^9, 3.507684129458939*^9}, 
   3.5077429780811357`*^9, {3.5077509482580748`*^9, 3.507750951268079*^9}, {
   3.507752914548833*^9, 3.5077529156288347`*^9}, {3.5083803730605345`*^9, 
   3.5083803752405376`*^9}, {3.5084343251540623`*^9, 3.508434327354065*^9}, {
   3.5084350718951073`*^9, 3.508435076975115*^9}, {3.5086310587757254`*^9, 
   3.508631059696127*^9}, 3.508684761506933*^9, 3.5086849462816324`*^9, 
   3.5087278176184263`*^9, 3.5087278632485065`*^9, 3.508728526195672*^9, {
   3.5087811981988697`*^9, 3.508781198788871*^9}, {3.5098952167436514`*^9, 
   3.509895217303652*^9}, {3.5121539946522217`*^9, 3.5121539948522215`*^9}, {
   3.512434797917467*^9, 3.5124348012774715`*^9}, 3.512590151049988*^9, 
   3.5125960113311768`*^9, {3.512780504737561*^9, 3.5127805165975776`*^9}, 
   3.512780767267929*^9, 3.5148396846577234`*^9, {3.514857230029027*^9, 
   3.5148572304502277`*^9}, {3.515188125003457*^9, 3.515188125593458*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.500666948156269*^9, 3.5006669508262725`*^9}, {
   3.512435168007985*^9, 3.512435173767993*^9}, {3.5125902072021995`*^9, 
   3.5125902082532597`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", "z"}]}], "z"], "=", 
   RowBox[{"B", "+", 
    RowBox[{"A", 
     FractionBox["1", "z"]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.5004274880015464`*^9, 3.500427526248734*^9}, {
   3.500577748166791*^9, 3.5005777941712723`*^9}, {3.5005778953918495`*^9, 
   3.5005778978566537`*^9}, {3.5006681103278956`*^9, 3.500668167617976*^9}, {
   3.5006682214480515`*^9, 3.500668278938132*^9}, {3.500668429098342*^9, 
   3.5006684314183455`*^9}, {3.5007438770458975`*^9, 3.500743899705929*^9}, {
   3.5007439773260374`*^9, 3.5007440143660893`*^9}, {3.500744077676178*^9, 
   3.5007440802161818`*^9}, {3.508781140228789*^9, 3.5087811407387896`*^9}, {
   3.5087812197089005`*^9, 3.5087812205389013`*^9}, {3.510585830679161*^9, 
   3.510585864979209*^9}, {3.5127800968769903`*^9, 3.5127801321370397`*^9}, {
   3.5127806894278193`*^9, 3.512780715517856*^9}, {3.5127807577679157`*^9, 
   3.5127807590079174`*^9}}],

Cell[TextData[{
 "Rule i: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    SuperscriptBox["n", "2"]}], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.502677309791684*^9, 3.502677315931693*^9}, {
   3.502767275678668*^9, 3.502767275678668*^9}, {3.5027682258967376`*^9, 
   3.502768240248763*^9}, 3.502768355688966*^9, {3.5033578653664684`*^9, 
   3.50335786655207*^9}, {3.5033582359295187`*^9, 3.5033582359295187`*^9}, 
   3.5033587716500597`*^9, {3.5033592366772776`*^9, 3.5033592415912857`*^9}, {
   3.5034170926496334`*^9, 3.5034170932396345`*^9}, {3.50341731863995*^9, 
   3.5034173205599527`*^9}, {3.503851953644141*^9, 3.5038519544085426`*^9}, {
   3.5040546329056635`*^9, 3.5040546350056667`*^9}, 3.504313250194517*^9, 
   3.504371836973419*^9, {3.504986705898155*^9, 3.5049867077581577`*^9}, 
   3.508728456073549*^9, 3.512779601076296*^9, 3.5127801457070584`*^9, {
   3.5127802233571672`*^9, 3.5127802235871677`*^9}, {3.51278025408721*^9, 
   3.512780265277226*^9}, {3.512780335667324*^9, 3.512780345447338*^9}, {
   3.512780881498089*^9, 3.5127808834780912`*^9}, {3.5144369094244747`*^9, 
   3.5144369100484753`*^9}, 3.514839687607727*^9, {3.5148572470018563`*^9, 
   3.5148572470018563`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "/", "2"}]]}], 
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", "B"}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "/", "2"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{"A", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "/", "2"}]], 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, 
   3.4991797926481485`*^9, {3.4991798252678056`*^9, 3.499179837935028*^9}, {
   3.499180927976143*^9, 3.499180938599762*^9}, {3.4991810132614927`*^9, 
   3.4991810250395136`*^9}, {3.4991962578715715`*^9, 
   3.4991962790096083`*^9}, {3.499196703083153*^9, 3.4991967615208554`*^9}, {
   3.499197192643613*^9, 3.499197222845266*^9}, {3.4991977240625467`*^9, 
   3.4991977407233753`*^9}, {3.499197780737446*^9, 3.4991977890990605`*^9}, {
   3.4991980290346823`*^9, 3.4991980546967273`*^9}, {3.499198191403367*^9, 
   3.499198208017396*^9}, {3.499198305326367*^9, 3.4991983055447674`*^9}, {
   3.499198375223689*^9, 3.4991983899189153`*^9}, 3.499198439702202*^9, {
   3.4992136675539966`*^9, 3.4992137193140693`*^9}, 3.499213754044118*^9, {
   3.4992161931675324`*^9, 3.499216193677533*^9}, {3.4992162414576*^9, 
   3.4992163332577286`*^9}, {3.4992164987579603`*^9, 
   3.4992165531380367`*^9}, {3.4993646678093863`*^9, 
   3.4993647284894705`*^9}, {3.499364780039543*^9, 3.499364804929578*^9}, {
   3.499364846769636*^9, 3.4993648633396597`*^9}, {3.499404320916315*^9, 
   3.499404323956319*^9}, {3.499404813317004*^9, 3.499404815097007*^9}, {
   3.5003179817729173`*^9, 3.5003179820537176`*^9}, 3.5003181967000947`*^9, {
   3.5004019027833333`*^9, 3.5004019090077443`*^9}, {3.5004019461670094`*^9, 
   3.5004019604098344`*^9}, {3.5004020022023077`*^9, 
   3.5004020999052796`*^9}, {3.500403170537961*^9, 3.5004031709747615`*^9}, {
   3.5004032188980455`*^9, 3.500403243093688*^9}, {3.500596131704683*^9, 
   3.5005961322818837`*^9}, {3.500596573684659*^9, 3.50059658569668*^9}, {
   3.500596750360569*^9, 3.500596757676982*^9}, {3.5005968433423324`*^9, 
   3.500596857273157*^9}, {3.5005972743710895`*^9, 3.5005972953687263`*^9}, {
   3.5005986514683084`*^9, 3.5005986952419853`*^9}, {3.500598795206961*^9, 
   3.5005987969385643`*^9}, {3.5005989433292212`*^9, 
   3.5005989622364545`*^9}, {3.500691131426506*^9, 3.5006911595265455`*^9}, {
   3.500698437682624*^9, 3.5006985085691485`*^9}, {3.5006991256250324`*^9, 
   3.5006991261554337`*^9}, {3.500699909510809*^9, 3.5006999123968143`*^9}, {
   3.5007476294511504`*^9, 3.500747637191161*^9}, {3.500747709211262*^9, 
   3.500747734041297*^9}, {3.500749692956047*^9, 3.500749800106197*^9}, {
   3.500749865346288*^9, 3.500749878266306*^9}, {3.5010434600668535`*^9, 
   3.5010434941698046`*^9}, {3.508727616939674*^9, 3.5087276799325843`*^9}, {
   3.5087811992188716`*^9, 3.508781200558873*^9}, {3.509895217893653*^9, 
   3.509895219353655*^9}, {3.5127807851079535`*^9, 3.512780795857969*^9}, {
   3.514857235801037*^9, 3.51485724328905*^9}, {3.515188126583459*^9, 
   3.5151881283434615`*^9}, 3.51535146551799*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], "/", 
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{"B", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], ",", 
        "x"}], "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"A", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"n", "^", "2"}], "-", 
      RowBox[{"1", "/", "4"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.4991796252286544`*^9, 3.499179629191061*^9}, {
   3.4991799423928113`*^9, 3.499179956230036*^9}, {3.499179994189703*^9, 
   3.49918001520294*^9}, 3.4991802628689747`*^9, {3.4991809464777756`*^9, 
   3.499180955822192*^9}, {3.499181041294742*^9, 3.499181080638011*^9}, 
   3.4991882648154335`*^9, {3.4992137616941285`*^9, 3.4992137626741295`*^9}, 
   3.4992139059543304`*^9, {3.4992140832345786`*^9, 3.4992141086946144`*^9}, 
   3.499214216934766*^9, {3.499216208717554*^9, 3.4992162138475614`*^9}, {
   3.4992164326178675`*^9, 3.499216489837948*^9}, {3.499216616588125*^9, 
   3.4992166411581593`*^9}, 3.4992167074782524`*^9, {3.499216790438369*^9, 
   3.4992167911383696`*^9}, 3.499216873638485*^9, {3.4993649181097364`*^9, 
   3.4993649626097984`*^9}, {3.499365011309867*^9, 3.4993650116798673`*^9}, {
   3.499365165120082*^9, 3.499365167950086*^9}, {3.4993654481904783`*^9, 
   3.499365494270543*^9}, {3.4993661831115074`*^9, 3.499366184461509*^9}, {
   3.5003179820849175`*^9, 3.500317982365718*^9}, 3.5003187900234127`*^9, {
   3.5003190903738327`*^9, 3.5003191035638514`*^9}, 3.5003192263540235`*^9, 
   3.5003207542961626`*^9, {3.5003443675174456`*^9, 3.5003443741274548`*^9}, {
   3.500401911082548*^9, 3.500401988302684*^9}, {3.50040213985695*^9, 
   3.5004021729914083`*^9}, {3.5004031800539775`*^9, 3.500403180319178*^9}, {
   3.500403232142469*^9, 3.500403268053732*^9}, {3.5004319798384647`*^9, 
   3.5004319809015255`*^9}, {3.5005965174777603`*^9, 3.500596550487418*^9}, {
   3.5005972239830008`*^9, 3.500597224747402*^9}, 3.500597471227835*^9, {
   3.5005975330039434`*^9, 3.5005975372471514`*^9}, {3.5005976992690353`*^9, 
   3.500597700205037*^9}, {3.500597773057165*^9, 3.5005977749135685`*^9}, 
   3.5005981390074086`*^9, 3.500598274290846*^9, {3.5005987787177324`*^9, 
   3.5005988410086412`*^9}, {3.5005988915527306`*^9, 3.500598897730341*^9}, {
   3.5006911912365904`*^9, 3.5006912140666223`*^9}, {3.500698375032914*^9, 
   3.5006983872945356`*^9}, {3.5006985524520254`*^9, 3.500698556804433*^9}, {
   3.500698594132099*^9, 3.5006986357997723`*^9}, {3.5006991295250397`*^9, 
   3.500699130492241*^9}, {3.5006999309920473`*^9, 3.5006999574028935`*^9}, {
   3.5007476502811794`*^9, 3.5007476639111986`*^9}, {3.5007477113312654`*^9, 
   3.5007477359912996`*^9}, {3.5007481338098617`*^9, 3.500748134229862*^9}, {
   3.5007484134002533`*^9, 3.5007484296702757`*^9}, {3.5007489493750057`*^9, 
   3.5007489584850187`*^9}, {3.500749461305722*^9, 3.500749464515727*^9}, 
   3.5007498178562217`*^9, {3.500749961826423*^9, 3.500749989006461*^9}, 
   3.50075581694462*^9, {3.500755978744847*^9, 3.5007559802248487`*^9}, {
   3.508727709245036*^9, 3.5087277430190954`*^9}, {3.5087812014288745`*^9, 
   3.508781205948881*^9}, {3.5098952199636555`*^9, 3.509895221673658*^9}, {
   3.512261089727416*^9, 3.5122610933778224`*^9}, {3.5122614749152927`*^9, 
   3.5122614779728985`*^9}, {3.5124352403580866`*^9, 
   3.5124352437380915`*^9}, {3.5125960211377373`*^9, 
   3.5125960253509784`*^9}, {3.512780558667637*^9, 3.512780588087678*^9}, {
   3.5127808336880217`*^9, 3.512780837678027*^9}, {3.5127822390139914`*^9, 
   3.5127822424039965`*^9}, {3.514436904838066*^9, 3.5144369057116675`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["j",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044136451914988`*^9, 3.50441429638241*^9, {3.5044703271693764`*^9, 
   3.504470336329389*^9}, {3.507605026068486*^9, 3.507605039298505*^9}, 
   3.5076058897996955`*^9, 3.507612730976883*^9, {3.5076833980984545`*^9, 
   3.5076834144316835`*^9}, {3.5076841143581123`*^9, 3.507684129458939*^9}, 
   3.5077429780811357`*^9, {3.5077509482580748`*^9, 3.507750951268079*^9}, {
   3.507752914548833*^9, 3.5077529156288347`*^9}, {3.5083803730605345`*^9, 
   3.5083803752405376`*^9}, {3.5084343251540623`*^9, 3.508434327354065*^9}, {
   3.5084350718951073`*^9, 3.508435076975115*^9}, {3.5086310587757254`*^9, 
   3.508631059696127*^9}, 3.508684761506933*^9, 3.5086849462816324`*^9, 
   3.5087278176184263`*^9, 3.5087278632485065`*^9, 3.5087279482530556`*^9, 
   3.5087282833188453`*^9, {3.5087811659688253`*^9, 3.5087811664988256`*^9}, {
   3.5098951409435453`*^9, 3.509895141423546*^9}, {3.51215398639221*^9, 
   3.51215398660221*^9}, 3.5148397032877493`*^9, {3.5151881324234676`*^9, 
   3.5151881329734683`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017234466769753`*^9, {3.503797992634972*^9, 3.5037979962649775`*^9}}],

Cell[TextData[{
 "Rule j: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"A", "-", "B"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, 
   3.501360698386026*^9, 3.502764465517331*^9, {3.502764564717905*^9, 
   3.5027645817219353`*^9}, {3.5037980299950247`*^9, 3.503798035475032*^9}, {
   3.5040546474156837`*^9, 3.5040546480056844`*^9}, 3.504067915938857*^9, 
   3.5043132597145305`*^9, 3.5043718458934317`*^9, 3.504469727578537*^9, 
   3.5049867305081897`*^9, 3.5084646985879407`*^9, 3.508728287499653*^9, 
   3.5148397058077526`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", "B"}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "-", "B"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5027646753844995`*^9, 
   3.50276471530497*^9}, {3.5037980479050493`*^9, 3.5037980599950666`*^9}, 
   3.5084645619005003`*^9, {3.508781166788826*^9, 3.5087811683088284`*^9}, {
   3.509895142433547*^9, 3.50989514430355*^9}, {3.5151881339934697`*^9, 
   3.5151881363434725`*^9}, 3.5153514785908127`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"B", "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A", "-", "B"}], ")"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"A", "-", "B"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 
   3.5026762460801954`*^9}, {3.502764786051094*^9, 3.5027647961911116`*^9}, {
   3.502764926856941*^9, 3.5027649339081535`*^9}, {3.5030721797285376`*^9, 
   3.503072184728544*^9}, 3.5037981585652046`*^9, {3.5037982066152716`*^9, 
   3.503798261835349*^9}, {3.5038144679331737`*^9, 3.5038144831588*^9}, 
   3.5038761892995715`*^9, {3.508781168508828*^9, 3.508781170298831*^9}, {
   3.5098951452635508`*^9, 3.5098951475835543`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["k",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      SqrtBox[
       RowBox[{"e", "+", 
        RowBox[{"f", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044136451914988`*^9, 3.50441429638241*^9, {3.5044703271693764`*^9, 
   3.504470336329389*^9}, {3.507605026068486*^9, 3.507605039298505*^9}, 
   3.5076058897996955`*^9, 3.507612730976883*^9, {3.5076833980984545`*^9, 
   3.5076834144316835`*^9}, {3.5076841143581123`*^9, 3.507684129458939*^9}, 
   3.5077429780811357`*^9, {3.5077509482580748`*^9, 3.507750951268079*^9}, {
   3.507752914548833*^9, 3.5077529156288347`*^9}, {3.5083803730605345`*^9, 
   3.5083803752405376`*^9}, {3.5084343251540623`*^9, 3.508434327354065*^9}, {
   3.5084350718951073`*^9, 3.508435076975115*^9}, {3.5086310587757254`*^9, 
   3.508631059696127*^9}, 3.508684761506933*^9, 3.5086849462816324`*^9, 
   3.5087278176184263`*^9, 3.5087278632485065`*^9, 3.508728526195672*^9, {
   3.5087811981988697`*^9, 3.508781198788871*^9}, {3.5098952167436514`*^9, 
   3.509895217303652*^9}, {3.5121539946522217`*^9, 3.5121539948522215`*^9}, {
   3.512434797917467*^9, 3.5124348012774715`*^9}, {3.5125901159179783`*^9, 
   3.5125901170400424`*^9}, {3.512591559771562*^9, 3.512591564917856*^9}, 
   3.512591602595011*^9, {3.5125965790956507`*^9, 3.512596591810378*^9}, {
   3.5125967634381948`*^9, 3.512596765771328*^9}, {3.512781055998333*^9, 
   3.512781058718337*^9}, {3.51278113244844*^9, 3.5127811430184546`*^9}, {
   3.5127837194340706`*^9, 3.5127837205940723`*^9}, {3.512783848384251*^9, 
   3.512783849734253*^9}, 3.5127840664945564`*^9, 3.5148397207677736`*^9, {
   3.515188143383483*^9, 3.5151881439334836`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic transformation", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.500666948156269*^9, 3.5006669508262725`*^9}, {
   3.512435168007985*^9, 3.512435173767993*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", "z"}]}], ")"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "z"}]}]]}], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", "A"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "A"}], "+", 
        RowBox[{"a", " ", "B"}]}], ")"}], " ", "z"}], "+", 
     RowBox[{"b", " ", "B", " ", 
      SuperscriptBox["z", "2"]}]}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "z"}]}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.5004274880015464`*^9, 3.500427526248734*^9}, {
   3.500577748166791*^9, 3.5005777941712723`*^9}, {3.5005778953918495`*^9, 
   3.5005778978566537`*^9}, {3.5006681103278956`*^9, 3.500668167617976*^9}, {
   3.5006682214480515`*^9, 3.500668278938132*^9}, {3.500668429098342*^9, 
   3.5006684314183455`*^9}, {3.5007438770458975`*^9, 3.500743899705929*^9}, {
   3.5007439773260374`*^9, 3.5007440143660893`*^9}, {3.500744077676178*^9, 
   3.5007440802161818`*^9}, {3.508781140228789*^9, 3.5087811407387896`*^9}, {
   3.5087812197089005`*^9, 3.5087812205389013`*^9}, {3.510585830679161*^9, 
   3.510585864979209*^9}, {3.5127800968769903`*^9, 3.5127801321370397`*^9}, {
   3.5127806894278193`*^9, 3.512780715517856*^9}, {3.5127807577679157`*^9, 
   3.5127807590079174`*^9}, {3.5127839083543353`*^9, 3.512783963244412*^9}}],

Cell[TextData[{
 "Rule k: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["e", "2"], "-", 
     SuperscriptBox["f", "2"]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, 
   3.501360698386026*^9, 3.502764465517331*^9, {3.502764564717905*^9, 
   3.5027645817219353`*^9}, {3.5037980299950247`*^9, 3.503798035475032*^9}, {
   3.5040546474156837`*^9, 3.5040546480056844`*^9}, 3.504067915938857*^9, 
   3.5043132597145305`*^9, 3.5043718458934317`*^9, 3.504469727578537*^9, 
   3.5049867305081897`*^9, 3.5076028120009527`*^9, 3.507603381341749*^9, 
   3.5084622641828637`*^9, 3.5084624056439123`*^9, 3.508462585481028*^9, {
   3.508464717838374*^9, 3.5084647240939856`*^9}, 3.508466034611488*^9, {
   3.5087283682921944`*^9, 3.508728368635395*^9}, {3.5127812119185514`*^9, 
   3.5127812137585535`*^9}, {3.5127842045147495`*^9, 3.512784205134751*^9}, {
   3.5144694740864077`*^9, 3.5144694871904306`*^9}, 3.5148397242577786`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
    SqrtBox[
     RowBox[{"e", "+", 
      RowBox[{"f", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"a", " ", "A"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", " ", "A"}], "+", 
            RowBox[{"a", " ", "B"}]}], ")"}], " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"b", " ", "B", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
        RowBox[{
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
         SqrtBox[
          RowBox[{"e", "+", 
           RowBox[{"f", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, 
   3.4991797926481485`*^9, {3.4991798252678056`*^9, 3.499179837935028*^9}, {
   3.499180927976143*^9, 3.499180938599762*^9}, {3.4991810132614927`*^9, 
   3.4991810250395136`*^9}, {3.4991962578715715`*^9, 
   3.4991962790096083`*^9}, {3.499196703083153*^9, 3.4991967615208554`*^9}, {
   3.499197192643613*^9, 3.499197222845266*^9}, {3.4991977240625467`*^9, 
   3.4991977407233753`*^9}, {3.499197780737446*^9, 3.4991977890990605`*^9}, {
   3.4991980290346823`*^9, 3.4991980546967273`*^9}, {3.499198191403367*^9, 
   3.499198208017396*^9}, {3.499198305326367*^9, 3.4991983055447674`*^9}, {
   3.499198375223689*^9, 3.4991983899189153`*^9}, 3.499198439702202*^9, {
   3.4992136675539966`*^9, 3.4992137193140693`*^9}, 3.499213754044118*^9, {
   3.4992161931675324`*^9, 3.499216193677533*^9}, {3.4992162414576*^9, 
   3.4992163332577286`*^9}, {3.4992164987579603`*^9, 
   3.4992165531380367`*^9}, {3.4993646678093863`*^9, 
   3.4993647284894705`*^9}, {3.499364780039543*^9, 3.499364804929578*^9}, {
   3.499364846769636*^9, 3.4993648633396597`*^9}, {3.499404320916315*^9, 
   3.499404323956319*^9}, {3.499404813317004*^9, 3.499404815097007*^9}, {
   3.5003179817729173`*^9, 3.5003179820537176`*^9}, 3.5003181967000947`*^9, {
   3.5004019027833333`*^9, 3.5004019090077443`*^9}, {3.5004019461670094`*^9, 
   3.5004019604098344`*^9}, {3.5004020022023077`*^9, 
   3.5004020999052796`*^9}, {3.500403170537961*^9, 3.5004031709747615`*^9}, {
   3.5004032188980455`*^9, 3.500403243093688*^9}, {3.500596131704683*^9, 
   3.5005961322818837`*^9}, {3.500596573684659*^9, 3.50059658569668*^9}, {
   3.500596750360569*^9, 3.500596757676982*^9}, {3.5005968433423324`*^9, 
   3.500596857273157*^9}, {3.5005972743710895`*^9, 3.5005972953687263`*^9}, {
   3.5005986514683084`*^9, 3.5005986952419853`*^9}, {3.500598795206961*^9, 
   3.5005987969385643`*^9}, {3.5005989433292212`*^9, 
   3.5005989622364545`*^9}, {3.500691131426506*^9, 3.5006911595265455`*^9}, {
   3.500698437682624*^9, 3.5006985085691485`*^9}, {3.5006991256250324`*^9, 
   3.5006991261554337`*^9}, {3.500699909510809*^9, 3.5006999123968143`*^9}, {
   3.5007476294511504`*^9, 3.500747637191161*^9}, {3.500747709211262*^9, 
   3.500747734041297*^9}, {3.500749692956047*^9, 3.500749800106197*^9}, {
   3.500749865346288*^9, 3.500749878266306*^9}, {3.5010434600668535`*^9, 
   3.5010434941698046`*^9}, {3.508727616939674*^9, 3.5087276799325843`*^9}, {
   3.5087811992188716`*^9, 3.508781200558873*^9}, {3.509895217893653*^9, 
   3.509895219353655*^9}, {3.5124348234275026`*^9, 3.512434841957529*^9}, {
   3.5124348793375807`*^9, 3.512434887837593*^9}, {3.5124349625876975`*^9, 
   3.5124349725077114`*^9}, {3.512591505209441*^9, 3.5125915088706503`*^9}, 
   3.512591589148242*^9, {3.5125966045651073`*^9, 3.512596612951587*^9}, {
   3.512779409076027*^9, 3.5127794122160316`*^9}, {3.5127837249540787`*^9, 
   3.5127837365040946`*^9}, {3.515188144853485*^9, 3.515188146433487*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"e_.", "+", 
        RowBox[{"f_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", "A"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "A"}], "+", 
           RowBox[{"a", "*", "B"}]}], ")"}], "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"b", "*", "B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"e", "+", 
          RowBox[{"f", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "A", ",", 
        "B"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"e", "^", "2"}], "-", 
      RowBox[{"f", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.4991796252286544`*^9, 3.499179629191061*^9}, {
   3.4991799423928113`*^9, 3.499179956230036*^9}, {3.499179994189703*^9, 
   3.49918001520294*^9}, 3.4991802628689747`*^9, {3.4991809464777756`*^9, 
   3.499180955822192*^9}, {3.499181041294742*^9, 3.499181080638011*^9}, 
   3.4991882648154335`*^9, {3.4992137616941285`*^9, 3.4992137626741295`*^9}, 
   3.4992139059543304`*^9, {3.4992140832345786`*^9, 3.4992141086946144`*^9}, 
   3.499214216934766*^9, {3.499216208717554*^9, 3.4992162138475614`*^9}, {
   3.4992164326178675`*^9, 3.499216489837948*^9}, {3.499216616588125*^9, 
   3.4992166411581593`*^9}, 3.4992167074782524`*^9, {3.499216790438369*^9, 
   3.4992167911383696`*^9}, 3.499216873638485*^9, {3.4993649181097364`*^9, 
   3.4993649626097984`*^9}, {3.499365011309867*^9, 3.4993650116798673`*^9}, {
   3.499365165120082*^9, 3.499365167950086*^9}, {3.4993654481904783`*^9, 
   3.499365494270543*^9}, {3.4993661831115074`*^9, 3.499366184461509*^9}, {
   3.5003179820849175`*^9, 3.500317982365718*^9}, 3.5003187900234127`*^9, {
   3.5003190903738327`*^9, 3.5003191035638514`*^9}, 3.5003192263540235`*^9, 
   3.5003207542961626`*^9, {3.5003443675174456`*^9, 3.5003443741274548`*^9}, {
   3.500401911082548*^9, 3.500401988302684*^9}, {3.50040213985695*^9, 
   3.5004021729914083`*^9}, {3.5004031800539775`*^9, 3.500403180319178*^9}, {
   3.500403232142469*^9, 3.500403268053732*^9}, {3.5004319798384647`*^9, 
   3.5004319809015255`*^9}, {3.5005965174777603`*^9, 3.500596550487418*^9}, {
   3.5005972239830008`*^9, 3.500597224747402*^9}, 3.500597471227835*^9, {
   3.5005975330039434`*^9, 3.5005975372471514`*^9}, {3.5005976992690353`*^9, 
   3.500597700205037*^9}, {3.500597773057165*^9, 3.5005977749135685`*^9}, 
   3.5005981390074086`*^9, 3.500598274290846*^9, {3.5005987787177324`*^9, 
   3.5005988410086412`*^9}, {3.5005988915527306`*^9, 3.500598897730341*^9}, {
   3.5006911912365904`*^9, 3.5006912140666223`*^9}, {3.500698375032914*^9, 
   3.5006983872945356`*^9}, {3.5006985524520254`*^9, 3.500698556804433*^9}, {
   3.500698594132099*^9, 3.5006986357997723`*^9}, {3.5006991295250397`*^9, 
   3.500699130492241*^9}, {3.5006999309920473`*^9, 3.5006999574028935`*^9}, {
   3.5007476502811794`*^9, 3.5007476639111986`*^9}, {3.5007477113312654`*^9, 
   3.5007477359912996`*^9}, {3.5007481338098617`*^9, 3.500748134229862*^9}, {
   3.5007484134002533`*^9, 3.5007484296702757`*^9}, {3.5007489493750057`*^9, 
   3.5007489584850187`*^9}, {3.500749461305722*^9, 3.500749464515727*^9}, 
   3.5007498178562217`*^9, {3.500749961826423*^9, 3.500749989006461*^9}, 
   3.50075581694462*^9, {3.500755978744847*^9, 3.5007559802248487`*^9}, {
   3.508727709245036*^9, 3.5087277430190954`*^9}, {3.5087812014288745`*^9, 
   3.508781205948881*^9}, {3.5098952199636555`*^9, 3.509895221673658*^9}, {
   3.512261089727416*^9, 3.5122610933778224`*^9}, {3.5122614749152927`*^9, 
   3.5122614779728985`*^9}, {3.5124349983177476`*^9, 
   3.5124350487178183`*^9}, {3.512435083677867*^9, 3.5124350863378706`*^9}, {
   3.512585226382313*^9, 3.5125852285424366`*^9}, {3.512585886078045*^9, 
   3.512585892350404*^9}, {3.512586811772992*^9, 3.5125868153301954`*^9}, {
   3.512586866705134*^9, 3.512586870994379*^9}, {3.512590105957409*^9, 
   3.5125901093826046`*^9}, {3.512591455469596*^9, 3.512591465137149*^9}, {
   3.5125915135549183`*^9, 3.512591547934885*^9}, {3.512594293323912*^9, 
   3.512594297411146*^9}, {3.512596632562709*^9, 3.5125966885859137`*^9}, {
   3.5127837983541813`*^9, 3.512783829774225*^9}, 3.512783995484457*^9, {
   3.5127841133946223`*^9, 3.5127841463246684`*^9}, 3.5127849496357927`*^9, {
   3.5144151253607388`*^9, 3.5144151282939067`*^9}, {3.5144151702003036`*^9, 
   3.5144151722864227`*^9}, {3.51446879801682*^9, 3.514468802260027*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["l",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"3", "/", "2"}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044136451914988`*^9, 3.50441429638241*^9, {3.5044703271693764`*^9, 
   3.504470336329389*^9}, {3.507605026068486*^9, 3.507605039298505*^9}, 
   3.5076058897996955`*^9, 3.507612730976883*^9, {3.5076833980984545`*^9, 
   3.5076834144316835`*^9}, {3.5076841143581123`*^9, 3.507684129458939*^9}, 
   3.5077429780811357`*^9, {3.5077509482580748`*^9, 3.507750951268079*^9}, {
   3.507752914548833*^9, 3.5077529156288347`*^9}, {3.5083803730605345`*^9, 
   3.5083803752405376`*^9}, {3.5084343251540623`*^9, 3.508434327354065*^9}, {
   3.5084350718951073`*^9, 3.508435076975115*^9}, {3.5086310587757254`*^9, 
   3.508631059696127*^9}, 3.508684761506933*^9, 3.5086849462816324`*^9, {
   3.5087283564361734`*^9, 3.5087283590257783`*^9}, {3.5087811705488315`*^9, 
   3.5087811710388317`*^9}, {3.5098951483135552`*^9, 3.509895148933556*^9}, {
   3.5121539889822135`*^9, 3.512153989182214*^9}, 3.512781205258542*^9, 
   3.512784198164741*^9, 3.5148397341377926`*^9, {3.5151881497534914`*^9, 
   3.5151881502334924`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["\<\
Note: This rule is not essential, but produces simpler results.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}, {
   3.512080133307934*^9, 3.512080168407983*^9}}],

Cell[TextData[{
 "Rule l1: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, 
   3.501360698386026*^9, 3.502764465517331*^9, {3.502764564717905*^9, 
   3.5027645817219353`*^9}, {3.5037980299950247`*^9, 3.503798035475032*^9}, {
   3.5040546474156837`*^9, 3.5040546480056844`*^9}, 3.504067915938857*^9, 
   3.5043132597145305`*^9, 3.5043718458934317`*^9, 3.504469727578537*^9, 
   3.5049867305081897`*^9, 3.5076028120009527`*^9, 3.507603381341749*^9, 
   3.5084622641828637`*^9, 3.5084624056439123`*^9, 3.508462585481028*^9, {
   3.508464435337478*^9, 3.508464445820697*^9}, 3.508464704625151*^9, {
   3.508465975050583*^9, 3.508465975050583*^9}, 3.5084660319126835`*^9, {
   3.508781768199376*^9, 3.5087817689325776`*^9}, {3.512781208098546*^9, 
   3.512781208958547*^9}, {3.512784201024745*^9, 3.5127842013747454`*^9}, {
   3.514839736527796*^9, 3.5148397377377977`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "-", 
      RowBox[{"A", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"3", "/", "2"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"2", " ", "A", " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]], " ", 
        RowBox[{"Tan", "[", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"c", "-", 
            FractionBox["\[Pi]", "2"], "+", 
            RowBox[{"d", " ", "x"}]}], ")"}]}], "]"}]}], 
       RowBox[{"a", " ", "d", " ", 
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "A"}], "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5027646753844995`*^9, 
   3.50276471530497*^9}, {3.5037980479050493`*^9, 3.5037980599950666`*^9}, {
   3.5076028164109583`*^9, 3.50760283173098*^9}, 3.5076030276812544`*^9, 
   3.507603083321332*^9, {3.5076031354914055`*^9, 3.5076031677414503`*^9}, {
   3.5076037630722837`*^9, 3.507603768892292*^9}, {3.5084644139186406`*^9, 
   3.508464418068248*^9}, {3.508465970214575*^9, 3.508465971977378*^9}, {
   3.5086093404540854`*^9, 3.50860934307489*^9}, 3.5086094445998683`*^9, {
   3.5098951498535576`*^9, 3.5098951713635874`*^9}, 3.509899562800316*^9, {
   3.515188150573493*^9, 3.5151881560535*^9}, 3.5153514993856497`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"3", "/", "2"}], ")"}]}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "A", "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "-", 
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ")"}]}]}], " ", "-", 
    " ", "\n", "  ", 
    RowBox[{"2", "*", 
     RowBox[{"A", "/", "a"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}]}], ")"}]}], ",", 
       "x"}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"A", "+", "B"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 
   3.5026762460801954`*^9}, {3.502764786051094*^9, 3.5027647961911116`*^9}, {
   3.502764926856941*^9, 3.5027649339081535`*^9}, {3.5030721797285376`*^9, 
   3.503072184728544*^9}, 3.5037981585652046`*^9, {3.5037982066152716`*^9, 
   3.503798261835349*^9}, {3.5038144679331737`*^9, 3.5038144831588*^9}, 
   3.5038761892995715`*^9, {3.5076032842916136`*^9, 3.5076032858616157`*^9}, {
   3.507603348181703*^9, 3.5076033506417065`*^9}, 3.507603384601754*^9, {
   3.507603778382305*^9, 3.5076037814023094`*^9}, {3.50760398175259*^9, 
   3.5076039828325915`*^9}, {3.5076168975491977`*^9, 3.507616911901018*^9}, 
   3.5076171428842297`*^9, {3.508462191923537*^9, 3.508462219629185*^9}, {
   3.508609343886091*^9, 3.508609346881296*^9}, {3.5086094476418734`*^9, 
   3.5086094505590787`*^9}, {3.5098951724535894`*^9, 3.5098951786835976`*^9}, 
   3.509899668530464*^9, {3.5122606194465895`*^9, 3.5122606229097958`*^9}, {
   3.5122609226979227`*^9, 3.5122609272843304`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017234466769753`*^9, {3.503797992634972*^9, 3.5037979962649775`*^9}}],

Cell["\<\
Note: This rule is not essential, but produces simpler results.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}, {
   3.512080133307934*^9, 3.512080168407983*^9}}],

Cell[TextData[{
 "Rule l2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"A", "+", "B"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, 
   3.501360698386026*^9, 3.502764465517331*^9, {3.502764564717905*^9, 
   3.5027645817219353`*^9}, {3.5037980299950247`*^9, 3.503798035475032*^9}, {
   3.5040546474156837`*^9, 3.5040546480056844`*^9}, 3.504067915938857*^9, 
   3.5043132597145305`*^9, 3.5043718458934317`*^9, 3.504469727578537*^9, 
   3.5049867305081897`*^9, 3.5076028120009527`*^9, 3.507603381341749*^9, 
   3.5084622641828637`*^9, 3.5084624056439123`*^9, 3.508462585481028*^9, {
   3.508464717838374*^9, 3.5084647240939856`*^9}, 3.508466034611488*^9, {
   3.5087283682921944`*^9, 3.508728368635395*^9}, {3.5127812119185514`*^9, 
   3.5127812137585535`*^9}, {3.5127842045147495`*^9, 3.512784205134751*^9}, {
   3.514839741467803*^9, 3.5148397428278046`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"3", "/", "2"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{"A", "+", "B"}], ")"}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{"A", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "-", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"3", "/", "2"}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5027646753844995`*^9, 
   3.50276471530497*^9}, {3.5037980479050493`*^9, 3.5037980599950666`*^9}, {
   3.5076028164109583`*^9, 3.50760283173098*^9}, 3.5076030276812544`*^9, 
   3.507603083321332*^9, {3.5076031354914055`*^9, 3.5076031677414503`*^9}, {
   3.5076037630722837`*^9, 3.507603768892292*^9}, {3.5084645268628387`*^9, 
   3.5084645492332783`*^9}, {3.508465137759912*^9, 3.5084651425179205`*^9}, {
   3.5087811752188377`*^9, 3.5087811768988404`*^9}, {3.509895179563599*^9, 
   3.5098951821336026`*^9}, {3.5151881596935053`*^9, 3.515188162123509*^9}, 
   3.5153515040032578`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"3", "/", "2"}], ")"}]}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"A", "+", "B"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"A", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"3", "/", "2"}], ")"}]}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"A", "+", "B"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 
   3.5026762460801954`*^9}, {3.502764786051094*^9, 3.5027647961911116`*^9}, {
   3.502764926856941*^9, 3.5027649339081535`*^9}, {3.5030721797285376`*^9, 
   3.503072184728544*^9}, 3.5037981585652046`*^9, {3.5037982066152716`*^9, 
   3.503798261835349*^9}, {3.5038144679331737`*^9, 3.5038144831588*^9}, 
   3.5038761892995715`*^9, {3.5076032842916136`*^9, 3.5076032858616157`*^9}, {
   3.507603348181703*^9, 3.5076033506417065`*^9}, 3.507603384601754*^9, {
   3.507603778382305*^9, 3.5076037814023094`*^9}, {3.50760398175259*^9, 
   3.5076039828325915`*^9}, {3.5076168975491977`*^9, 3.507616911901018*^9}, 
   3.5076171428842297`*^9, 3.508464663363079*^9, {3.5084651469795284`*^9, 
   3.508465157244346*^9}, {3.508781177408841*^9, 3.5087811793388433`*^9}, {
   3.509895182833604*^9, 3.509895185183607*^9}, {3.512260626591402*^9, 
   3.5122606302418084`*^9}, {3.512260931277938*^9, 3.5122609344915433`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["m",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
        RowBox[{"3", "/", "2"}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044136451914988`*^9, 3.50441429638241*^9, {3.5044703271693764`*^9, 
   3.504470336329389*^9}, {3.507605026068486*^9, 3.507605039298505*^9}, 
   3.5076058897996955`*^9, 3.507612730976883*^9, {3.5076833980984545`*^9, 
   3.5076834144316835`*^9}, {3.5076841143581123`*^9, 3.507684129458939*^9}, 
   3.5077429780811357`*^9, {3.5077509482580748`*^9, 3.507750951268079*^9}, {
   3.507752914548833*^9, 3.5077529156288347`*^9}, {3.5083803730605345`*^9, 
   3.5083803752405376`*^9}, {3.5084343251540623`*^9, 3.508434327354065*^9}, {
   3.5084350718951073`*^9, 3.508435076975115*^9}, {3.5086310587757254`*^9, 
   3.508631059696127*^9}, 3.508684761506933*^9, 3.5086849696348734`*^9, 
   3.5087283801950154`*^9, {3.508781179598844*^9, 3.508781180088845*^9}, {
   3.509895185873608*^9, 3.509895186553609*^9}, {3.5121539904922156`*^9, 
   3.5121539906822157`*^9}, 3.5127812295885763`*^9, 3.512784211054759*^9, 
   3.5148397527978187`*^9, {3.5151881661435146`*^9, 3.5151881666535153`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Note: This rule is not essential, but produces simpler results.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}, {
   3.512080133307934*^9, 3.512080168407983*^9}}],

Cell[TextData[{
 "Rule m1: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, 
   3.501360698386026*^9, 3.502764465517331*^9, {3.502764564717905*^9, 
   3.5027645817219353`*^9}, {3.5037980299950247`*^9, 3.503798035475032*^9}, {
   3.5040546474156837`*^9, 3.5040546480056844`*^9}, 3.504067915938857*^9, 
   3.5043132597145305`*^9, 3.5043718458934317`*^9, 3.504469727578537*^9, 
   3.5049867305081897`*^9, 3.5076028120009527`*^9, 3.507603381341749*^9, 
   3.5076166844040065`*^9, 3.5076169631349487`*^9, 3.5076170103026466`*^9, 
   3.5084647013647456`*^9, {3.5084654902485313`*^9, 3.508465495427741*^9}, {
   3.5084658397827454`*^9, 3.508465846241157*^9}, {3.5087815739010353`*^9, 
   3.5087815745094366`*^9}, {3.5127812328185806`*^9, 
   3.5127812331985807`*^9}, {3.512784214554764*^9, 3.5127842148247643`*^9}, {
   3.5148397554578223`*^9, 3.5148397563278236`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"A", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]], " ", 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"2", "A", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b"}], ")"}], " ", 
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
        RowBox[{"Tan", "[", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"c", "-", 
            FractionBox["\[Pi]", "2"], "+", 
            RowBox[{"d", " ", "x"}]}], ")"}]}], "]"}]}], 
       RowBox[{"a", " ", "d", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "A"}], 
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5027646753844995`*^9, 
   3.50276471530497*^9}, {3.5037980479050493`*^9, 3.5037980599950666`*^9}, {
   3.5076028164109583`*^9, 3.50760283173098*^9}, 3.5076030276812544`*^9, 
   3.507603083321332*^9, {3.5076031354914055`*^9, 3.5076031677414503`*^9}, {
   3.5076037630722837`*^9, 3.507603768892292*^9}, {3.5076166976417637`*^9, 
   3.507616743269373*^9}, 3.5077428368384876`*^9, {3.508465470311697*^9, 
   3.508465473416102*^9}, {3.5084657204425364`*^9, 3.5084657263237467`*^9}, {
   3.508465770627824*^9, 3.508465814339101*^9}, {3.5086096384446087`*^9, 
   3.5086096573986416`*^9}, {3.5098951877036104`*^9, 3.5098951911336155`*^9}, 
   3.5098995776903367`*^9, {3.515188167493517*^9, 3.5151881695635195`*^9}, 
   3.515351519540885*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "A", "*", 
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "-", 
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", 
    "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"A", "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"A", "-", "B"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 
   3.5026762460801954`*^9}, {3.502764786051094*^9, 3.5027647961911116`*^9}, {
   3.502764926856941*^9, 3.5027649339081535`*^9}, {3.5030721797285376`*^9, 
   3.503072184728544*^9}, 3.5037981585652046`*^9, {3.5037982066152716`*^9, 
   3.503798261835349*^9}, {3.5038144679331737`*^9, 3.5038144831588*^9}, 
   3.5038761892995715`*^9, {3.5076032842916136`*^9, 3.5076032858616157`*^9}, {
   3.507603348181703*^9, 3.5076033506417065`*^9}, 3.507603384601754*^9, {
   3.507603778382305*^9, 3.5076037814023094`*^9}, {3.50760398175259*^9, 
   3.5076039828325915`*^9}, {3.5076168383998146`*^9, 
   3.5076168740008507`*^9}, {3.5076169982609577`*^9, 3.507617017165039*^9}, {
   3.507742845636903*^9, 3.5077428506289115`*^9}, {3.508465432980831*^9, 
   3.5084654555696707`*^9}, {3.508465835087137*^9, 3.508465836069939*^9}, 
   3.508465951166941*^9, {3.5086096414710135`*^9, 3.508609661563849*^9}, {
   3.5098951918436165`*^9, 3.5098951949836206`*^9}, 3.5098996727704697`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017234466769753`*^9, {3.503797992634972*^9, 3.5037979962649775`*^9}}],

Cell["\<\
Note: This rule is not essential, but produces simpler results.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}, {
   3.512080133307934*^9, 3.512080168407983*^9}}],

Cell[TextData[{
 "Rule m2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"A", "-", "B"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, 
   3.501360698386026*^9, 3.502764465517331*^9, {3.502764564717905*^9, 
   3.5027645817219353`*^9}, {3.5037980299950247`*^9, 3.503798035475032*^9}, {
   3.5040546474156837`*^9, 3.5040546480056844`*^9}, 3.504067915938857*^9, 
   3.5043132597145305`*^9, 3.5043718458934317`*^9, 3.504469727578537*^9, 
   3.5049867305081897`*^9, 3.5076028120009527`*^9, 3.507603381341749*^9, 
   3.5076166844040065`*^9, 3.5076169631349487`*^9, 3.5076170103026466`*^9, 
   3.5084647013647456`*^9, {3.5084654848821225`*^9, 3.5084654867853255`*^9}, 
   3.508466029182678*^9, {3.5087283844226227`*^9, 3.5087283847814236`*^9}, {
   3.5127812360285845`*^9, 3.512781236798586*^9}, {3.5127842177347684`*^9, 
   3.5127842184847693`*^9}, {3.5148397591278276`*^9, 3.514839759387828*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]], " ", 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"A", "-", "B"}], 
       RowBox[{"a", "-", "b"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], 
    RowBox[{"a", "-", "b"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
        RowBox[{"3", "/", "2"}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5027646753844995`*^9, 
   3.50276471530497*^9}, {3.5037980479050493`*^9, 3.5037980599950666`*^9}, {
   3.5076028164109583`*^9, 3.50760283173098*^9}, 3.5076030276812544`*^9, 
   3.507603083321332*^9, {3.5076031354914055`*^9, 3.5076031677414503`*^9}, {
   3.5076037630722837`*^9, 3.507603768892292*^9}, {3.5076166976417637`*^9, 
   3.507616743269373*^9}, 3.5077428368384876`*^9, {3.508465212858444*^9, 
   3.5084652831521673`*^9}, {3.50878118404885*^9, 3.5087811857788525`*^9}, {
   3.5098951961936226`*^9, 3.5098951986036253`*^9}, {3.513102718990695*^9, 
   3.5131027211506977`*^9}, {3.5151881726535234`*^9, 3.5151881745935264`*^9}, 
   3.515351523674892*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "-", "B"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "-", "b"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "A"}], "-", 
         RowBox[{"a", "*", "B"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "-", "b"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"A", "-", "B"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 
   3.5026762460801954`*^9}, {3.502764786051094*^9, 3.5027647961911116`*^9}, {
   3.502764926856941*^9, 3.5027649339081535`*^9}, {3.5030721797285376`*^9, 
   3.503072184728544*^9}, 3.5037981585652046`*^9, {3.5037982066152716`*^9, 
   3.503798261835349*^9}, {3.5038144679331737`*^9, 3.5038144831588*^9}, 
   3.5038761892995715`*^9, {3.5076032842916136`*^9, 3.5076032858616157`*^9}, {
   3.507603348181703*^9, 3.5076033506417065`*^9}, 3.507603384601754*^9, {
   3.507603778382305*^9, 3.5076037814023094`*^9}, {3.50760398175259*^9, 
   3.5076039828325915`*^9}, {3.5076168383998146`*^9, 
   3.5076168740008507`*^9}, {3.5076169982609577`*^9, 3.507617017165039*^9}, {
   3.507742845636903*^9, 3.5077428506289115`*^9}, 3.5084653592551017`*^9, {
   3.5084654269280205`*^9, 3.5084654294240246`*^9}, {3.5087811862888536`*^9, 
   3.508781188148856*^9}, {3.5098952004636283`*^9, 3.509895203923633*^9}, {
   3.51314708886782*^9, 3.5131470980078325`*^9}, {3.513147277568084*^9, 
   3.513147280998089*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["n",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"3", "/", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044136451914988`*^9, 3.50441429638241*^9, {3.5044703271693764`*^9, 
   3.504470336329389*^9}, {3.507605026068486*^9, 3.507605039298505*^9}, 
   3.5076058897996955`*^9, 3.507612730976883*^9, {3.5076833980984545`*^9, 
   3.5076834144316835`*^9}, {3.5076841143581123`*^9, 3.507684129458939*^9}, 
   3.5077429780811357`*^9, {3.5077509482580748`*^9, 3.507750951268079*^9}, {
   3.507752914548833*^9, 3.5077529156288347`*^9}, {3.5083803730605345`*^9, 
   3.5083803752405376`*^9}, {3.5084343251540623`*^9, 3.508434327354065*^9}, {
   3.5084350718951073`*^9, 3.508435076975115*^9}, {3.5086310587757254`*^9, 
   3.508631059696127*^9}, 3.508684761506933*^9, 3.5086849462816324`*^9, 
   3.5087278176184263`*^9, 3.5087278632485065`*^9, 3.508727955943869*^9, 
   3.508728480877592*^9, {3.508781193928864*^9, 3.5087811944388647`*^9}, {
   3.5098952106136427`*^9, 3.509895211123643*^9}, {3.5121539933422194`*^9, 
   3.5121539935222197`*^9}, {3.5123125021162634`*^9, 
   3.5123125189642935`*^9}, {3.5123126114412556`*^9, 3.5123126165112643`*^9}, 
   3.5127812470286007`*^9, 3.5127842277447824`*^9, 3.5148397701178427`*^9, {
   3.515188178143532*^9, 3.515188178693532*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, {3.4979866726025763`*^9, 
   3.497986673616578*^9}, {3.5006614307985444`*^9, 3.5006614323585463`*^9}, {
   3.5038516766032543`*^9, 3.5038516777264566`*^9}}],

Cell["\<\
Note: This rule is not essential, but produces simpler results.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}, {
   3.512080133307934*^9, 3.512080168407983*^9}}],

Cell[TextData[{
 "Rule n: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.502677309791684*^9, 3.502677315931693*^9}, {
   3.502767275678668*^9, 3.502767275678668*^9}, {3.5027682258967376`*^9, 
   3.502768240248763*^9}, 3.502768355688966*^9, {3.5033578653664684`*^9, 
   3.50335786655207*^9}, {3.5033582359295187`*^9, 3.5033582359295187`*^9}, 
   3.5033587716500597`*^9, {3.5033592366772776`*^9, 3.5033592415912857`*^9}, {
   3.5034170926496334`*^9, 3.5034170932396345`*^9}, {3.50341731863995*^9, 
   3.5034173205599527`*^9}, {3.503851953644141*^9, 3.5038519544085426`*^9}, {
   3.5040546377456703`*^9, 3.504054638355671*^9}, 3.504313254494523*^9, 
   3.504371840443424*^9, 3.5049867148981676`*^9, 3.508464696045136*^9, 
   3.5087284839039974`*^9, {3.512781249178603*^9, 3.5127812500386047`*^9}, {
   3.5127842295747848`*^9, 3.5127842305047865`*^9}, {3.5144693916870627`*^9, 
   3.514469392825865*^9}, 3.514839772327846*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"A", "-", "B"}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"A", "+", "B"}], ")"}]}]}], ")"}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"a", " ", "A"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", " ", "A"}], "-", 
         RowBox[{"b", " ", "B"}]}], ")"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", "B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"3", "/", "2"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497986264165859*^9, 3.4979862650706606`*^9}, {
   3.50065955661592*^9, 3.500659559295924*^9}, {3.5006614622785883`*^9, 
   3.5006614724286027`*^9}, {3.5012664315897408`*^9, 
   3.5012664362597475`*^9}, {3.503851593345908*^9, 3.5038516176195507`*^9}, {
   3.503851659318424*^9, 3.503851669396042*^9}, {3.508781194908866*^9, 
   3.5087811962788677`*^9}, {3.509895211843644*^9, 3.509895213973647*^9}, {
   3.5123125265147066`*^9, 3.512312577058795*^9}, 3.512312632501292*^9, {
   3.513053706363409*^9, 3.5130537114934163`*^9}, {3.5151881795535336`*^9, 
   3.5151881825235376`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"3", "/", "2"}], ")"}]}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"A", "-", "B"}], ")"}]}], "+", 
       RowBox[{"a", "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", "B"}], ")"}]}]}], ")"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sim", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "*", "A"}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "*", "A"}], "-", 
             RowBox[{"b", "*", "B"}]}], ")"}], "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"b", "*", "B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ",", "x"}], 
        "]"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"3", "/", "2"}], ")"}]}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, {3.497986265944262*^9, 3.497986266927064*^9}, 
   3.4979863675440407`*^9, {3.4979898830226145`*^9, 3.497989898497842*^9}, 
   3.498679361436646*^9, {3.5006592743055253`*^9, 3.5006592786455317`*^9}, {
   3.5006615196186686`*^9, 3.5006615252886767`*^9}, {3.5006616594288645`*^9, 
   3.5006616867589025`*^9}, {3.5012664627097845`*^9, 3.501266465839789*^9}, {
   3.501266520899866*^9, 3.501266533939884*^9}, 3.501266611849993*^9, {
   3.5038519476069307`*^9, 3.503851965609362*^9}, {3.5038519998670225`*^9, 
   3.5038520230642633`*^9}, {3.50385206705634*^9, 3.5038520751995544`*^9}, {
   3.5087811965088673`*^9, 3.5087811979688697`*^9}, {3.509895214393648*^9, 
   3.5098952161736507`*^9}, {3.512312668646556*^9, 3.512312694433401*^9}, {
   3.5123128029783916`*^9, 3.5123128244596295`*^9}, {3.512435249318099*^9, 
   3.5124352534781046`*^9}, {3.512586742884052*^9, 3.512586748612379*^9}, {
   3.512586833401229*^9, 3.512586836963433*^9}, {3.512590374969795*^9, 
   3.5125903778759613`*^9}, {3.5130537174834247`*^9, 3.513053741413458*^9}, {
   3.513053815453562*^9, 3.513053823363573*^9}, {3.5130540402638764`*^9, 
   3.513054043593881*^9}, 3.514469387365855*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["o",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044136451914988`*^9, 3.50441429638241*^9, {3.5044703271693764`*^9, 
   3.504470336329389*^9}, {3.507605026068486*^9, 3.507605039298505*^9}, 
   3.5076058897996955`*^9, 3.507612730976883*^9, {3.5076833980984545`*^9, 
   3.5076834144316835`*^9}, {3.5076841143581123`*^9, 3.507684129458939*^9}, 
   3.5077429780811357`*^9, {3.5077509482580748`*^9, 3.507750951268079*^9}, {
   3.507752914548833*^9, 3.5077529156288347`*^9}, {3.5083803730605345`*^9, 
   3.5083803752405376`*^9}, {3.5084343251540623`*^9, 3.508434327354065*^9}, {
   3.5084350718951073`*^9, 3.508435076975115*^9}, {3.5086310587757254`*^9, 
   3.508631059696127*^9}, 3.508684761506933*^9, 3.5086849462816324`*^9, 
   3.5087278176184263`*^9, 3.5087278632485065`*^9, 3.508727955943869*^9, 
   3.508728480877592*^9, {3.508781193928864*^9, 3.5087811944388647`*^9}, {
   3.5098952106136427`*^9, 3.509895211123643*^9}, {3.5121539933422194`*^9, 
   3.5121539935222197`*^9}, {3.5123125021162634`*^9, 
   3.5123125189642935`*^9}, {3.5123126114412556`*^9, 3.5123126165112643`*^9}, 
   3.5127812470286007`*^9, 3.5127842277447824`*^9, {3.51314625317665*^9, 
   3.5131462735166783`*^9}, 3.5148397803378572`*^9, {3.5151881864835434`*^9, 
   3.515188187033544*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, {3.4979866726025763`*^9, 
   3.497986673616578*^9}, {3.5006614307985444`*^9, 3.5006614323585463`*^9}, {
   3.5038516766032543`*^9, 3.5038516777264566`*^9}}],

Cell["\<\
Note: This rule is not essential, but produces simpler results.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}, {
   3.512080133307934*^9, 3.512080168407983*^9}}],

Cell[TextData[{
 "Rule o: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.502677309791684*^9, 3.502677315931693*^9}, {
   3.502767275678668*^9, 3.502767275678668*^9}, {3.5027682258967376`*^9, 
   3.502768240248763*^9}, 3.502768355688966*^9, {3.5033578653664684`*^9, 
   3.50335786655207*^9}, {3.5033582359295187`*^9, 3.5033582359295187`*^9}, 
   3.5033587716500597`*^9, {3.5033592366772776`*^9, 3.5033592415912857`*^9}, {
   3.5034170926496334`*^9, 3.5034170932396345`*^9}, {3.50341731863995*^9, 
   3.5034173205599527`*^9}, {3.503851953644141*^9, 3.5038519544085426`*^9}, {
   3.5040546377456703`*^9, 3.504054638355671*^9}, 3.504313254494523*^9, 
   3.504371840443424*^9, 3.5049867148981676`*^9, 3.508464696045136*^9, 
   3.5087284839039974`*^9, {3.512781249178603*^9, 3.5127812500386047`*^9}, {
   3.5127842295747848`*^9, 3.5127842305047865`*^9}, 3.5131462592966585`*^9, 
   3.514839783077861*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox["B", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "a"}], " ", "B"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"A", " ", "b"}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", "b"}], ")"}], " ", "B"}]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
        RowBox[{"3", "/", "2"}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497986264165859*^9, 3.4979862650706606`*^9}, {
   3.50065955661592*^9, 3.500659559295924*^9}, {3.5006614622785883`*^9, 
   3.5006614724286027`*^9}, {3.5012664315897408`*^9, 
   3.5012664362597475`*^9}, {3.503851593345908*^9, 3.5038516176195507`*^9}, {
   3.503851659318424*^9, 3.503851669396042*^9}, {3.508781194908866*^9, 
   3.5087811962788677`*^9}, {3.509895211843644*^9, 3.509895213973647*^9}, {
   3.5123125265147066`*^9, 3.512312577058795*^9}, 3.512312632501292*^9, {
   3.513053706363409*^9, 3.5130537114934163`*^9}, {3.5131462787366858`*^9, 
   3.5131463766568227`*^9}, {3.5151881879435453`*^9, 3.515188190773549*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_", "+", 
        RowBox[{"B_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"3", "/", "2"}], ")"}]}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"B", "/", "b"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "a"}], "*", "B"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "*", "b"}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"a", "+", "b"}], ")"}], "*", "B"}]}], ")"}], "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, {3.497986265944262*^9, 3.497986266927064*^9}, 
   3.4979863675440407`*^9, {3.4979898830226145`*^9, 3.497989898497842*^9}, 
   3.498679361436646*^9, {3.5006592743055253`*^9, 3.5006592786455317`*^9}, {
   3.5006615196186686`*^9, 3.5006615252886767`*^9}, {3.5006616594288645`*^9, 
   3.5006616867589025`*^9}, {3.5012664627097845`*^9, 3.501266465839789*^9}, {
   3.501266520899866*^9, 3.501266533939884*^9}, 3.501266611849993*^9, {
   3.5038519476069307`*^9, 3.503851965609362*^9}, {3.5038519998670225`*^9, 
   3.5038520230642633`*^9}, {3.50385206705634*^9, 3.5038520751995544`*^9}, {
   3.5087811965088673`*^9, 3.5087811979688697`*^9}, {3.509895214393648*^9, 
   3.5098952161736507`*^9}, {3.512312668646556*^9, 3.512312694433401*^9}, {
   3.5123128029783916`*^9, 3.5123128244596295`*^9}, {3.512435249318099*^9, 
   3.5124352534781046`*^9}, {3.512586742884052*^9, 3.512586748612379*^9}, {
   3.512586833401229*^9, 3.512586836963433*^9}, {3.512590374969795*^9, 
   3.5125903778759613`*^9}, {3.5130537174834247`*^9, 3.513053741413458*^9}, {
   3.513053815453562*^9, 3.513053823363573*^9}, {3.5130540402638764`*^9, 
   3.513054043593881*^9}, {3.5131464215368853`*^9, 3.5131464486269236`*^9}, {
   3.513146488556979*^9, 3.51314648922698*^9}, {3.513146524227029*^9, 
   3.5131465353370447`*^9}, {3.5131465813671093`*^9, 3.5131466156371574`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["p",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.510523778505186*^9, {3.510523957585437*^9, 
   3.5105239613954425`*^9}, {3.5105240766056037`*^9, 3.510524076785604*^9}, 
   3.5105251963671713`*^9, {3.5107875049756804`*^9, 3.510787506515682*^9}, {
   3.510789330398236*^9, 3.5107893325682387`*^9}, {3.5144732893239093`*^9, 
   3.5144732896047096`*^9}, 3.5144733582916307`*^9, 3.5144734005053043`*^9, 
   3.5144793880362206`*^9, 3.514480165463586*^9, 3.514569379042387*^9, {
   3.5148403704986835`*^9, 3.514840376608692*^9}, 3.5148559381819572`*^9, {
   3.5151881953735557`*^9, 3.5151881959835567`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5144736871714077`*^9, 3.5144736908686147`*^9}}],

Cell[TextData[{
 "Rule p1: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.503812941222491*^9, {
   3.5040286741277885`*^9, 3.50402867512619*^9}, 3.504031838526546*^9, 
   3.504311148611575*^9, {3.504764105847949*^9, 3.5047641154079623`*^9}, {
   3.5047641477280073`*^9, 3.504764147948008*^9}, 3.505005742172364*^9, {
   3.5080368114491596`*^9, 3.5080368579840417`*^9}, 3.5080374691155157`*^9, {
   3.5105233710346155`*^9, 3.510523371184616*^9}, {3.5105252878872995`*^9, 
   3.510525294107308*^9}, {3.51052584282408*^9, 3.51052584282408*^9}, {
   3.510788027396412*^9, 3.510788030076415*^9}, {3.5107882657767453`*^9, 
   3.5107883208568225`*^9}, {3.510789664430705*^9, 3.5107896743807187`*^9}, 
   3.510790463911824*^9, {3.510790613852034*^9, 3.5107906179920397`*^9}, {
   3.510813336637003*^9, 3.510813336637003*^9}, {3.5108459293657985`*^9, 
   3.5108459592866507`*^9}, {3.5139582932649612`*^9, 
   3.5139582932649612`*^9}, {3.5144735590171833`*^9, 3.514473561965588*^9}, {
   3.5144737101346483`*^9, 3.514473715157857*^9}, {3.514473763190342*^9, 
   3.514473764578744*^9}, {3.5144794121226625`*^9, 3.5144794127622643`*^9}, {
   3.5144987648191338`*^9, 3.514498765739135*^9}, {3.5148404305187674`*^9, 
   3.514840431708769*^9}, {3.514855957947192*^9, 3.5148559581967926`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox["1", 
      SuperscriptBox["b", 
       RowBox[{"k", " ", "m"}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], 
      RowBox[{
       RowBox[{"k", " ", "m"}], "+", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038127194681015`*^9, 3.503812750902157*^9}, {3.503812801680246*^9, 
   3.503812802335447*^9}, {3.5047496671454835`*^9, 3.504749688715514*^9}, {
   3.504749718855556*^9, 3.50474975738561*^9}, {3.5047638556975985`*^9, 
   3.504763901217663*^9}, {3.508036862352049*^9, 3.5080368741144695`*^9}, {
   3.5080369099321327`*^9, 3.5080369437529917`*^9}, {3.5080372899175997`*^9, 
   3.5080373156732454`*^9}, {3.5105229603279085`*^9, 3.510522986598355*^9}, {
   3.51052302367962*^9, 3.5105231196509886`*^9}, {3.510523163455866*^9, 
   3.5105231707566786`*^9}, {3.510524911966773*^9, 3.510524925296792*^9}, {
   3.510525184087154*^9, 3.510525188787161*^9}, {3.510787470405632*^9, 
   3.5107874992156725`*^9}, {3.510788066946467*^9, 3.5107880746864777`*^9}, {
   3.510788210246668*^9, 3.510788212636671*^9}, {3.510788384636912*^9, 
   3.5107883946369257`*^9}, {3.5107885351071224`*^9, 
   3.5107885379071264`*^9}, {3.5107893359082437`*^9, 3.5107893412382507`*^9}, 
   3.5107893780883026`*^9, 3.510845655897318*^9, {3.5144732957199206`*^9, 
   3.514473295938321*^9}, {3.5144733271383758`*^9, 3.514473389632086*^9}, {
   3.5144734208321404`*^9, 3.514473425184548*^9}, {3.514473474153034*^9, 
   3.514473504229887*^9}, {3.514479396491435*^9, 3.514479399720641*^9}, 
   3.514480142703146*^9, 3.514480175728404*^9, {3.515188197123558*^9, 
   3.5151881988235607`*^9}, 3.515350290587926*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"b", "^", 
       RowBox[{"(", 
        RowBox[{"k", "*", "m"}], ")"}]}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"k", "*", "m"}], "+", "n"}], ")"}]}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812879274782*^9, 3.503812944763697*^9, {3.5047499105558243`*^9, 
   3.5047499251058445`*^9}, 3.504749962655897*^9, 3.50475000012595*^9, {
   3.5047639369577127`*^9, 3.5047639996578007`*^9}, {3.508012492437707*^9, 
   3.5080125039037275`*^9}, {3.50803744317267*^9, 3.5080375004559703`*^9}, {
   3.5080380525409403`*^9, 3.508038060340954*^9}, {3.510523241955203*^9, 
   3.5105233462245812`*^9}, {3.5105249344968047`*^9, 
   3.5105249997668962`*^9}, {3.510525218367202*^9, 3.510525225307212*^9}, 
   3.5105258453340836`*^9, 3.5105261705445385`*^9, 3.5105287370781317`*^9, {
   3.510787941316291*^9, 3.5107879840363507`*^9}, {3.510788306106802*^9, 
   3.5107883445268555`*^9}, {3.510788495777067*^9, 3.510788532967119*^9}, {
   3.5107885649971647`*^9, 3.5107885715471735`*^9}, {3.5107893516982656`*^9, 
   3.510789366068286*^9}, {3.5107896328306603`*^9, 3.5107896399606705`*^9}, {
   3.5107898766310015`*^9, 3.510789877641003*^9}, {3.5107904722018356`*^9, 
   3.5107904864718556`*^9}, {3.5107906016920166`*^9, 3.5107906035620193`*^9}, 
   3.5108133336573973`*^9, {3.510813433138772*^9, 3.5108134492536*^9}, {
   3.5108135037444963`*^9, 3.510813509516506*^9}, {3.510813560575396*^9, 
   3.5108135638826017`*^9}, {3.5108452158985453`*^9, 
   3.5108453343027534`*^9}, {3.5108456732445483`*^9, 
   3.5108456896245775`*^9}, {3.510845924108589*^9, 3.510845925356591*^9}, 
   3.5139582753849363`*^9, {3.5144735757092123`*^9, 3.5144736765009894`*^9}, {
   3.514473929112233*^9, 3.5144739317798376`*^9}, {3.514474664049924*^9, 
   3.5144746883547664`*^9}, {3.514474786463339*^9, 3.514474821750601*^9}, {
   3.5144794332138996`*^9, 3.5144794708567657`*^9}, 3.5144795462828984`*^9, {
   3.514479724326011*^9, 3.514479727071616*^9}, {3.51448018457362*^9, 
   3.51448018480762*^9}, 3.514498712959061*^9, {3.5145694086124287`*^9, 
   3.5145694128324347`*^9}, 3.516821165807175*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4983206021865325`*^9, {3.498326040356801*^9, 3.498326049592017*^9}, {
   3.4983263025932617`*^9, 3.498326308365272*^9}, {3.510260940930415*^9, 
   3.51026094460042*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", "1"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "z", "]"}], "k"]}]], 
     SuperscriptBox[
      RowBox[{"(", 
       SqrtBox[
        SuperscriptBox[
         RowBox[{"f", "[", "z", "]"}], "j"]], ")"}], 
      RowBox[{"j", " ", "k"}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, 3.4980704431694036`*^9, {
   3.498320837060545*^9, 3.4983208718174057`*^9}, 3.4983264799655733`*^9, {
   3.4983265293864603`*^9, 3.4983265518504996`*^9}, {3.510260868510313*^9, 
   3.510260895210351*^9}, {3.5102609859104776`*^9, 3.5102609865504785`*^9}, {
   3.511714714700369*^9, 3.5117147350740047`*^9}, {3.5117152169432507`*^9, 
   3.5117152315916767`*^9}, {3.5117561659742937`*^9, 
   3.5117561659742937`*^9}, {3.5118185923538933`*^9, 
   3.5118186314339476`*^9}, {3.511818664503994*^9, 3.5118186916940317`*^9}, 
   3.5145721515462685`*^9}],

Cell[TextData[{
 "Rule p2: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"m", "-", 
       FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
     " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"n", "-", 
       FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
     " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.500410576940289*^9, 3.5004105779663477`*^9}, {
   3.5004106327664824`*^9, 3.500410643898119*^9}, {3.500429569940626*^9, 
   3.500429571675726*^9}, {3.502204840167862*^9, 3.502204842617066*^9}, 
   3.5023038294281306`*^9, {3.504362658868907*^9, 3.504362660078909*^9}, {
   3.50436465472136*^9, 3.5043646556213617`*^9}, {3.504839359121956*^9, 
   3.5048393791619835`*^9}, {3.504839672312394*^9, 3.5048396733523955`*^9}, 
   3.5098341584452877`*^9, {3.5101828092264166`*^9, 3.5101828193196344`*^9}, {
   3.511715292228983*^9, 3.511715334692258*^9}, {3.5117155048269134`*^9, 
   3.511715508166918*^9}, {3.5117295035766306`*^9, 3.511729505106633*^9}, {
   3.511750898236919*^9, 3.5117508991769204`*^9}, {3.5117555222533927`*^9, 
   3.5117555300634036`*^9}, {3.5118334045968*^9, 3.511833408403207*^9}, 
   3.5145720728661585`*^9, {3.5148404341087723`*^9, 3.514840435188774*^9}, {
   3.5148559613947983`*^9, 3.5148559617223988`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      RowBox[{
       SuperscriptBox["b", 
        RowBox[{"n", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        SqrtBox[
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"]], ")"}], 
       RowBox[{"j", " ", "k"}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{
       RowBox[{"j", " ", "m"}], "+", 
       RowBox[{"k", " ", "n"}]}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5098341849653344`*^9, 3.509834296848731*^9}, {3.5098343294527884`*^9, 
   3.509834364194049*^9}, 3.5098346591437674`*^9, {3.5098347856443896`*^9, 
   3.5098347898251967`*^9}, {3.5098348311028695`*^9, 
   3.5098349107098093`*^9}, {3.5098349437662673`*^9, 3.509834983374737*^9}, 
   3.5098350560552645`*^9, {3.5098351175973725`*^9, 3.509835139499811*^9}, 
   3.5098475309589915`*^9, {3.510182683146995*^9, 3.5101826880610037`*^9}, {
   3.5101828251228447`*^9, 3.5101828513152905`*^9}, {3.510182945071455*^9, 
   3.5101829454458556`*^9}, {3.511714482540761*^9, 3.5117145274688396`*^9}, {
   3.5117145862341433`*^9, 3.5117146153281946`*^9}, {3.5117147853060927`*^9, 
   3.511714803090124*^9}, {3.5117151505963345`*^9, 3.5117151632479568`*^9}, {
   3.511715744517249*^9, 3.511715747287253*^9}, {3.5118158169600077`*^9, 
   3.511815862160071*^9}, 3.511815909280137*^9, {3.5118176520325766`*^9, 
   3.5118176689026003`*^9}, 3.5118179461929884`*^9, {3.511819812927603*^9, 
   3.5118198181376104`*^9}, {3.5118198622576723`*^9, 3.511819864577675*^9}, {
   3.5145719907960434`*^9, 3.51457201659608*^9}, {3.51518820564357*^9, 
   3.515188207523573*^9}, 3.5153502475162506`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"b", "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "]"}], "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], "]"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"j", "*", "k"}], ")"}]}]}]}], ",", "\n", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "m"}], "+", 
           RowBox[{"k", "*", "n"}]}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5038761961479836`*^9, {3.504156546965613*^9, 
   3.504156548322815*^9}, {3.5042968954456654`*^9, 3.5042969168056955`*^9}, {
   3.5051010426366124`*^9, 3.505101050326623*^9}, 3.5053446414337845`*^9, {
   3.5053446931938567`*^9, 3.505344715043887*^9}, 3.50535355708521*^9, {
   3.509473076633647*^9, 3.509473117827003*^9}, 3.509473221522934*^9, {
   3.5094732830534534`*^9, 3.509473292318983*^9}, {3.5094751195374947`*^9, 
   3.5094751247597933`*^9}, 3.5098352718192434`*^9, {3.509835307137706*^9, 
   3.5098353487273784`*^9}, {3.509847535218998*^9, 3.5098475613690343`*^9}, {
   3.5101827112582445`*^9, 3.510182715657452*^9}, {3.510182781661168*^9, 
   3.5101827868091774`*^9}, {3.5101830769696865`*^9, 3.510183111738948*^9}, {
   3.5101832687064238`*^9, 3.5101832709372272`*^9}, {3.511715355721095*^9, 
   3.5117153607131033`*^9}, {3.511715428066806*^9, 3.5117154599968505`*^9}, {
   3.511715511146922*^9, 3.5117155141269264`*^9}, {3.511715565286998*^9, 
   3.5117155864270277`*^9}, {3.511715750947258*^9, 3.5117157539772625`*^9}, {
   3.5117293456064095`*^9, 3.5117294275865245`*^9}, {3.5117296689768624`*^9, 
   3.5117296728068676`*^9}, {3.5117302889377303`*^9, 3.5117303011477475`*^9}, 
   3.5117466386965055`*^9, {3.511750894036913*^9, 3.511750894676914*^9}, {
   3.5117511267572393`*^9, 3.5117511307372446`*^9}, {3.5117512119573584`*^9, 
   3.511751214027361*^9}, {3.511751883348298*^9, 3.5117518878683043`*^9}, {
   3.5117519413583794`*^9, 3.511751948148389*^9}, {3.5117521986187396`*^9, 
   3.511752203998747*^9}, {3.511755503353366*^9, 3.5117555064233704`*^9}, {
   3.5118335100217853`*^9, 3.5118335340614276`*^9}, 3.5145720383461103`*^9, {
   3.5145721800463085`*^9, 3.5145722335263834`*^9}, {3.515350230777421*^9, 
   3.515350231885023*^9}, 3.5168207044565296`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4983206021865325`*^9, {3.498326040356801*^9, 3.498326049592017*^9}, {
   3.4983263025932617`*^9, 3.498326308365272*^9}, {3.510260940930415*^9, 
   3.51026094460042*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", "1"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       SqrtBox[
        SuperscriptBox[
         RowBox[{"f", "[", "z", "]"}], "j"]], ")"}], 
      RowBox[{"j", " ", "k"}]], 
     SqrtBox[
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "z", "]"}], "k"]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, 3.4980704431694036`*^9, {
   3.498320837060545*^9, 3.4983208718174057`*^9}, 3.4983264799655733`*^9, {
   3.4983265293864603`*^9, 3.4983265518504996`*^9}, {3.510260868510313*^9, 
   3.510260895210351*^9}, {3.5102609859104776`*^9, 3.5102609865504785`*^9}, {
   3.511714714700369*^9, 3.5117147350740047`*^9}, {3.5117152169432507`*^9, 
   3.5117152315916767`*^9}, {3.5117561659742937`*^9, 
   3.5117561659742937`*^9}, {3.5118185923538933`*^9, 
   3.5118186314339476`*^9}, {3.511818664503994*^9, 3.5118186916940317`*^9}, {
   3.5118187344240923`*^9, 3.5118187409841013`*^9}, {3.514569048341924*^9, 
   3.5145690628419447`*^9}, {3.5145721153562183`*^9, 3.5145721159962187`*^9}}],

Cell[TextData[{
 "Rule p3: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"m", "-", 
       FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
     " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"n", "-", 
       FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
     " ", "\[And]", " ", 
     RowBox[{"n", "<", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.500410576940289*^9, 3.5004105779663477`*^9}, {
   3.5004106327664824`*^9, 3.500410643898119*^9}, {3.500429569940626*^9, 
   3.500429571675726*^9}, {3.502204840167862*^9, 3.502204842617066*^9}, 
   3.5023038294281306`*^9, {3.504362658868907*^9, 3.504362660078909*^9}, {
   3.50436465472136*^9, 3.5043646556213617`*^9}, {3.504839359121956*^9, 
   3.5048393791619835`*^9}, {3.504839672312394*^9, 3.5048396733523955`*^9}, 
   3.5098341584452877`*^9, {3.5101828092264166`*^9, 3.5101828193196344`*^9}, {
   3.511715292228983*^9, 3.511715334692258*^9}, {3.5117155048269134`*^9, 
   3.511715508166918*^9}, {3.511729526906664*^9, 3.5117295274366646`*^9}, {
   3.511748932814161*^9, 3.511748933464162*^9}, {3.5117557724437428`*^9, 
   3.5117557724437428`*^9}, {3.511832614206211*^9, 3.511832614206211*^9}, {
   3.511832746213642*^9, 3.511832746213642*^9}, {3.5144963686357794`*^9, 
   3.514496369905781*^9}, {3.5144964549259*^9, 3.5144964623659105`*^9}, {
   3.514496962866611*^9, 3.5144969631666117`*^9}, {3.5144973205371118`*^9, 
   3.514497323707116*^9}, {3.5144981061082115`*^9, 3.514498107108213*^9}, {
   3.51456888104169*^9, 3.51456888104169*^9}, {3.5145720563361354`*^9, 
   3.514572061146142*^9}, {3.5148404379187775`*^9, 3.514840439028779*^9}, {
   3.5148559649984045`*^9, 3.514855965263605*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      RowBox[{
       SuperscriptBox["b", 
        RowBox[{"n", "+", 
         FractionBox["1", "2"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         SqrtBox[
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"]], ")"}], 
        RowBox[{"j", " ", "k"}]]}], 
      SqrtBox[
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{
       RowBox[{"j", " ", "m"}], "+", 
       RowBox[{"k", " ", "n"}]}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5098341849653344`*^9, 3.509834296848731*^9}, {3.5098343294527884`*^9, 
   3.509834364194049*^9}, 3.5098346591437674`*^9, {3.5098347856443896`*^9, 
   3.5098347898251967`*^9}, {3.5098348311028695`*^9, 
   3.5098349107098093`*^9}, {3.5098349437662673`*^9, 3.509834983374737*^9}, 
   3.5098350560552645`*^9, {3.5098351175973725`*^9, 3.509835139499811*^9}, 
   3.5098475309589915`*^9, {3.510182683146995*^9, 3.5101826880610037`*^9}, {
   3.5101828251228447`*^9, 3.5101828513152905`*^9}, {3.510182945071455*^9, 
   3.5101829454458556`*^9}, {3.511714482540761*^9, 3.5117145274688396`*^9}, {
   3.5117145862341433`*^9, 3.5117146153281946`*^9}, {3.5117147853060927`*^9, 
   3.511714803090124*^9}, {3.5117151505963345`*^9, 3.5117151632479568`*^9}, {
   3.511715744517249*^9, 3.511715747287253*^9}, {3.51174841818344*^9, 
   3.511748420833444*^9}, {3.511748497963552*^9, 3.5117484984135523`*^9}, {
   3.511818294033475*^9, 3.5118183236735168`*^9}, {3.5144968024863863`*^9, 
   3.5144968510064545`*^9}, {3.5144968866465044`*^9, 3.514496913836542*^9}, {
   3.514568305910885*^9, 3.5145683164908996`*^9}, {3.5145683572009563`*^9, 
   3.5145683609609623`*^9}, 3.514568478731127*^9, 3.514568528181196*^9, {
   3.5145685692312536`*^9, 3.5145686286113367`*^9}, {3.5145686608513813`*^9, 
   3.5145686672213907`*^9}, {3.514569441722475*^9, 3.5145694478724833`*^9}, {
   3.5151882125235796`*^9, 3.5151882138535814`*^9}, 3.515350308980358*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"b", "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], "]"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"j", "*", "k"}], ")"}]}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "]"}]}]}], ",", 
     "\n", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "m"}], "+", 
           RowBox[{"k", "*", "n"}]}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5038761961479836`*^9, {3.504156546965613*^9, 
   3.504156548322815*^9}, {3.5042968954456654`*^9, 3.5042969168056955`*^9}, {
   3.5051010426366124`*^9, 3.505101050326623*^9}, 3.5053446414337845`*^9, {
   3.5053446931938567`*^9, 3.505344715043887*^9}, 3.50535355708521*^9, {
   3.509473076633647*^9, 3.509473117827003*^9}, 3.509473221522934*^9, {
   3.5094732830534534`*^9, 3.509473292318983*^9}, {3.5094751195374947`*^9, 
   3.5094751247597933`*^9}, 3.5098352718192434`*^9, {3.509835307137706*^9, 
   3.5098353487273784`*^9}, {3.509847535218998*^9, 3.5098475613690343`*^9}, {
   3.5101827112582445`*^9, 3.510182715657452*^9}, {3.510182781661168*^9, 
   3.5101827868091774`*^9}, {3.5101830769696865`*^9, 3.510183111738948*^9}, {
   3.5101832687064238`*^9, 3.5101832709372272`*^9}, {3.511715355721095*^9, 
   3.5117153607131033`*^9}, {3.511715428066806*^9, 3.5117154599968505`*^9}, {
   3.511715511146922*^9, 3.5117155141269264`*^9}, {3.511715565286998*^9, 
   3.5117155864270277`*^9}, {3.511715750947258*^9, 3.5117157539772625`*^9}, {
   3.511747293362056*^9, 3.5117472971996627`*^9}, {3.5117477460436506`*^9, 
   3.5117477523148623`*^9}, {3.5117479077127256`*^9, 3.511747926872752*^9}, {
   3.5117482704932337`*^9, 3.511748288643259*^9}, {3.511748542813615*^9, 
   3.511748551293627*^9}, {3.511750065125746*^9, 3.5117500670757484`*^9}, {
   3.5117558949839144`*^9, 3.511755900293922*^9}, 3.51183280157814*^9, {
   3.511832873725067*^9, 3.5118328862830887`*^9}, {3.5118329289491634`*^9, 
   3.5118329301035657`*^9}, {3.514496374415787*^9, 3.514496375635789*^9}, {
   3.514496438775877*^9, 3.514496443085883*^9}, {3.514496942236582*^9, 
   3.514496946806588*^9}, {3.514497149116872*^9, 3.5144971791969137`*^9}, 
   3.5144972624770308`*^9, {3.5144973102370973`*^9, 3.5144973301571255`*^9}, {
   3.514497805537791*^9, 3.5144978555678606`*^9}, 3.5144981017882056`*^9, {
   3.5145668229448023`*^9, 3.5145668520048428`*^9}, {3.5145683337309237`*^9, 
   3.514568353430951*^9}, 3.5145688737116795`*^9, {3.514568913051735*^9, 
   3.5145689928618464`*^9}, {3.5145694700325146`*^9, 
   3.5145694900025425`*^9}, {3.5145720407761135`*^9, 
   3.5145720443261185`*^9}, {3.515978899555855*^9, 3.515978900959857*^9}, 
   3.5168207044965296`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["q",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.510523778505186*^9, {3.510523957585437*^9, 
   3.5105239613954425`*^9}, {3.5105240766056037`*^9, 3.510524076785604*^9}, 
   3.5105251963671713`*^9, {3.5107875049756804`*^9, 3.510787506515682*^9}, {
   3.510789330398236*^9, 3.5107893325682387`*^9}, {3.510791314473015*^9, 
   3.5107913192430215`*^9}, {3.510791362583082*^9, 3.510791387393117*^9}, {
   3.510791824065729*^9, 3.5107918281657352`*^9}, {3.5107928856612177`*^9, 
   3.5107928921712275`*^9}, 3.5107929324812837`*^9, {3.5108637683616514`*^9, 
   3.5108637686516523`*^9}, {3.5108642314723*^9, 3.5108642344423037`*^9}, 
   3.5120884687116203`*^9, {3.5120885019716663`*^9, 3.512088510101678*^9}, 
   3.512089475247053*^9, {3.5148403685886807`*^9, 3.514840373258687*^9}, 
   3.514855941239563*^9, {3.515188236483613*^9, 3.5151882390636168`*^9}, 
   3.515188328043741*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992213471847477`*^9, 3.499221352834756*^9}, {
   3.507168628069942*^9, 3.5071686300799446`*^9}}],

Cell[TextData[{
 "Rule q1: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "m", "\[LessEqual]", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.5059675026278906`*^9, 
   3.50596750349494*^9}, 3.5060116665952845`*^9, 3.506016542053919*^9, 
   3.506017498790203*^9, 3.506197187541685*^9, {3.5107904345917826`*^9, 
   3.510790434771783*^9}, {3.51079227461636*^9, 3.51079227461636*^9}, 
   3.510792933471285*^9, {3.5119745211854286`*^9, 3.5119745333741255`*^9}, {
   3.5119746039351616`*^9, 3.5119746039351616`*^9}, {3.511974690921137*^9, 
   3.5119746917231827`*^9}, {3.513143844075271*^9, 3.513143845275273*^9}, {
   3.5136220574575806`*^9, 3.5136220574575806`*^9}, {3.514840401878727*^9, 
   3.5148404034887295`*^9}, {3.514855974764022*^9, 3.514855974998022*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
         RowBox[{"(", 
          RowBox[{"B", "+", 
           RowBox[{"A", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.498761170922196*^9, 3.498761170922196*^9}, {
   3.4987623460938416`*^9, 3.498762351773849*^9}, {3.498771763207025*^9, 
   3.498771766317029*^9}, {3.499176679905081*^9, 3.4991767019167194`*^9}, {
   3.4991769134450912`*^9, 3.4991769208239045`*^9}, {3.499177089507001*^9, 
   3.4991770988514175`*^9}, {3.4991771440134964`*^9, 3.49917724823728*^9}, {
   3.49917733957544*^9, 3.499177343725047*^9}, {3.499177507728135*^9, 
   3.4991775227821617`*^9}, {3.4991958536064606`*^9, 
   3.4991958550572634`*^9}, {3.4991964253402653`*^9, 3.499196426213866*^9}, {
   3.499220611573718*^9, 3.499220621053732*^9}, {3.499220791953971*^9, 
   3.4992208047139883`*^9}, {3.499220842934042*^9, 3.499220858054063*^9}, {
   3.49922124888461*^9, 3.4992212502446127`*^9}, {3.506011634305239*^9, 
   3.506011658545273*^9}, {3.506016286753561*^9, 3.506016298583578*^9}, {
   3.506017364036765*^9, 3.506017388996809*^9}, {3.507168650069973*^9, 
   3.507168654459979*^9}, {3.5107903473316607`*^9, 3.5107903569216743`*^9}, 
   3.510791815495717*^9, {3.510791877225804*^9, 3.5107918796458073`*^9}, {
   3.5107919206958647`*^9, 3.5107919361058865`*^9}, {3.5107929340912857`*^9, 
   3.51079296574133*^9}, {3.510793049051447*^9, 3.510793057921459*^9}, {
   3.510793103201523*^9, 3.5107931037715235`*^9}, {3.510793310961814*^9, 
   3.510793315101819*^9}, {3.513140986673114*^9, 3.5131410148311634`*^9}, {
   3.513141072754065*^9, 3.513141076295271*^9}, {3.5151882458836265`*^9, 
   3.5151882486636305`*^9}, {3.5151883286837425`*^9, 3.5151883321137466`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_.", "+", 
        RowBox[{"B_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
      "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B", "+", 
         RowBox[{"A", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"a", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}]}], ",", "x"}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "m", "\[LessEqual]", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510799189346859*^9, 3.5107992041968803`*^9}, {3.510799776677682*^9, 
   3.510799780597687*^9}, {3.511974364864487*^9, 3.511974387232767*^9}, {
   3.511974460323947*^9, 3.5119744739837284`*^9}, 3.5119745976478014`*^9, {
   3.5119746946573505`*^9, 3.5119746955714025`*^9}, {3.5131411024253173`*^9, 
   3.513141122783353*^9}, 3.5131413102020817`*^9, {3.5131438377952623`*^9, 
   3.5131438400152655`*^9}, 3.513144642074394*^9, 3.5136220842896276`*^9, 
   3.51682101171696*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{"a", " ", 
        RowBox[{"f", "[", "z", "]"}]}]}]], 
     RowBox[{
      SqrtBox[
       RowBox[{"f", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", "/", 
         RowBox[{"f", "[", "z", "]"}]}]}]]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}, {
   3.5072605288062344`*^9, 3.5072605314582396`*^9}, {3.5075717121274023`*^9, 
   3.507571727117423*^9}, {3.50758176808795*^9, 3.5075817732679577`*^9}, {
   3.507583363755458*^9, 3.5075833689814672`*^9}, {3.510507619932962*^9, 
   3.51050763590739*^9}, {3.514253208507701*^9, 3.5142532278877277`*^9}}],

Cell[TextData[{
 "Rule q2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"n", "-", 
     FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "=", 
       RowBox[{"1", " ", "\[And]", " ", 
        RowBox[{
         RowBox[{"-", "1"}], "<", "n", "<", "1"}]}]}], ")"}], " ", "\[Or]", 
     " ", 
     RowBox[{"(", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"-", "1"}], " ", "\[And]", " ", 
        RowBox[{
         RowBox[{"-", "2"}], "<", "n", "<", "0"}]}]}], ")"}]}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.5059675026278906`*^9, 
   3.50596750349494*^9}, 3.5060116665952845`*^9, 3.506016542053919*^9, 
   3.506017498790203*^9, 3.506197187541685*^9, {3.5107904345917826`*^9, 
   3.510790434771783*^9}, {3.51079227461636*^9, 3.51079227461636*^9}, 
   3.510792933471285*^9, {3.5108662797751675`*^9, 3.5108662797751675`*^9}, {
   3.5108678950974293`*^9, 3.5108678976974325`*^9}, {3.510867944407498*^9, 
   3.5108679451674995`*^9}, {3.510868054967653*^9, 3.5108680555976534`*^9}, {
   3.5108681105177307`*^9, 3.5108681231277485`*^9}, 3.5108828042789707`*^9, {
   3.5136220690172005`*^9, 3.5136220690172005`*^9}, {3.514225012031127*^9, 
   3.514225013247929*^9}, {3.5142251131193047`*^9, 3.514225145832562*^9}, {
   3.514253124187583*^9, 3.5142531260175858`*^9}, {3.514253411007984*^9, 
   3.514253411007984*^9}, {3.5142589230657015`*^9, 3.5142589695357666`*^9}, {
   3.5148402862385654`*^9, 3.51484028939857*^9}, {3.5148403257586207`*^9, 
   3.514840326668622*^9}, {3.5148404068387346`*^9, 3.514840408088736*^9}, {
   3.5148559786172285`*^9, 3.514855978976029*^9}, {3.5168243286539*^9, 
   3.5168243286539*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      RowBox[{" ", 
       SqrtBox[
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"m", "-", "n", "-", "1"}]], 
     RowBox[{"(", 
      RowBox[{"B", "+", 
       RowBox[{"A", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.498761170922196*^9, 3.498761170922196*^9}, {
   3.4987623460938416`*^9, 3.498762351773849*^9}, {3.498771763207025*^9, 
   3.498771766317029*^9}, {3.499176679905081*^9, 3.4991767019167194`*^9}, {
   3.4991769134450912`*^9, 3.4991769208239045`*^9}, {3.499177089507001*^9, 
   3.4991770988514175`*^9}, {3.4991771440134964`*^9, 3.49917724823728*^9}, {
   3.49917733957544*^9, 3.499177343725047*^9}, {3.499177507728135*^9, 
   3.4991775227821617`*^9}, {3.4991958536064606`*^9, 
   3.4991958550572634`*^9}, {3.4991964253402653`*^9, 3.499196426213866*^9}, {
   3.499220611573718*^9, 3.499220621053732*^9}, {3.499220791953971*^9, 
   3.4992208047139883`*^9}, {3.499220842934042*^9, 3.499220858054063*^9}, {
   3.49922124888461*^9, 3.4992212502446127`*^9}, {3.506011634305239*^9, 
   3.506011658545273*^9}, {3.506016286753561*^9, 3.506016298583578*^9}, {
   3.506017364036765*^9, 3.506017388996809*^9}, {3.507168650069973*^9, 
   3.507168654459979*^9}, {3.5107903473316607`*^9, 3.5107903569216743`*^9}, 
   3.510791815495717*^9, {3.510791877225804*^9, 3.5107918796458073`*^9}, {
   3.5107919206958647`*^9, 3.5107919361058865`*^9}, {3.5107929340912857`*^9, 
   3.51079296574133*^9}, {3.510793049051447*^9, 3.510793057921459*^9}, {
   3.510793103201523*^9, 3.5107931037715235`*^9}, {3.510793310961814*^9, 
   3.510793315101819*^9}, 3.5108624550198126`*^9, 3.5108626131100345`*^9, {
   3.510862732070201*^9, 3.5108627625502434`*^9}, {3.510862855050373*^9, 
   3.510862862860384*^9}, {3.510863006510585*^9, 3.5108630253906116`*^9}, {
   3.5108654917540646`*^9, 3.510865494574068*^9}, {3.510865542214135*^9, 
   3.510865562964164*^9}, {3.510866059424859*^9, 3.5108660839748936`*^9}, {
   3.5108672905565825`*^9, 3.510867342806656*^9}, {3.510867537366928*^9, 
   3.51086753861693*^9}, {3.5108677323472013`*^9, 3.5108678210373254`*^9}, 
   3.5108827919789534`*^9, {3.5108834101002717`*^9, 3.5108834689123745`*^9}, {
   3.510883571264155*^9, 3.5108835715449553`*^9}, {3.5108836880459595`*^9, 
   3.510883710182399*^9}, {3.510883778604119*^9, 3.5108838678674755`*^9}, {
   3.5108845596722918`*^9, 3.510884601277564*^9}, {3.5142247663462954`*^9, 
   3.5142248021639585`*^9}, 3.514253025067444*^9, {3.5142530595274925`*^9, 
   3.5142531105975637`*^9}, {3.514253635268298*^9, 3.5142536532983236`*^9}, {
   3.5142587274654274`*^9, 3.5142587761854954`*^9}, {3.5151882542136383`*^9, 
   3.5151882561836405`*^9}, {3.5151883380837555`*^9, 3.515188345163765*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "-", "n", "-", "1"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"B", "+", 
          RowBox[{"A", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"a", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", "\n", "  ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"m", "\[Equal]", "1"}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"-", "1"}], "<", "n", "<", "1"}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{"m", "\[Equal]", 
        RowBox[{"-", "1"}]}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"-", "2"}], "<", "n", "<", "0"}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510799189346859*^9, 3.5107992041968803`*^9}, {3.510799776677682*^9, 
   3.510799780597687*^9}, 3.510863075290681*^9, {3.5108631067007256`*^9, 
   3.510863112650734*^9}, 3.5108634203511643`*^9, {3.510863486311257*^9, 
   3.510863486521257*^9}, {3.510865446524001*^9, 3.5108654554340134`*^9}, 
   3.5108661348649645`*^9, {3.5108661791050267`*^9, 3.5108661865550375`*^9}, {
   3.510866302065199*^9, 3.5108663079952073`*^9}, {3.510867921877466*^9, 
   3.510867937547488*^9}, {3.510867973887539*^9, 3.510868046637641*^9}, 
   3.5108680905877028`*^9, {3.510868148657784*^9, 3.510868177777825*^9}, {
   3.510882816248987*^9, 3.510882824228998*^9}, {3.5108840906514673`*^9, 
   3.5108841599155884`*^9}, {3.5108845736187162`*^9, 
   3.5108846146467876`*^9}, {3.510888427388686*^9, 3.5108884743291683`*^9}, {
   3.5108886381918564`*^9, 3.5108886485658746`*^9}, {3.510888678720728*^9, 
   3.5108886796255293`*^9}, {3.510888720684801*^9, 3.5108887275800133`*^9}, {
   3.5108888796802807`*^9, 3.510888881021883*^9}, {3.5120885974018*^9, 
   3.5120886011318054`*^9}, {3.5120894445570097`*^9, 3.512089448317015*^9}, {
   3.513109116247131*^9, 3.513109181236845*^9}, {3.5131109783852024`*^9, 
   3.5131109820668087`*^9}, {3.513111738496537*^9, 3.5131117413357425`*^9}, 
   3.513112310803943*^9, 3.513116549990039*^9, 3.513116631840153*^9, {
   3.513116674560213*^9, 3.5131166806702213`*^9}, {3.513116760960334*^9, 
   3.5131167691403456`*^9}, 3.513122838946004*^9, {3.5131355540184326`*^9, 
   3.513135558760841*^9}, {3.5131356301777663`*^9, 3.513135650832203*^9}, 
   3.5131372241913633`*^9, {3.513139910664424*^9, 3.513139925016449*^9}, {
   3.5131399628933153`*^9, 3.5131399657793207`*^9}, {3.513622089406437*^9, 
   3.5136221199356904`*^9}, 3.5142223995725384`*^9, {3.5142249275881786`*^9, 
   3.5142249458246107`*^9}, 3.514225230603111*^9, {3.5142290392362003`*^9, 
   3.5142290573946323`*^9}, {3.51425341509799*^9, 3.51425343628802*^9}, {
   3.5142534667580624`*^9, 3.5142535593981924`*^9}, {3.514253687058371*^9, 
   3.514253702868393*^9}, {3.5142590240058427`*^9, 3.514259054505885*^9}, {
   3.51425924370615*^9, 3.5142592745661936`*^9}, {3.514840257318525*^9, 
   3.514840268948541*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", "1"}]]],
 ", then  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{"a", " ", 
        RowBox[{"f", "[", "z", "]"}]}]}]], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SqrtBox[
         SuperscriptBox[
          RowBox[{"f", "[", "z", "]"}], "j"]], ")"}], "j"], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"f", "[", "z", "]"}], 
          RowBox[{"-", "1"}]]}]}]]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.508354923854859*^9, 
   3.508354923854859*^9}, {3.508361590872611*^9, 3.5083615983626213`*^9}, {
   3.508361640892681*^9, 3.508361643482684*^9}, 3.5108633469910617`*^9, {
   3.5108842882102137`*^9, 3.510884343449911*^9}, {3.5108843749619665`*^9, 
   3.510884406786022*^9}}],

Cell[TextData[{
 "Rule q3: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"0", "\[LessEqual]", 
     RowBox[{
      RowBox[{"j", " ", "m"}], "-", "n"}], "\[LessEqual]", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.5059675026278906`*^9, 
   3.50596750349494*^9}, 3.5060116665952845`*^9, 3.506016542053919*^9, 
   3.506017498790203*^9, 3.506197187541685*^9, {3.5107904345917826`*^9, 
   3.510790434771783*^9}, {3.51079227461636*^9, 3.51079227461636*^9}, 
   3.510792933471285*^9, {3.5108662797751675`*^9, 3.5108662797751675`*^9}, {
   3.5108678950974293`*^9, 3.5108678976974325`*^9}, {3.510867944407498*^9, 
   3.5108679451674995`*^9}, {3.510868054967653*^9, 3.5108680555976534`*^9}, {
   3.5108681105177307`*^9, 3.5108681231277485`*^9}, 3.5108828042789707`*^9, {
   3.5136220690172005`*^9, 3.5136220690172005`*^9}, {3.514225012031127*^9, 
   3.514225013247929*^9}, {3.5142251131193047`*^9, 3.514225145832562*^9}, {
   3.514253810168543*^9, 3.514253840658586*^9}, {3.514395770421965*^9, 
   3.51439577397197*^9}, {3.5143967942433987`*^9, 3.514396846703472*^9}, {
   3.514396893313537*^9, 3.514396975353652*^9}, {3.5143980891823254`*^9, 
   3.5143981015520325`*^9}, {3.5143981687648773`*^9, 
   3.5143981710610085`*^9}, {3.5148404114187407`*^9, 3.514840412348742*^9}, {
   3.5148559828604355`*^9, 3.5148559832348366`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      RowBox[{" ", 
       SqrtBox[
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      RowBox[{
       SuperscriptBox[
        SqrtBox[
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"]], "j"], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{
       RowBox[{"j", " ", "m"}], "-", "n", "-", "1"}]], 
     RowBox[{"(", 
      RowBox[{"B", "+", 
       RowBox[{"A", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.498761170922196*^9, 3.498761170922196*^9}, {
   3.4987623460938416`*^9, 3.498762351773849*^9}, {3.498771763207025*^9, 
   3.498771766317029*^9}, {3.499176679905081*^9, 3.4991767019167194`*^9}, {
   3.4991769134450912`*^9, 3.4991769208239045`*^9}, {3.499177089507001*^9, 
   3.4991770988514175`*^9}, {3.4991771440134964`*^9, 3.49917724823728*^9}, {
   3.49917733957544*^9, 3.499177343725047*^9}, {3.499177507728135*^9, 
   3.4991775227821617`*^9}, {3.4991958536064606`*^9, 
   3.4991958550572634`*^9}, {3.4991964253402653`*^9, 3.499196426213866*^9}, {
   3.499220611573718*^9, 3.499220621053732*^9}, {3.499220791953971*^9, 
   3.4992208047139883`*^9}, {3.499220842934042*^9, 3.499220858054063*^9}, {
   3.49922124888461*^9, 3.4992212502446127`*^9}, {3.506011634305239*^9, 
   3.506011658545273*^9}, {3.506016286753561*^9, 3.506016298583578*^9}, {
   3.506017364036765*^9, 3.506017388996809*^9}, {3.507168650069973*^9, 
   3.507168654459979*^9}, {3.5107903473316607`*^9, 3.5107903569216743`*^9}, 
   3.510791815495717*^9, {3.510791877225804*^9, 3.5107918796458073`*^9}, {
   3.5107919206958647`*^9, 3.5107919361058865`*^9}, {3.5107929340912857`*^9, 
   3.51079296574133*^9}, {3.510793049051447*^9, 3.510793057921459*^9}, {
   3.510793103201523*^9, 3.5107931037715235`*^9}, {3.510793310961814*^9, 
   3.510793315101819*^9}, 3.5108624550198126`*^9, 3.5108626131100345`*^9, {
   3.510862732070201*^9, 3.5108627625502434`*^9}, {3.510862855050373*^9, 
   3.510862862860384*^9}, {3.510863006510585*^9, 3.5108630253906116`*^9}, {
   3.5108654917540646`*^9, 3.510865494574068*^9}, {3.510865542214135*^9, 
   3.510865562964164*^9}, {3.510866059424859*^9, 3.5108660839748936`*^9}, {
   3.5108672905565825`*^9, 3.510867342806656*^9}, {3.510867537366928*^9, 
   3.51086753861693*^9}, {3.5108677323472013`*^9, 3.5108678210373254`*^9}, 
   3.5108827919789534`*^9, {3.5108834101002717`*^9, 3.5108834689123745`*^9}, {
   3.510883571264155*^9, 3.5108835715449553`*^9}, {3.5108836880459595`*^9, 
   3.510883710182399*^9}, {3.510883778604119*^9, 3.5108838678674755`*^9}, {
   3.5108845596722918`*^9, 3.510884601277564*^9}, {3.5142247663462954`*^9, 
   3.5142248021639585`*^9}, {3.514253761668475*^9, 3.514253785538509*^9}, {
   3.514253853498604*^9, 3.514253870598628*^9}, {3.5142539471187353`*^9, 
   3.5142540442288713`*^9}, {3.514256942172928*^9, 3.5142569660829616`*^9}, {
   3.5143958129420247`*^9, 3.514395822802038*^9}, {3.5143963480027733`*^9, 
   3.514396363392795*^9}, 3.514396471892947*^9, {3.5143965757730923`*^9, 
   3.5143965997731256`*^9}, {3.5143966406231833`*^9, 3.514396655623204*^9}, {
   3.5143971490038953`*^9, 3.5143971789939375`*^9}, {3.51518826310365*^9, 
   3.5151882653336535`*^9}, {3.5151883516737747`*^9, 3.515188355023779*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], "]"}], ")"}], "^",
          "j"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "m"}], "-", "n", "-", "1"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"B", "+", 
          RowBox[{"A", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"a", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "n", "<", "1"}], " ", "&&", " ", 
    RowBox[{"0", "\[LessEqual]", 
     RowBox[{
      RowBox[{"j", "*", "m"}], "-", "n"}], "\[LessEqual]", 
     "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510799189346859*^9, 3.5107992041968803`*^9}, {3.510799776677682*^9, 
   3.510799780597687*^9}, 3.510863075290681*^9, {3.5108631067007256`*^9, 
   3.510863112650734*^9}, 3.5108634203511643`*^9, {3.510863486311257*^9, 
   3.510863486521257*^9}, {3.510865446524001*^9, 3.5108654554340134`*^9}, 
   3.5108661348649645`*^9, {3.5108661791050267`*^9, 3.5108661865550375`*^9}, {
   3.510866302065199*^9, 3.5108663079952073`*^9}, {3.510867921877466*^9, 
   3.510867937547488*^9}, {3.510867973887539*^9, 3.510868046637641*^9}, 
   3.5108680905877028`*^9, {3.510868148657784*^9, 3.510868177777825*^9}, {
   3.510882816248987*^9, 3.510882824228998*^9}, {3.5108840906514673`*^9, 
   3.5108841599155884`*^9}, {3.5108845736187162`*^9, 
   3.5108846146467876`*^9}, {3.510888427388686*^9, 3.5108884743291683`*^9}, {
   3.5108886381918564`*^9, 3.5108886485658746`*^9}, {3.510888678720728*^9, 
   3.5108886796255293`*^9}, {3.510888720684801*^9, 3.5108887275800133`*^9}, {
   3.5108888796802807`*^9, 3.510888881021883*^9}, {3.5120885974018*^9, 
   3.5120886011318054`*^9}, {3.5120894445570097`*^9, 3.512089448317015*^9}, {
   3.513109116247131*^9, 3.513109181236845*^9}, {3.5131109783852024`*^9, 
   3.5131109820668087`*^9}, {3.513111738496537*^9, 3.5131117413357425`*^9}, 
   3.513112310803943*^9, 3.513116549990039*^9, 3.513116631840153*^9, {
   3.513116674560213*^9, 3.5131166806702213`*^9}, {3.513116760960334*^9, 
   3.5131167691403456`*^9}, 3.513122838946004*^9, {3.5131355540184326`*^9, 
   3.513135558760841*^9}, {3.5131356301777663`*^9, 3.513135650832203*^9}, 
   3.5131372241913633`*^9, {3.513139910664424*^9, 3.513139925016449*^9}, {
   3.5131399628933153`*^9, 3.5131399657793207`*^9}, {3.513622089406437*^9, 
   3.5136221199356904`*^9}, 3.5142223995725384`*^9, {3.5142249275881786`*^9, 
   3.5142249458246107`*^9}, 3.514225230603111*^9, {3.5142290392362003`*^9, 
   3.5142290573946323`*^9}, 3.5142538004285297`*^9, {3.5142542521991625`*^9, 
   3.5142542532391634`*^9}, {3.514254291249217*^9, 3.5142544290794096`*^9}, {
   3.5142583832749453`*^9, 3.5142584292150097`*^9}, {3.5143958450020695`*^9, 
   3.5143958674421005`*^9}, {3.5143960423023453`*^9, 3.514396074522391*^9}, {
   3.514396122022457*^9, 3.5143961313624706`*^9}, {3.5143961632325153`*^9, 
   3.5143961760225325`*^9}, {3.5143967449833293`*^9, 3.514396779623378*^9}, {
   3.514396986183667*^9, 3.5143970626537743`*^9}, {3.5143972878540897`*^9, 
   3.514397354094182*^9}, {3.514397455514324*^9, 3.514397455794325*^9}, {
   3.514398071185296*^9, 3.5143980807958455`*^9}, {3.5143981737481623`*^9, 
   3.5143981755572653`*^9}, 3.5143987534533195`*^9, {3.514399109566688*^9, 
   3.5143991160820603`*^9}, 3.5144008955518403`*^9, 3.5144014047609653`*^9, {
   3.5153503675740614`*^9, 3.515350419896553*^9}, 3.5168210117869596`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["r",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.510523778505186*^9, {3.510523957585437*^9, 
   3.5105239613954425`*^9}, {3.5105240766056037`*^9, 3.510524076785604*^9}, 
   3.5105251963671713`*^9, {3.5107875049756804`*^9, 3.510787506515682*^9}, {
   3.5131368180423946`*^9, 3.5131368216623993`*^9}, {3.5148403695286818`*^9, 
   3.5148403749886894`*^9}, 3.514855944671569*^9, {3.5151882725636635`*^9, 
   3.5151882946936946`*^9}, {3.5151883599437857`*^9, 3.5151883602337866`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"f", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"1", "/", 
        RowBox[{"f", "[", "z", "]"}]}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}, {
   3.5072605288062344`*^9, 3.5072605314582396`*^9}, {3.5075717121274023`*^9, 
   3.507571727117423*^9}, {3.50758176808795*^9, 3.5075817732679577`*^9}, {
   3.507583363755458*^9, 3.5075833689814672`*^9}, {3.510507619932962*^9, 
   3.51050763590739*^9}, {3.5106050833413134`*^9, 3.510605087834121*^9}, 
   3.51060524079239*^9, {3.5148562497457047`*^9, 3.5148562594021215`*^9}}],

Cell[TextData[{
 "Rule r: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "-", 
     FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{
    RowBox[{"-", "1"}], "<", "m", "<", "2"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"-", "2"}], "<", "n", "<", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.503812941222491*^9, {
   3.5040286741277885`*^9, 3.50402867512619*^9}, 3.504031838526546*^9, 
   3.504311148611575*^9, {3.504764105847949*^9, 3.5047641154079623`*^9}, {
   3.5047641477280073`*^9, 3.504764147948008*^9}, 3.505005742172364*^9, {
   3.5080368114491596`*^9, 3.5080368579840417`*^9}, 3.5080374691155157`*^9, {
   3.5105233710346155`*^9, 3.510523371184616*^9}, {3.5105252878872995`*^9, 
   3.510525294107308*^9}, {3.51052584282408*^9, 3.51052584282408*^9}, {
   3.510788027396412*^9, 3.510788030076415*^9}, {3.5107882657767453`*^9, 
   3.5107883208568225`*^9}, {3.510792844771161*^9, 3.510792845691162*^9}, {
   3.5108461760802317`*^9, 3.5108461760802317`*^9}, {3.5108903476956596`*^9, 
   3.5108903493804626`*^9}, {3.5108909214646673`*^9, 
   3.5108909214646673`*^9}, {3.510892028567412*^9, 3.510892028567412*^9}, {
   3.51089279603236*^9, 3.5108928074983807`*^9}, {3.510892865156082*^9, 
   3.5108928661232834`*^9}, {3.512087493350254*^9, 3.512087496360259*^9}, {
   3.512095982322836*^9, 3.512095988547247*^9}, {3.5121644657493515`*^9, 
   3.5121644675893545`*^9}, {3.512164815949842*^9, 3.512164887379942*^9}, {
   3.512594661448968*^9, 3.512594661448968*^9}, {3.5131369032225137`*^9, 
   3.513136904992516*^9}, {3.5148404215087547`*^9, 3.514840422418756*^9}, 
   3.514855993374854*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038127194681015`*^9, 3.503812750902157*^9}, {3.503812801680246*^9, 
   3.503812802335447*^9}, {3.5047496671454835`*^9, 3.504749688715514*^9}, {
   3.504749718855556*^9, 3.50474975738561*^9}, {3.5047638556975985`*^9, 
   3.504763901217663*^9}, {3.508036862352049*^9, 3.5080368741144695`*^9}, {
   3.5080369099321327`*^9, 3.5080369437529917`*^9}, {3.5080372899175997`*^9, 
   3.5080373156732454`*^9}, {3.5105229603279085`*^9, 3.510522986598355*^9}, {
   3.51052302367962*^9, 3.5105231196509886`*^9}, {3.510523163455866*^9, 
   3.5105231707566786`*^9}, {3.510524911966773*^9, 3.510524925296792*^9}, {
   3.510525184087154*^9, 3.510525188787161*^9}, {3.510787470405632*^9, 
   3.5107874992156725`*^9}, {3.510788066946467*^9, 3.5107880746864777`*^9}, {
   3.510788210246668*^9, 3.510788212636671*^9}, {3.510788384636912*^9, 
   3.5107883946369257`*^9}, {3.5107885351071224`*^9, 3.5107885379071264`*^9}, 
   3.5108463483825345`*^9, {3.5108927756275244`*^9, 3.510892785564742*^9}, {
   3.512087377820093*^9, 3.51208741880015*^9}, {3.5131356944342794`*^9, 
   3.513135714308714*^9}, {3.515188275553668*^9, 3.5151883024937057`*^9}, {
   3.5151883616037884`*^9, 3.5151883640337915`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "m"}]}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "m", "<", "2"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "2"}], "<", "n", "<", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812879274782*^9, 3.503812944763697*^9, {3.5047499105558243`*^9, 
   3.5047499251058445`*^9}, 3.504749962655897*^9, 3.50475000012595*^9, {
   3.5047639369577127`*^9, 3.5047639996578007`*^9}, {3.508012492437707*^9, 
   3.5080125039037275`*^9}, {3.50803744317267*^9, 3.5080375004559703`*^9}, {
   3.5080380525409403`*^9, 3.508038060340954*^9}, {3.510523241955203*^9, 
   3.5105233462245812`*^9}, {3.5105249344968047`*^9, 
   3.5105249997668962`*^9}, {3.510525218367202*^9, 3.510525225307212*^9}, 
   3.5105258453340836`*^9, 3.5105261705445385`*^9, 3.5105287370781317`*^9, {
   3.510787941316291*^9, 3.5107879840363507`*^9}, {3.510788306106802*^9, 
   3.5107883445268555`*^9}, {3.510788495777067*^9, 3.510788532967119*^9}, {
   3.5107885649971647`*^9, 3.5107885715471735`*^9}, 3.510846310911268*^9, {
   3.5108463716889753`*^9, 3.51084637984779*^9}, {3.5108902763567343`*^9, 
   3.5108902793207397`*^9}, 3.5108904227629914`*^9, {3.510890852278546*^9, 
   3.5108908532145476`*^9}, 3.510890886130605*^9, 3.510890918204262*^9, 
   3.5108920192541957`*^9, {3.5108928160315957`*^9, 3.510892839540837*^9}, {
   3.5120874495501933`*^9, 3.512087483860241*^9}, {3.512087591760392*^9, 
   3.5120875957103977`*^9}, {3.512089846877573*^9, 3.512089851257579*^9}, 
   3.5120917865202885`*^9, {3.5120959422307653`*^9, 3.5120959763792257`*^9}, {
   3.5120962946197844`*^9, 3.512096304479002*^9}, {3.5120970875015774`*^9, 
   3.5120970954575915`*^9}, {3.5120971644853125`*^9, 
   3.5120971848277483`*^9}, {3.5121644191092863`*^9, 3.512164448259327*^9}, 
   3.5121646183895655`*^9, 3.5121648571098995`*^9, 3.5121653346866007`*^9, 
   3.5125946590678315`*^9, {3.5126599599552894`*^9, 3.512659963006464*^9}, {
   3.512660494121842*^9, 3.5126604997991667`*^9}, {3.512660907364478*^9, 
   3.512660919152152*^9}, {3.5126621561059017`*^9, 3.512662158970066*^9}, {
   3.512778874309251*^9, 3.5127788775492554`*^9}, {3.5127789821854296`*^9, 
   3.5127789848554335`*^9}, {3.513135755726787*^9, 3.5131357924804516`*^9}, {
   3.513136588682073*^9, 3.513136589312074*^9}, 3.513136877652478*^9, 
   3.5131371914313173`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "13"}], "-", "14"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5026719192141376`*^9, 
   3.5026719206441393`*^9}, {3.5027639618236465`*^9, 3.5027639715424633`*^9}, 
   3.5040443744413013`*^9, {3.5044164493054247`*^9, 3.504416449655425*^9}, {
   3.5044171400563917`*^9, 3.5044171436363964`*^9}, 3.504466673204261*^9, 
   3.504467170384957*^9, 3.504467217635023*^9, {3.504983243733308*^9, 
   3.504983246003311*^9}, {3.5053446908638535`*^9, 3.5053446908638535`*^9}, {
   3.509895305903776*^9, 3.5098953070237775`*^9}, {3.51208035210824*^9, 
   3.51208035225824*^9}, {3.5130529445703335`*^9, 3.513052947390338*^9}, {
   3.5131243094029875`*^9, 3.513124311352991*^9}, 3.513124567614641*^9, {
   3.514840485698845*^9, 3.5148404872788467`*^9}, {3.515188388993827*^9, 
   3.5151883896738276`*^9}, {3.5165559445174956`*^9, 3.51655595284791*^9}, {
   3.5165904012290497`*^9, 3.5165904039690533`*^9}, {3.516590685839448*^9, 
   3.516590687769451*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 1a with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"k", "=", "1"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.50267628508025*^9, 3.5026762853502502`*^9}, {
   3.504071156009178*^9, 3.504071196010466*^9}, 3.505345087544409*^9, 
   3.512064213322332*^9, {3.513123820000527*^9, 3.5131238334945507`*^9}, {
   3.514160748836544*^9, 3.5141607791965866`*^9}, 3.5141609485468235`*^9, {
   3.5141610471569614`*^9, 3.5141610912870235`*^9}}],

Cell[TextData[{
 "Rule 13: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.502677309791684*^9, 3.502677315931693*^9}, {
   3.502767275678668*^9, 3.502767275678668*^9}, {3.5027682258967376`*^9, 
   3.502768240248763*^9}, 3.502768355688966*^9, {3.5033578653664684`*^9, 
   3.50335786655207*^9}, {3.5033582359295187`*^9, 3.5033582359295187`*^9}, 
   3.5033587716500597`*^9, {3.5033592366772776`*^9, 3.5033592415912857`*^9}, {
   3.5034170926496334`*^9, 3.5034170932396345`*^9}, {3.50341731863995*^9, 
   3.5034173205599527`*^9}, {3.5040444208913665`*^9, 3.504044421811368*^9}, {
   3.5040685564574924`*^9, 3.5040685586336164`*^9}, 3.504070424615345*^9, {
   3.5040705726498117`*^9, 3.50407057453592*^9}, 3.504211490026404*^9, 
   3.504212003080105*^9, 3.504313391484715*^9, {3.5049833833135033`*^9, 
   3.504983383653504*^9}, {3.5130529386403255`*^9, 3.5130529389503255`*^9}, 
   3.5131243236146126`*^9, {3.514840490218851*^9, 3.5148404905188513`*^9}, 
   3.516555965390332*^9, {3.516590406139056*^9, 3.5165904066890574`*^9}, {
   3.516590692019457*^9, 3.516590692259457*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"a", " ", "B"}]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", "d", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], ")"}]}]], "\[CenterDot]", 
   "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"a", " ", "B"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "B"}], "-", 
          RowBox[{"a", " ", "b", " ", "A", 
           RowBox[{"(", 
            RowBox[{"n", "+", "2"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "B", 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.501379104811795*^9, 
   3.501379142141847*^9}, {3.5013792182319536`*^9, 3.501379320662097*^9}, {
   3.5033582785331936`*^9, 3.5033582845860043`*^9}, {3.5033583785137696`*^9, 
   3.503358445188287*^9}, {3.504070472352075*^9, 3.504070476579317*^9}, {
   3.505154566603329*^9, 3.505154569413333*^9}, 3.505344640643783*^9, {
   3.5053446908738537`*^9, 3.5053447142638865`*^9}, 3.5053521980433073`*^9, {
   3.509895309653781*^9, 3.509895314563788*^9}, {3.5141609800468674`*^9, 
   3.5141609865168767`*^9}, {3.5151883906138287`*^9, 
   3.5151883924338317`*^9}, {3.5153505744772243`*^9, 3.5153505880336485`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "A"}], "-", 
       RowBox[{"a", "*", "B"}]}], ")"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"b", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "A"}], "-", 
               RowBox[{"a", "*", "B"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"a", "^", "2"}], "*", "B"}], "-", 
               RowBox[{"a", "*", "b", "*", "A", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "2"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"b", "^", "2"}], "*", "B", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "*", 
         "\n", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013793925621977`*^9, 
   3.5013794043922143`*^9}, {3.5013794466722736`*^9, 
   3.5013794903623347`*^9}, {3.5013795357923985`*^9, 
   3.5013795563024273`*^9}, {3.5013796991226273`*^9, 3.501379699302627*^9}, 
   3.5027642158076925`*^9, 3.502764258458167*^9, {3.5027682469255743`*^9, 
   3.5027682564883914`*^9}, 3.502768351960559*^9, {3.5030722647486563`*^9, 
   3.5030722682386613`*^9}, {3.5033578593136578`*^9, 3.5033578712632785`*^9}, 
   3.503358232013912*^9, {3.5033585140000076`*^9, 3.5033585311912374`*^9}, {
   3.503358672153085*^9, 3.5033586943051243`*^9}, {3.5033587991529083`*^9, 
   3.503358802647314*^9}, {3.5033592213268504`*^9, 3.5033592300628653`*^9}, {
   3.503417063039592*^9, 3.503417073999607*^9}, {3.5034173124799414`*^9, 
   3.503417314639944*^9}, 3.503876168067934*^9, {3.504068512327968*^9, 
   3.504068516920231*^9}, {3.504070544905225*^9, 3.504070567860538*^9}, 
   3.5040706659521484`*^9, {3.5040707316559067`*^9, 3.5040707393133445`*^9}, {
   3.505154643833437*^9, 3.505154650013446*^9}, 3.505344640653783*^9, {
   3.5053446909038534`*^9, 3.505344714273886*^9}, 3.505352200753311*^9, {
   3.509895315473789*^9, 3.509895319753795*^9}, {3.513125765307145*^9, 
   3.5131257669607477`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 14b with ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.501722843012315*^9, 3.501722843651916*^9}, 
   3.5033590915190225`*^9, 3.505345104394432*^9, 3.5120642256523495`*^9, {
   3.5131238631502028`*^9, 3.5131238785162296`*^9}, {3.514161363007404*^9, 
   3.5141613735674186`*^9}, {3.514161418037481*^9, 3.514161418037481*^9}, {
   3.5141614999275956`*^9, 3.514161507937607*^9}, {3.5147741279019947`*^9, 
   3.514774137277611*^9}, {3.515196384014434*^9, 3.515196384342035*^9}}],

Cell["\<\
Note: This is an unnecessary special case of rule 14b, but it saves a trivial \
step.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.501722843012315*^9, 3.501722843651916*^9}, 
   3.5033590915190225`*^9, 3.505345104394432*^9, 3.5120642256523495`*^9, {
   3.5131238631502028`*^9, 3.5131238785162296`*^9}, {3.514161363007404*^9, 
   3.5141613735674186`*^9}, {3.514161418037481*^9, 3.514161418037481*^9}, {
   3.5141614999275956`*^9, 3.514161507937607*^9}, {3.5147741279019947`*^9, 
   3.514774137277611*^9}, {3.514774445159752*^9, 3.5147744684037924`*^9}, {
   3.515196344483965*^9, 3.515196344795965*^9}, {3.5151963865572386`*^9, 
   3.51519638730604*^9}, {3.516590417939073*^9, 3.516590418619074*^9}, {
   3.516590699009466*^9, 3.5165906996694674`*^9}}],

Cell[TextData[{
 "Rule 14a: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "A"}], "-", 
    RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.502677309791684*^9, 3.502677315931693*^9}, {
   3.502767275678668*^9, 3.502767275678668*^9}, {3.5027682258967376`*^9, 
   3.502768240248763*^9}, 3.502768355688966*^9, {3.5033578653664684`*^9, 
   3.50335786655207*^9}, {3.5033582359295187`*^9, 3.5033582359295187`*^9}, 
   3.5033587716500597`*^9, {3.5033592366772776`*^9, 3.5033592415912857`*^9}, {
   3.5034170926496334`*^9, 3.5034170932396345`*^9}, {3.50341731863995*^9, 
   3.5034173205599527`*^9}, {3.5040444208913665`*^9, 3.504044421811368*^9}, {
   3.5040685564574924`*^9, 3.5040685586336164`*^9}, {3.5040706209395742`*^9, 
   3.504070625103812*^9}, {3.504145749092245*^9, 3.5041457565022583`*^9}, 
   3.50421149342721*^9, 3.504212007120512*^9, 3.5043133946847196`*^9, {
   3.504983385633507*^9, 3.5049833859135075`*^9}, {3.513052941180329*^9, 
   3.5130529419003296`*^9}, {3.513443996328244*^9, 3.5134439969582453`*^9}, {
   3.5144349061469555`*^9, 3.5144349375654106`*^9}, {3.514695232596006*^9, 
   3.514695232596006*^9}, 3.5147741224731846`*^9, 3.514774477857409*^9, {
   3.5147757791180944`*^9, 3.5147757903501143`*^9}, 3.5148404977088614`*^9, {
   3.5165904132990665`*^9, 3.5165904139590673`*^9}, {3.516590695249461*^9, 
   3.5165906963094625`*^9}}],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{3.50335903309692*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"B", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], 
        RowBox[{"b", " ", "d"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "A"}], "-", 
     RowBox[{"a", " ", "B"}]}], "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.501379104811795*^9, 
   3.501379142141847*^9}, {3.5013792182319536`*^9, 3.501379320662097*^9}, {
   3.5033582785331936`*^9, 3.5033582845860043`*^9}, {3.5033583785137696`*^9, 
   3.503358445188287*^9}, {3.505154573223338*^9, 3.505154575263341*^9}, 
   3.505344640663783*^9, {3.505344690923854*^9, 3.505344714283886*^9}, 
   3.505352203473315*^9, {3.509895320773797*^9, 3.5098953228737993`*^9}, {
   3.514161395417449*^9, 3.514161401987458*^9}, {3.5147741519884367`*^9, 
   3.5147742429209967`*^9}, {3.514774293387085*^9, 3.5147742939486856`*^9}, {
   3.515188457323922*^9, 3.5151884596039257`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_", "+", 
        RowBox[{"B_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "B"}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "A"}], "-", 
         RowBox[{"a", "*", "B"}]}], ")"}], "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013793925621977`*^9, 
   3.5013794043922143`*^9}, {3.5013794466722736`*^9, 
   3.5013794903623347`*^9}, {3.5013795357923985`*^9, 
   3.5013795563024273`*^9}, {3.5013796991226273`*^9, 3.501379699302627*^9}, 
   3.5027642158076925`*^9, 3.502764258458167*^9, {3.5027682469255743`*^9, 
   3.5027682564883914`*^9}, 3.502768351960559*^9, {3.5030722647486563`*^9, 
   3.5030722682386613`*^9}, {3.5033578593136578`*^9, 3.5033578712632785`*^9}, 
   3.503358232013912*^9, {3.5033585140000076`*^9, 3.5033585311912374`*^9}, {
   3.503358672153085*^9, 3.5033586943051243`*^9}, {3.5033587991529083`*^9, 
   3.503358802647314*^9}, {3.5033592213268504`*^9, 3.5033592300628653`*^9}, {
   3.503417063039592*^9, 3.503417073999607*^9}, {3.5034173124799414`*^9, 
   3.503417314639944*^9}, 3.503876168067934*^9, {3.504068512327968*^9, 
   3.504068516920231*^9}, {3.504070630824139*^9, 3.5040706337443066`*^9}, {
   3.5040707623366613`*^9, 3.504070769553074*^9}, {3.5041457282506084`*^9, 
   3.50414574059023*^9}, 3.5053446406837835`*^9, {3.5053446909438534`*^9, 
   3.5053447143038864`*^9}, 3.505352205933318*^9, {3.5098953235538006`*^9, 
   3.5098953255738034`*^9}, 3.51172973862696*^9, 3.511813642946964*^9, {
   3.5134439909382367`*^9, 3.513443991858238*^9}, {3.514415330304461*^9, 
   3.5144153314175243`*^9}, {3.5144348942909346`*^9, 
   3.5144348957573376`*^9}, {3.514695226449595*^9, 3.514695227666397*^9}, {
   3.514774322153536*^9, 3.5147743556779947`*^9}, {3.5147744049116807`*^9, 
   3.514774424021714*^9}, {3.5147756516502705`*^9, 3.514775662102289*^9}, {
   3.514775730414809*^9, 3.5147757604604616`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 2 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"k", "=", "1"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.501722843012315*^9, 3.501722843651916*^9}, 
   3.5033590915190225`*^9, 3.505345104394432*^9, 3.5120642256523495`*^9, {
   3.5131238631502028`*^9, 3.5131238785162296`*^9}, {3.514161363007404*^9, 
   3.5141613735674186`*^9}, {3.514161418037481*^9, 3.514161418037481*^9}, {
   3.5141614999275956`*^9, 3.514161507937607*^9}}],

Cell[TextData[{
 "Rule 14b: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.502677309791684*^9, 3.502677315931693*^9}, {
   3.502767275678668*^9, 3.502767275678668*^9}, {3.5027682258967376`*^9, 
   3.502768240248763*^9}, 3.502768355688966*^9, {3.5033578653664684`*^9, 
   3.50335786655207*^9}, {3.5033582359295187`*^9, 3.5033582359295187`*^9}, 
   3.5033587716500597`*^9, {3.5033592366772776`*^9, 3.5033592415912857`*^9}, {
   3.5034170926496334`*^9, 3.5034170932396345`*^9}, {3.50341731863995*^9, 
   3.5034173205599527`*^9}, {3.5040444208913665`*^9, 3.504044421811368*^9}, {
   3.5040685564574924`*^9, 3.5040685586336164`*^9}, {3.5040706209395742`*^9, 
   3.504070625103812*^9}, {3.504145749092245*^9, 3.5041457565022583`*^9}, 
   3.50421149342721*^9, 3.504212007120512*^9, 3.5043133946847196`*^9, {
   3.504983385633507*^9, 3.5049833859135075`*^9}, {3.513052941180329*^9, 
   3.5130529419003296`*^9}, {3.513443996328244*^9, 3.5134439969582453`*^9}, {
   3.5144349061469555`*^9, 3.5144349375654106`*^9}, {3.514695232596006*^9, 
   3.514695232596006*^9}, 3.5147741224731846`*^9, 3.514774477857409*^9, {
   3.5148405000588646`*^9, 3.514840500918866*^9}, {3.51659042292908*^9, 
   3.5165904234590807`*^9}, {3.516590702869472*^9, 3.516590703609473*^9}}],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{3.50335903309692*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"B", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"b", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "B", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "B"}], "-", 
          RowBox[{"b", " ", "A", 
           RowBox[{"(", 
            RowBox[{"n", "+", "2"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.501379104811795*^9, 
   3.501379142141847*^9}, {3.5013792182319536`*^9, 3.501379320662097*^9}, {
   3.5033582785331936`*^9, 3.5033582845860043`*^9}, {3.5033583785137696`*^9, 
   3.503358445188287*^9}, {3.505154573223338*^9, 3.505154575263341*^9}, 
   3.505344640663783*^9, {3.505344690923854*^9, 3.505344714283886*^9}, 
   3.505352203473315*^9, {3.509895320773797*^9, 3.5098953228737993`*^9}, {
   3.514161395417449*^9, 3.514161401987458*^9}, {3.5151884625539293`*^9, 
   3.5151884663739347`*^9}, 3.515350682148614*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "B"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"b", "*", "B", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "B"}], "-", 
               RowBox[{"b", "*", "A", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "2"}], ")"}]}]}], ")"}], "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013793925621977`*^9, 
   3.5013794043922143`*^9}, {3.5013794466722736`*^9, 
   3.5013794903623347`*^9}, {3.5013795357923985`*^9, 
   3.5013795563024273`*^9}, {3.5013796991226273`*^9, 3.501379699302627*^9}, 
   3.5027642158076925`*^9, 3.502764258458167*^9, {3.5027682469255743`*^9, 
   3.5027682564883914`*^9}, 3.502768351960559*^9, {3.5030722647486563`*^9, 
   3.5030722682386613`*^9}, {3.5033578593136578`*^9, 3.5033578712632785`*^9}, 
   3.503358232013912*^9, {3.5033585140000076`*^9, 3.5033585311912374`*^9}, {
   3.503358672153085*^9, 3.5033586943051243`*^9}, {3.5033587991529083`*^9, 
   3.503358802647314*^9}, {3.5033592213268504`*^9, 3.5033592300628653`*^9}, {
   3.503417063039592*^9, 3.503417073999607*^9}, {3.5034173124799414`*^9, 
   3.503417314639944*^9}, 3.503876168067934*^9, {3.504068512327968*^9, 
   3.504068516920231*^9}, {3.504070630824139*^9, 3.5040706337443066`*^9}, {
   3.5040707623366613`*^9, 3.504070769553074*^9}, {3.5041457282506084`*^9, 
   3.50414574059023*^9}, 3.5053446406837835`*^9, {3.5053446909438534`*^9, 
   3.5053447143038864`*^9}, 3.505352205933318*^9, {3.5098953235538006`*^9, 
   3.5098953255738034`*^9}, 3.51172973862696*^9, 3.511813642946964*^9, {
   3.5134439909382367`*^9, 3.513443991858238*^9}, {3.514415330304461*^9, 
   3.5144153314175243`*^9}, {3.5144348942909346`*^9, 
   3.5144348957573376`*^9}, {3.514695226449595*^9, 3.514695227666397*^9}, 
   3.5147744810554147`*^9, {3.5152105449120274`*^9, 3.5152105490616345`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "11"}], "-", "12"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}], "   ", "j", " ", "k", " ", "m"}]}], 
   "<", 
   RowBox[{
    RowBox[{"-", "1"}], 
    RowBox[{"??", "?"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5026719192141376`*^9, 
   3.5026719206441393`*^9}, {3.5027639618236465`*^9, 3.5027639715424633`*^9}, 
   3.5040443744413013`*^9, {3.5044164493054247`*^9, 3.504416449655425*^9}, {
   3.5044164889854803`*^9, 3.504416491835484*^9}, {3.504417102516339*^9, 
   3.504417104716342*^9}, {3.504466669004255*^9, 3.504466669194255*^9}, {
   3.504922954829204*^9, 3.504922955309205*^9}, {3.5049832399233027`*^9, 
   3.504983242233306*^9}, {3.505344690753853*^9, 3.505344690763853*^9}, {
   3.509895277013736*^9, 3.509895277943737*^9}, 3.510951682971836*^9, {
   3.5120803545782433`*^9, 3.5120803547582436`*^9}, {3.5130529530203457`*^9, 
   3.5130529546503477`*^9}, {3.5148404692988214`*^9, 
   3.5148404707488236`*^9}, {3.515188370903801*^9, 3.5151883720638027`*^9}, 
   3.515196320241522*^9, {3.5165903701390057`*^9, 3.51659037307901*^9}, {
   3.5165906684394236`*^9, 3.5165906703794265`*^9}, {3.517074666369236*^9, 
   3.517074678662058*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 4a with ",
 Cell[BoxData[
  RowBox[{"n", "=", "1"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, {
   3.5049231258994436`*^9, 3.504923126359444*^9}, 3.504923176059514*^9, {
   3.5049233163497105`*^9, 3.504923318979714*^9}, 3.505345087544409*^9, 
   3.5120642494723825`*^9, {3.51416003869555*^9, 3.5141600609455805`*^9}}],

Cell[TextData[{
 "Rule 11: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"b", " ", "A"}], "-", 
       RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]}], "\[NotEqual]", "0"}], "  ", "\[And]",
      " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "\[LessEqual]", 
      RowBox[{"-", "1", " "}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501357957382189*^9, 3.50135795852219*^9}, {3.501358112502406*^9, 
   3.501358113912408*^9}, 3.501358177622497*^9, {3.501358226452565*^9, 
   3.50135822974257*^9}, 3.5013587175532527`*^9, {3.501359477874317*^9, 
   3.5013594968243437`*^9}, {3.5013598992049074`*^9, 3.501359907704919*^9}, {
   3.5027643770807753`*^9, 3.502764379015179*^9}, {3.5027682951140594`*^9, 
   3.5027682985460653`*^9}, {3.5040444264213743`*^9, 
   3.5040444272313757`*^9}, {3.504051718871584*^9, 3.5040517366516085`*^9}, {
   3.5041205238947134`*^9, 3.5041205286947203`*^9}, {3.5041451538731995`*^9, 
   3.5041451569620047`*^9}, {3.5041454113516517`*^9, 
   3.5041454141752567`*^9}, {3.504145548850293*^9, 3.504145550753496*^9}, {
   3.504145668174903*^9, 3.504145670873708*^9}, 3.5041460239023275`*^9, 
   3.5042114359411087`*^9, 3.5042120137973237`*^9, {3.5043055572477922`*^9, 
   3.5043055826678276`*^9}, {3.504313401324729*^9, 3.504313426674764*^9}, {
   3.504915799927727*^9, 3.504915802642132*^9}, {3.5049833725834885`*^9, 
   3.504983372763489*^9}, {3.5109486590476027`*^9, 3.510948660287605*^9}, 
   3.5109487664677534`*^9, {3.510951204221166*^9, 3.510951267131254*^9}, {
   3.5117211893848715`*^9, 3.5117211893848715`*^9}, {3.5130529300303135`*^9, 
   3.5130529302903137`*^9}, {3.5148404740988283`*^9, 3.514840474328829*^9}, {
   3.5148590634642477`*^9, 3.5148590960995054`*^9}, {3.516590375749014*^9, 
   3.5165903761590147`*^9}, {3.51659067258943*^9, 3.51659067280943*^9}, {
   3.5166669703846846`*^9, 3.5166669761254945`*^9}, {3.5170744205752044`*^9, 
   3.517074442103242*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"a", " ", "A", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "1"}], "2"]}]], "\[CenterDot]", "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "+", 
       RowBox[{"j", " ", "k"}]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "+", 
          RowBox[{"a", " ", "B"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "A", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"j", " ", "k", " ", "m"}], "+", 
             FractionBox[
              RowBox[{"k", "+", "3"}], "2"]}], ")"}]}], "+", 
          RowBox[{"b", " ", "B", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"j", " ", "k", " ", "m"}], "+", 
             FractionBox[
              RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5101642451402383`*^9, 3.5101642493366456`*^9}, {3.5101644045413184`*^9, 
   3.510164447176193*^9}, {3.510164586047637*^9, 3.5101645942844515`*^9}, {
   3.5109473661157928`*^9, 3.510947491045968*^9}, {3.51094802861672*^9, 
   3.510948053226755*^9}, {3.510948086556802*^9, 3.510948138246874*^9}, {
   3.5109482435870214`*^9, 3.510948245437024*^9}, {3.5109484299872828`*^9, 
   3.5109484426273003`*^9}, {3.5141601277356744`*^9, 3.514160133635683*^9}, {
   3.5141603514459877`*^9, 3.514160355995994*^9}, {3.5148589334380198`*^9, 
   3.5148589728904886`*^9}, {3.515188373333805*^9, 3.5151883763938093`*^9}, {
   3.515350459208622*^9, 3.5153504707994423`*^9}, {3.517074252562909*^9, 
   3.5170742779129534`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", "A", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k"}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "A"}], "+", 
               RowBox[{"a", "*", "B"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "A", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}], 
               "+", 
               RowBox[{"b", "*", "B", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], "\[NotEqual]", "0"}], 
    " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[LessEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, {
   3.5013580787823586`*^9, 3.501358106962398*^9}, {3.5013582067925377`*^9, 
   3.501358211902545*^9}, 3.501358373452771*^9, 3.5013585105529633`*^9, 
   3.50135855130302*^9, {3.501358588363072*^9, 3.5013585908430758`*^9}, {
   3.5013594588842907`*^9, 3.5013595034543533`*^9}, {3.5013595659344406`*^9, 
   3.501359596824484*^9}, {3.5013596546845646`*^9, 3.501359719054655*^9}, {
   3.5013597781847377`*^9, 3.5013597870547504`*^9}, {3.50135987966488*^9, 
   3.5013598824348836`*^9}, 3.501360113425207*^9, {3.501374332235113*^9, 
   3.5013743452151318`*^9}, {3.5027642027504697`*^9, 3.502764205761275*^9}, 
   3.5027682867680445`*^9, {3.502775926168691*^9, 3.5027759413007174`*^9}, {
   3.503072253508641*^9, 3.503072257958647*^9}, 3.5031982555302105`*^9, 
   3.503876178473152*^9, {3.504045248372525*^9, 3.504045267792552*^9}, 
   3.504120510064694*^9, {3.5041453077518697`*^9, 3.5041453211210933`*^9}, {
   3.5041453687011766`*^9, 3.504145374005186*^9}, 3.50414561538441*^9, {
   3.5041456565216827`*^9, 3.504145663323294*^9}, 3.5041457756902914`*^9, {
   3.504305540807769*^9, 3.504305544827774*^9}, {3.504762414265581*^9, 
   3.504762421735591*^9}, {3.504915879213067*^9, 3.504915888448283*^9}, 
   3.5049163906755657`*^9, 3.5053446406037827`*^9, {3.5053446907938533`*^9, 
   3.505344714223886*^9}, 3.5053521289932103`*^9, {3.509895282973744*^9, 
   3.5098952883637514`*^9}, {3.5109483211571302`*^9, 3.51094832844714*^9}, 
   3.5109483745572047`*^9, {3.510948409797254*^9, 3.5109484104072547`*^9}, {
   3.51094854277744*^9, 3.5109485429574404`*^9}, {3.510948573557483*^9, 
   3.5109486181175456`*^9}, {3.5109510885210047`*^9, 
   3.5109511065610294`*^9}, {3.51095139975144*^9, 3.510951401091442*^9}, {
   3.5141601371656876`*^9, 3.5141601425556955`*^9}, {3.5141603657660074`*^9, 
   3.514160369516013*^9}, {3.514415224490409*^9, 3.514415230688763*^9}, {
   3.5148591445999904`*^9, 3.5148592003856883`*^9}, {3.5148593104594817`*^9, 
   3.51485933802473*^9}, 3.514859475114571*^9, {3.516666895738553*^9, 
   3.5166669649402747`*^9}, 3.51682070475653*^9, 3.51707391696272*^9, {
   3.51707432689704*^9, 3.517074353744687*^9}, {3.5170744622272778`*^9, 
   3.5170744816493115`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 3a with ",
 Cell[BoxData[
  RowBox[{"n", "=", "1"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, {
   3.5049231258994436`*^9, 3.504923126359444*^9}, 3.504923176059514*^9, 
   3.505345123284459*^9, 3.512064237812366*^9, {3.514160258985858*^9, 
   3.5141602769758835`*^9}}],

Cell[TextData[{
 "Rule 12: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"b", " ", "A"}], "-", 
       RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "\[GreaterEqual]", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501357957382189*^9, 3.50135795852219*^9}, {3.501358112502406*^9, 
   3.501358113912408*^9}, 3.501358177622497*^9, {3.501358226452565*^9, 
   3.50135822974257*^9}, 3.5013587175532527`*^9, {3.501359477874317*^9, 
   3.5013594968243437`*^9}, {3.5013598992049074`*^9, 3.501359907704919*^9}, {
   3.5027643770807753`*^9, 3.502764379015179*^9}, {3.5027682951140594`*^9, 
   3.5027682985460653`*^9}, {3.5040444264213743`*^9, 
   3.5040444272313757`*^9}, {3.504051718871584*^9, 3.5040517366516085`*^9}, {
   3.5041205238947134`*^9, 3.5041205286947203`*^9}, {3.5041451538731995`*^9, 
   3.5041451569620047`*^9}, {3.5041454113516517`*^9, 
   3.5041454141752567`*^9}, {3.504145548850293*^9, 3.504145550753496*^9}, {
   3.504145668174903*^9, 3.504145670873708*^9}, 3.5041460239023275`*^9, 
   3.5042114359411087`*^9, 3.5042120137973237`*^9, {3.5043055572477922`*^9, 
   3.5043055826678276`*^9}, {3.504313401324729*^9, 3.504313426674764*^9}, {
   3.5049158079617414`*^9, 3.5049158092097435`*^9}, 3.504915901365106*^9, {
   3.504915959896409*^9, 3.504915960161609*^9}, {3.5049833747934914`*^9, 
   3.5049833755134926`*^9}, 3.5109491270382586`*^9, {3.5109493627985888`*^9, 
   3.5109493634085894`*^9}, {3.5109505850002995`*^9, 
   3.5109505965403156`*^9}, {3.5117211956248803`*^9, 
   3.5117211956248803`*^9}, {3.5130529323603163`*^9, 
   3.5130529326203165`*^9}, {3.5148404771088324`*^9, 3.514840477368833*^9}, {
   3.5148590319053926`*^9, 3.5148590402982073`*^9}, {3.5165903784790177`*^9, 
   3.516590379309019*^9}, {3.5165906753794336`*^9, 3.516590675609434*^9}, {
   3.5166671013001146`*^9, 3.5166671020957155`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "B", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"j", " ", "k"}]}]]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "3"}], "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "3"}], "2"]}]], "\[CenterDot]", "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "A", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "3"}], "2"]}], ")"}]}], "+", 
       RowBox[{"b", " ", "B", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "+", 
          RowBox[{"a", " ", "B"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "3"}], "2"]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095562652147536`*^9, 3.5095563252848377`*^9}, {3.50955638387492*^9, 
   3.5095564136949615`*^9}, {3.5095564499650126`*^9, 
   3.5095565745651865`*^9}, {3.509556659575306*^9, 3.5095566816053367`*^9}, {
   3.5095567320554075`*^9, 3.5095567407354193`*^9}, {3.509556895905637*^9, 
   3.5095569251456776`*^9}, {3.510172496160655*^9, 3.510172513227085*^9}, {
   3.5101727774135485`*^9, 3.5101727805647545`*^9}, {3.5101732386595592`*^9, 
   3.51017323937716*^9}, {3.510173272480418*^9, 3.510173288844847*^9}, {
   3.510948884697919*^9, 3.5109489736080437`*^9}, {3.510949016698104*^9, 
   3.5109491023682237`*^9}, {3.514160376806023*^9, 3.514160397506052*^9}, {
   3.5148589791148996`*^9, 3.514859010642555*^9}, {3.515188381893817*^9, 
   3.5151883838838196`*^9}, {3.5153505116559143`*^9, 
   3.5153505254931383`*^9}, {3.5170742947609835`*^9, 3.517074310985012*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5109492025083637`*^9, 3.51094920728837*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "B", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k"}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", "\[IndentingNewLine]", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{"b", "*", "B", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "A"}], "+", 
               RowBox[{"a", "*", "B"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[GreaterEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, {
   3.5013580787823586`*^9, 3.501358106962398*^9}, {3.5013582067925377`*^9, 
   3.501358211902545*^9}, 3.501358373452771*^9, 3.5013585105529633`*^9, 
   3.50135855130302*^9, {3.501358588363072*^9, 3.5013585908430758`*^9}, {
   3.5013594588842907`*^9, 3.5013595034543533`*^9}, {3.5013595659344406`*^9, 
   3.501359596824484*^9}, {3.5013596546845646`*^9, 3.501359719054655*^9}, {
   3.5013597781847377`*^9, 3.5013597870547504`*^9}, {3.50135987966488*^9, 
   3.5013598824348836`*^9}, 3.501360113425207*^9, {3.501374332235113*^9, 
   3.5013743452151318`*^9}, {3.5027642027504697`*^9, 3.502764205761275*^9}, 
   3.5027682867680445`*^9, {3.502775926168691*^9, 3.5027759413007174`*^9}, {
   3.503072253508641*^9, 3.503072257958647*^9}, 3.5031982555302105`*^9, 
   3.503876178473152*^9, {3.504045248372525*^9, 3.504045267792552*^9}, 
   3.504120510064694*^9, {3.5041453077518697`*^9, 3.5041453211210933`*^9}, {
   3.5041453687011766`*^9, 3.504145374005186*^9}, 3.50414561538441*^9, {
   3.5041456565216827`*^9, 3.504145663323294*^9}, 3.5041457756902914`*^9, {
   3.504305540807769*^9, 3.504305544827774*^9}, {3.504762414265581*^9, 
   3.504762421735591*^9}, {3.5049158936586924`*^9, 3.5049158973402987`*^9}, 
   3.505344640623783*^9, {3.5053446908338532`*^9, 3.505344714253886*^9}, 
   3.5053521337132173`*^9, {3.5098952955337615`*^9, 3.5098952976537647`*^9}, {
   3.51094913551827*^9, 3.5109491528282948`*^9}, 3.510949226628398*^9, {
   3.510949350678571*^9, 3.51094935690858*^9}, {3.5109505292202215`*^9, 
   3.5109505361902313`*^9}, {3.514160420296084*^9, 3.514160428326095*^9}, 
   3.514160470256154*^9, {3.5144152384072046`*^9, 3.5144152399122906`*^9}, {
   3.5148592346745486`*^9, 3.514859276981823*^9}, {3.5148593587259665`*^9, 
   3.514859363671175*^9}, 3.5166668999349604`*^9, {3.5166669867179127`*^9, 
   3.516667048384821*^9}, {3.5166671081953263`*^9, 3.5166671093029284`*^9}, 
   3.51682070479653*^9, 3.5170739200203247`*^9, {3.5170743609986997`*^9, 
   3.5170743824955373`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "9"}], "-", "10"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5026719192141376`*^9, 
   3.5026719206441393`*^9}, {3.5027639618236465`*^9, 3.5027639715424633`*^9}, 
   3.5040443744413013`*^9, {3.5044164493054247`*^9, 3.504416449655425*^9}, {
   3.5044171400563917`*^9, 3.5044171436363964`*^9}, 3.504466673204261*^9, 
   3.504467170384957*^9, 3.504467217635023*^9, {3.504983243733308*^9, 
   3.504983246003311*^9}, {3.5053446908638535`*^9, 3.5053446908638535`*^9}, {
   3.509895305903776*^9, 3.5098953070237775`*^9}, {3.51208035210824*^9, 
   3.51208035225824*^9}, {3.5130529445703335`*^9, 3.513052947390338*^9}, {
   3.5131243094029875`*^9, 3.513124311352991*^9}, 3.513124567614641*^9, {
   3.514840485698845*^9, 3.5148404872788467`*^9}, {3.515188388993827*^9, 
   3.5151883896738276`*^9}, {3.516551699910445*^9, 3.516551703030451*^9}, 
   3.516555806852453*^9, {3.5165560094296093`*^9, 3.5165560121000137`*^9}, {
   3.5165903043989143`*^9, 3.5165903069189177`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.551.1", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.4979864629538083`*^9, 3.4979864631566086`*^9}, {
   3.505354450536461*^9, 3.505354450786461*^9}}],

Cell[TextData[{
 "Derivation: Rule 1b with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   FractionBox[
    RowBox[{"k", "-", "1"}], "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.5017264195673985`*^9, 
   3.5017264509546537`*^9}, {3.5017265299999924`*^9, 
   3.5017265322151966`*^9}, {3.5017266933478794`*^9, 
   3.5017267053755007`*^9}, {3.5017269204530783`*^9, 3.501726921030279*^9}, 
   3.505345123274459*^9, {3.510265138242697*^9, 3.5102651438627043`*^9}, {
   3.510265545503267*^9, 3.5102655461032677`*^9}, {3.510422526020422*^9, 
   3.510422526020422*^9}, 3.5120641942223053`*^9, {3.5141588768839235`*^9, 
   3.5141589050139627`*^9}, {3.5141592014743776`*^9, 
   3.5141592062943845`*^9}, {3.516553361728964*^9, 3.516553383615802*^9}}],

Cell[TextData[{
 "Rule 9: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.504364584041261*^9, 3.504364585481263*^9}, {
   3.5043646357213335`*^9, 3.5043646359213343`*^9}, {3.5043679570379877`*^9, 
   3.504367958197989*^9}, 3.5049832861833677`*^9, 3.5049833569634666`*^9, {
   3.5051849569721966`*^9, 3.5051849812355843`*^9}, {3.5105052297883635`*^9, 
   3.5105052302875643`*^9}, {3.512186737480956*^9, 3.51218673982096*^9}, {
   3.512254301019486*^9, 3.512254302283088*^9}, 3.512269040108324*^9, {
   3.5130526959899855`*^9, 3.5130526974799876`*^9}, {3.5144328618769655`*^9, 
   3.5144328644041696`*^9}, {3.514612683661013*^9, 3.5146126839574137`*^9}, {
   3.514839541717523*^9, 3.5148395419375234`*^9}, {3.516553407655444*^9, 
   3.516553423973073*^9}, {3.5165560160468206`*^9, 3.5165560163900213`*^9}, 
   3.5165903139089274`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          FractionBox[
           RowBox[{"k", "-", "1"}], "2"]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      FractionBox[
       RowBox[{"k", "-", "1"}], "2"]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "A"}], "-", 
          RowBox[{"b", " ", "B"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"a", " ", "B"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, 
   3.4979862241517887`*^9, {3.497986268845867*^9, 3.4979862970039167`*^9}, 
   3.4979902514328623`*^9, 3.5053446405637827`*^9, {3.505344690713853*^9, 
   3.505344714183886*^9}, 3.505352022693062*^9, {3.509895269213724*^9, 
   3.5098952711637273`*^9}, {3.5122692616086345`*^9, 3.512269267248642*^9}, {
   3.515188024323316*^9, 3.515188026363319*^9}, {3.516551821731059*^9, 
   3.5165518580747232`*^9}, {3.5165519661609135`*^9, 3.5165520026337776`*^9}, 
   3.516552122941189*^9, {3.516552341113172*^9, 3.516552355215597*^9}, 
   3.5165527682027216`*^9, {3.5165530664828453`*^9, 3.5165530855148783`*^9}, {
   3.516553126870551*^9, 3.516553157540205*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "A"}], "-", 
        RowBox[{"a", "*", "B"}]}], ")"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "A"}], "-", 
               RowBox[{"b", "*", "B"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "A"}], "-", 
               RowBox[{"a", "*", "B"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "2"}], ")"}], "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, 
   3.4979862281609955`*^9, {3.4979862780186834`*^9, 3.4979862991255207`*^9}, 
   3.4979863964508915`*^9, {3.497990453203616*^9, 3.497990473936053*^9}, 
   3.4986794274067383`*^9, {3.498763920866046*^9, 3.4987639593560996`*^9}, {
   3.4991312222624083`*^9, 3.49913122341241*^9}, {3.5010427775038137`*^9, 
   3.501042778515871*^9}, {3.5030725326890316`*^9, 3.5030725406290426`*^9}, 
   3.5038761341846743`*^9, 3.5043679506879787`*^9, {3.5051850204098253`*^9, 
   3.505185024399053*^9}, 3.5053446405137825`*^9, {3.5053446906538534`*^9, 
   3.505344714143886*^9}, 3.5053519910530176`*^9, 3.508782980727106*^9, {
   3.5098952623037148`*^9, 3.509895264533718*^9}, 3.510433803854216*^9, 
   3.5105126206769457`*^9, 3.511808081063163*^9, {3.51218729646274*^9, 
   3.5121872973831415`*^9}, 3.5130466567580743`*^9, 3.5130480542714767`*^9, {
   3.514432838336524*^9, 3.5144328412381287`*^9}, 3.5144740905881166`*^9, 
   3.514613689160779*^9, {3.5165555422003884`*^9, 3.516555563619226*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "A"}], "-", 
        RowBox[{"a", "*", "B"}]}], ")"}]}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", "\[IndentingNewLine]", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "A"}], "-", 
               RowBox[{"b", "*", "B"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "A"}], "-", 
               RowBox[{"a", "*", "B"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "2"}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5026764690205073`*^9, {3.502676562960639*^9, 3.5026765748706555`*^9}, {
   3.502676709910845*^9, 3.502676745080894*^9}, {3.502677686692212*^9, 
   3.5026776934822216`*^9}, {3.5027670612250915`*^9, 
   3.5027670636898956`*^9}, {3.503071936858197*^9, 3.5030719454782095`*^9}, 
   3.50319810512*^9, {3.503549703821251*^9, 3.503549709891259*^9}, 
   3.50387619429158*^9, {3.5051554747458277`*^9, 3.5051554812558365`*^9}, 
   3.505344641353784*^9, {3.5053446929738564`*^9, 3.505344714963887*^9}, 
   3.505353544425192*^9, {3.50924009739312*^9, 3.509240125441969*^9}, {
   3.509240420719288*^9, 3.509240479234991*^9}, {3.5092405242254696`*^9, 
   3.509240529685479*^9}, 3.509240560292733*^9, 3.5092406309608574`*^9, {
   3.509240739193847*^9, 3.5092407562290773`*^9}, {3.5094733083539004`*^9, 
   3.50947331918552*^9}, {3.509475162067927*^9, 3.509475162249937*^9}, 
   3.509475333159713*^9, {3.5094799670517564`*^9, 3.5094799740681577`*^9}, 
   3.5094800542107415`*^9, {3.5095612456781588`*^9, 3.5095612748082*^9}, 
   3.5095620502492857`*^9, {3.510172404058093*^9, 3.5101724092061024`*^9}, {
   3.5101724458193665`*^9, 3.510172460951393*^9}, 3.510172592319224*^9, {
   3.510172636950902*^9, 3.5101726399773073`*^9}, 3.510179325857098*^9, 
   3.5101800555639796`*^9, {3.510960394235654*^9, 3.5109604170256853`*^9}, {
   3.510961297750921*^9, 3.5109613190309505`*^9}, 3.510961446411129*^9, {
   3.5121851888858356`*^9, 3.512185189806237*^9}, 3.513121332149756*^9, {
   3.5131251560320745`*^9, 3.513125172942504*^9}, 3.513125654531351*^9, {
   3.5131257079458447`*^9, 3.513125727133878*^9}, {3.513126311744905*^9, 
   3.513126312805707*^9}, {3.5144345889203987`*^9, 3.5144345900904007`*^9}, {
   3.5146748844399185`*^9, 3.5146748859099207`*^9}, {3.5165535451036863`*^9, 
   3.516553577442543*^9}, {3.516568556038437*^9, 3.5165685579084396`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.551.1 inverted", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, {
   3.4979864571349983`*^9, 3.4979864574937987`*^9}, {3.505354465216481*^9, 
   3.5053544654264812`*^9}}],

Cell[TextData[{
 "Derivation: Rule 3b with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   FractionBox[
    RowBox[{"k", "-", "1"}], "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.5017264195673985`*^9, 
   3.5017264509546537`*^9}, {3.5017265299999924`*^9, 3.5017265322151966`*^9}, 
   3.505345123284459*^9, 3.512064236782365*^9, {3.5141593635446043`*^9, 
   3.5141594128246737`*^9}, {3.516552304297107*^9, 3.516552331550355*^9}, {
   3.5165523859008503`*^9, 3.516552386836852*^9}}],

Cell[TextData[{
 "Rule 10: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.5004322533111067`*^9, 
   3.5004322794606023`*^9}, {3.5030203943207865`*^9, 
   3.5030203943207865`*^9}, {3.5043646078512945`*^9, 3.504364638711338*^9}, 
   3.504471249250667*^9, {3.504983297263383*^9, 3.504983298043384*^9}, {
   3.505185059347052*^9, 3.5051850634142847`*^9}, {3.510010655210175*^9, 
   3.510010661460184*^9}, {3.5105052330331697`*^9, 3.510505233813171*^9}, {
   3.512186750070178*^9, 3.51218675138058*^9}, {3.512254288430264*^9, 
   3.512254290224267*^9}, 3.5122690611683536`*^9, {3.5130527066400003`*^9, 
   3.5130527081400023`*^9}, {3.5146063962581987`*^9, 3.514606396468199*^9}, {
   3.5146464410883884`*^9, 3.514646442367591*^9}, {3.514649252462927*^9, 
   3.514649254662531*^9}, {3.514649331024665*^9, 3.514649332132267*^9}, {
   3.514650269428713*^9, 3.514650269428713*^9}, {3.5146527184176073`*^9, 
   3.5146527186776075`*^9}, {3.514839598647603*^9, 3.514839599187604*^9}, {
   3.514842893279436*^9, 3.514842893279436*^9}, 3.516552160896055*^9, {
   3.516552825434822*^9, 3.5165528261056232`*^9}, {3.5165560194164267`*^9, 
   3.5165560202432284`*^9}, {3.516590317298932*^9, 3.5165903179789333`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"B", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          FractionBox[
           RowBox[{"k", "-", "1"}], "2"]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"n", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      FractionBox[
       RowBox[{"k", "-", "1"}], "2"]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "B", " ", "n"}], "+", 
       RowBox[{"a", " ", "A", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "B", " ", "n"}], "+", 
          RowBox[{"b", " ", "A", " ", 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, 
   3.4979862241517887`*^9, {3.497986268845867*^9, 3.4979862970039167`*^9}, 
   3.4979902514328623`*^9, 3.5053446405637827`*^9, {3.505344690713853*^9, 
   3.505344714183886*^9}, 3.505352022693062*^9, {3.509895269213724*^9, 
   3.5098952711637273`*^9}, {3.5122692616086345`*^9, 3.512269267248642*^9}, {
   3.515188024323316*^9, 3.515188026363319*^9}, {3.516551821731059*^9, 
   3.5165518580747232`*^9}, {3.5165519661609135`*^9, 3.5165520026337776`*^9}, 
   3.516552122941189*^9, {3.516552341113172*^9, 3.516552355215597*^9}, 
   3.5165527682027216`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "B"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"b", "*", "B", "*", "n"}], "+", 
            RowBox[{"a", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "B", "*", "n"}], "+", 
               RowBox[{"b", "*", "A", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4979862253061905`*^9, {
   3.497986271107871*^9, 3.497986297799518*^9}, 3.497986386903675*^9, 
   3.4986794582767816`*^9, {3.500419863725463*^9, 3.5004198652605505`*^9}, 
   3.5004202566819386`*^9, {3.500432258158384*^9, 3.5004322592084436`*^9}, 
   3.503020185000493*^9, 3.503020369830752*^9, {3.5030725476090527`*^9, 
   3.5030725694590836`*^9}, 3.503876142483889*^9, {3.505185046002289*^9, 
   3.5051850551548123`*^9}, 3.505344640573783*^9, {3.5053446907338533`*^9, 
   3.505344714193886*^9}, 3.505352025233065*^9, 3.5087829424446387`*^9, {
   3.509895272053728*^9, 3.509895275953734*^9}, 3.510433804704217*^9, 
   3.510513659779171*^9, 3.511807932152954*^9, {3.5121872577122717`*^9, 
   3.512187260473477*^9}, {3.5122693811788015`*^9, 3.5122693823488035`*^9}, 
   3.5130467260581713`*^9, 3.5130480309114447`*^9, {3.5144150721536956`*^9, 
   3.514415073159753*^9}, 3.5144740613848653`*^9, 3.5146137080368123`*^9, 
   3.5146497442693906`*^9, {3.514650251285881*^9, 3.514650252190683*^9}, 
   3.514842982948394*^9, 3.516552174312079*^9, 3.516552233577783*^9, {
   3.516560441226583*^9, 3.516560442318585*^9}, {3.51656050240749*^9, 
   3.516560503437092*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "B"}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", "\n", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"b", "*", "B", "*", "n"}], "+", 
            RowBox[{"a", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "B", "*", "n"}], "+", 
               RowBox[{"b", "*", "A", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013793925621977`*^9, 
   3.5013794043922143`*^9}, {3.5013794466722736`*^9, 
   3.5013794903623347`*^9}, {3.5013795357923985`*^9, 
   3.5013795563024273`*^9}, {3.5013796991226273`*^9, 3.501379699302627*^9}, 
   3.5027642158076925`*^9, 3.502764258458167*^9, {3.5027682469255743`*^9, 
   3.5027682564883914`*^9}, 3.502768351960559*^9, {3.5030722647486563`*^9, 
   3.5030722682386613`*^9}, {3.5033578593136578`*^9, 3.5033578712632785`*^9}, 
   3.503358232013912*^9, {3.5033585140000076`*^9, 3.5033585311912374`*^9}, {
   3.503358672153085*^9, 3.5033586943051243`*^9}, {3.5033587991529083`*^9, 
   3.503358802647314*^9}, {3.5033592213268504`*^9, 3.5033592300628653`*^9}, {
   3.503417063039592*^9, 3.503417073999607*^9}, {3.5034173124799414`*^9, 
   3.503417314639944*^9}, 3.503876168067934*^9, {3.504068512327968*^9, 
   3.504068516920231*^9}, {3.504070630824139*^9, 3.5040706337443066`*^9}, {
   3.5040707623366613`*^9, 3.504070769553074*^9}, {3.5041457282506084`*^9, 
   3.50414574059023*^9}, 3.5053446406837835`*^9, {3.5053446909438534`*^9, 
   3.5053447143038864`*^9}, 3.505352205933318*^9, {3.5098953235538006`*^9, 
   3.5098953255738034`*^9}, 3.51172973862696*^9, 3.511813642946964*^9, {
   3.5134439909382367`*^9, 3.513443991858238*^9}, {3.514415330304461*^9, 
   3.5144153314175243`*^9}, {3.5144348942909346`*^9, 
   3.5144348957573376`*^9}, {3.514695226449595*^9, 3.514695227666397*^9}, 
   3.5147744810554147`*^9, {3.515210528251198*^9, 3.515210555629246*^9}, 
   3.5152105960957174`*^9, {3.515210730224753*^9, 3.5152107408483715`*^9}, {
   3.515210849018962*^9, 3.515210867192993*^9}, {3.5152113171445837`*^9, 
   3.5152113302174067`*^9}, {3.516552447832959*^9, 3.5165524501729636`*^9}, {
   3.5165554144853644`*^9, 3.5165554391178074`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "1"}], "-", "6"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5026719192141376`*^9, 
   3.5026719206441393`*^9}, {3.5027639618236465`*^9, 3.5027639715424633`*^9}, 
   3.5040443744413013`*^9, {3.504416834825964*^9, 3.50441685330599*^9}, {
   3.5044169074260654`*^9, 3.504416914836076*^9}, {3.504466654444235*^9, 
   3.504466654664235*^9}, {3.5053446909738536`*^9, 3.5053446909738536`*^9}, {
   3.509895545887774*^9, 3.5098955477129774`*^9}, 3.5100196487192698`*^9, 
   3.5101738434258213`*^9, {3.512080349338236*^9, 3.512080349518236*^9}, {
   3.515188472783944*^9, 3.515188473463945*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 1a, 1b or 6 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "A"}], "-", 
    RowBox[{"a", " ", "B"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.50267628508025*^9, 3.5026762853502502`*^9}, {
   3.504031783052849*^9, 3.504031790244461*^9}, 3.505345087634409*^9, 
   3.512074540034026*^9, {3.5144121659594707`*^9, 3.514412173711914*^9}, {
   3.514412476078209*^9, 3.514412508863084*^9}, 3.5144127893051243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, {3.4979866726025763`*^9, 
   3.497986673616578*^9}, {3.5006614307985444`*^9, 3.5006614323585463`*^9}}],

Cell[TextData[{
 "Basis:",
 " If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "A"}], "-", 
    RowBox[{"a", " ", "B"}]}], "=", "0"}]]],
 ", then",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"A", "+", 
    RowBox[{"B", " ", "z"}]}], "=", 
   RowBox[{
    FractionBox["B", "b"], 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "z"}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.497989934892706*^9, 
   3.49798993732631*^9}, {3.5006615536287165`*^9, 3.5006615979187784`*^9}, {
   3.5027670038793907`*^9, 3.5027670131458073`*^9}, {3.5027679251438093`*^9, 
   3.5027679269222126`*^9}, {3.514414685914604*^9, 3.514414685914604*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"b", " ", "A"}], "-", 
       RowBox[{"a", " ", "B"}]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{"n", "\[LessEqual]", 
       RowBox[{"-", "1"}]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.497990130017849*^9, 3.497990130017849*^9}, {3.49843802295825*^9, 
   3.49843802295825*^9}, {3.498674382973672*^9, 3.498674382973672*^9}, {
   3.49867446038378*^9, 3.498674488383819*^9}, {3.498677308017767*^9, 
   3.4986773174477797`*^9}, 3.500661530668684*^9, 3.5006616774488897`*^9, {
   3.5040546298056593`*^9, 3.50405463053566*^9}, {3.504313242244506*^9, 
   3.5043132424445066`*^9}, {3.50475930032897*^9, 3.5047593019889727`*^9}, {
   3.505332597262227*^9, 3.5053325979122276`*^9}, {3.5095623709797344`*^9, 
   3.5095623709797344`*^9}, {3.5095624952899084`*^9, 3.509562495689909*^9}, {
   3.5101729030717697`*^9, 3.5101729030717697`*^9}, {3.5117212267749243`*^9, 
   3.511721226784924*^9}, {3.512153529861571*^9, 3.5121535304415717`*^9}, {
   3.5144126964408126`*^9, 3.5144127071324244`*^9}, {3.514412800434761*^9, 
   3.514412800434761*^9}, {3.514694835653309*^9, 3.5146948375877123`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox["B", "b"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497986264165859*^9, 3.4979862650706606`*^9}, {
   3.50065955661592*^9, 3.500659559295924*^9}, {3.5006614622785883`*^9, 
   3.5006614724286027`*^9}, {3.5012664315897408`*^9, 
   3.5012664362597475`*^9}, {3.5053446909838533`*^9, 3.5053446909938536`*^9}, 
   3.509562213549514*^9, 3.509562264919586*^9, {3.5095622975296316`*^9, 
   3.5095623032796392`*^9}, 3.510172910793783*^9, 3.5101737541156645`*^9, {
   3.5151884746039467`*^9, 3.51518847727395*^9}, 3.5153507185902777`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"B", "/", "b"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
        "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "m"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, {3.497986265944262*^9, 3.497986266927064*^9}, 
   3.4979863675440407`*^9, {3.4979898830226145`*^9, 3.497989898497842*^9}, 
   3.498679361436646*^9, {3.5006592743055253`*^9, 3.5006592786455317`*^9}, {
   3.5006615196186686`*^9, 3.5006615252886767`*^9}, {3.5006616594288645`*^9, 
   3.5006616867589025`*^9}, {3.5012664627097845`*^9, 3.501266465839789*^9}, {
   3.501266520899866*^9, 3.501266533939884*^9}, 3.501266611849993*^9, {
   3.505344691003854*^9, 3.5053446910138535`*^9}, {3.509562324069669*^9, 
   3.509562379989747*^9}, 3.5101725869996147`*^9, {3.510173769746892*^9, 
   3.510173772726497*^9}, {3.5144126197034235`*^9, 3.514412631092075*^9}, {
   3.5144139619721966`*^9, 3.5144139654243946`*^9}, {3.514694822720886*^9, 
   3.514694869349368*^9}, 3.515207470305025*^9, 3.5168207049165297`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence ",
 "1",
 " with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "A"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", "B"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   RowBox[{"m", "-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017224385660048`*^9, 3.5017224419824104`*^9}, 3.5017229574385157`*^9, 
   3.501723447987378*^9, {3.504905059830614*^9, 3.5049051008006716`*^9}, {
   3.5049062442122726`*^9, 3.5049062459122753`*^9}, 3.505345087554409*^9, 
   3.5120642138723326`*^9}],

Cell[TextData[{
 "Rule 1a: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"b", " ", "A"}], "-", 
       RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], ">", "1"}], " ", "\[And]", " ", 
     RowBox[{"n", "<", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501357957382189*^9, 3.50135795852219*^9}, {3.501358112502406*^9, 
   3.501358113912408*^9}, 3.501358177622497*^9, {3.501358226452565*^9, 
   3.50135822974257*^9}, 3.5013587175532527`*^9, {3.501359477874317*^9, 
   3.5013594968243437`*^9}, {3.5013598992049074`*^9, 3.501359907704919*^9}, {
   3.5027643770807753`*^9, 3.502764379015179*^9}, {3.5027682951140594`*^9, 
   3.5027682985460653`*^9}, {3.5040444264213743`*^9, 
   3.5040444272313757`*^9}, {3.504051718871584*^9, 3.5040517366516085`*^9}, {
   3.5041205238947134`*^9, 3.5041205286947203`*^9}, 3.504313308494599*^9, {
   3.504468281906513*^9, 3.504468310686553*^9}, 3.5047593049489765`*^9, {
   3.504906390942478*^9, 3.504906411062506*^9}, {3.505332603112235*^9, 
   3.5053326035322356`*^9}, 3.509561373448338*^9, {3.509562498459913*^9, 
   3.509562499239914*^9}, {3.5101722129485874`*^9, 3.510172215908592*^9}, {
   3.510179296295046*^9, 3.510179296934647*^9}, {3.5117212334349337`*^9, 
   3.5117212334349337`*^9}, {3.512153575841635*^9, 3.512153576141636*^9}, {
   3.512186852301958*^9, 3.512186857995968*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"a", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"a", " ", "B"}]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "-", 
          RowBox[{"j", " ", "k"}]}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}]}]]}]}]}]}], "-", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "-", 
        RowBox[{"2", "j", " ", "k"}]}]], "\[CenterDot]", 
      "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "-", "3"}], "2"]}], ")"}]}], "+", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "A"}], "-", 
              RowBox[{"b", " ", "B"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{"a", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", " ", "A"}], "-", 
              RowBox[{"a", " ", "B"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "-", "1"}], "2"]}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"2", "k"}]]}]}], ")"}], "\[CenterDot]", 
      "\[IndentingNewLine]", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.5095614512084465`*^9, 3.5095615613586006`*^9}, {3.5095616236086884`*^9, 
   3.5095618083489466`*^9}, {3.5095618405189915`*^9, 3.509561848569003*^9}, 
   3.509562235659545*^9, {3.5101720726483912`*^9, 3.510172116578453*^9}, {
   3.5141605311662393`*^9, 3.514160533936243*^9}, {3.515188480723955*^9, 
   3.515188483713959*^9}, {3.515350742239919*^9, 3.5153507633155565`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.509479967012754*^9, 3.5094799793114576`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "A"}], "-", 
       RowBox[{"a", "*", "B"}]}], ")"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"2", "*", "j", "*", "k"}]}], ")"}]}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "A"}], "-", 
               RowBox[{"a", "*", "B"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "-", "3"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "A"}], "-", 
               RowBox[{"a", "*", "B"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "-", "\n", 
            "        ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"a", "*", "A"}], "-", 
                  RowBox[{"b", "*", "B"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}], "+", 
               RowBox[{"a", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"b", "*", "A"}], "-", 
                  RowBox[{"a", "*", "B"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5026764690205073`*^9, {3.502676562960639*^9, 3.5026765748706555`*^9}, {
   3.502676709910845*^9, 3.502676745080894*^9}, {3.502677686692212*^9, 
   3.5026776934822216`*^9}, {3.5027670612250915`*^9, 
   3.5027670636898956`*^9}, {3.503071936858197*^9, 3.5030719454782095`*^9}, 
   3.50319810512*^9, {3.503549703821251*^9, 3.503549709891259*^9}, 
   3.50387619429158*^9, {3.5051554747458277`*^9, 3.5051554812558365`*^9}, 
   3.505344641353784*^9, {3.5053446929738564`*^9, 3.505344714963887*^9}, 
   3.505353544425192*^9, {3.50924009739312*^9, 3.509240125441969*^9}, {
   3.509240420719288*^9, 3.509240479234991*^9}, {3.5092405242254696`*^9, 
   3.509240529685479*^9}, 3.509240560292733*^9, 3.5092406309608574`*^9, {
   3.509240739193847*^9, 3.5092407562290773`*^9}, {3.5094733083539004`*^9, 
   3.50947331918552*^9}, {3.509475162067927*^9, 3.509475162249937*^9}, 
   3.509475333159713*^9, {3.5094799670517564`*^9, 3.5094799740681577`*^9}, 
   3.5094800542107415`*^9, {3.509561502658519*^9, 3.509561506348524*^9}, 
   3.5095620103592296`*^9, {3.509562078339325*^9, 3.509562085059334*^9}, {
   3.5101722225586014`*^9, 3.510172273698673*^9}, {3.5101723042023177`*^9, 
   3.510172346353592*^9}, 3.510172379098049*^9, 3.510179313829477*^9, 
   3.51018005029117*^9, {3.512185173285808*^9, 3.5121851742374096`*^9}, {
   3.5141605399162517`*^9, 3.514160546756261*^9}, {3.5166671680526314`*^9, 
   3.516667173793442*^9}, 3.5168207049465303`*^9, 3.5168238163725996`*^9, 
   3.5170739260575356`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence ",
 "1",
 " with ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017224385660048`*^9, 3.5017224419824104`*^9}, 3.5017229574385157`*^9, 
   3.501723447987378*^9, 3.505345087554409*^9, 3.5120642144023333`*^9}],

Cell[TextData[{
 "Derivation: Recurrence ",
 "6",
 " with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "A"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", "B"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   RowBox[{"m", "-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017224385660048`*^9, 3.5017224419824104`*^9}, 3.5017229574385157`*^9, 
   3.501723447987378*^9, {3.504905059830614*^9, 3.5049051008006716`*^9}, 
   3.505345123294459*^9, 3.512064196392308*^9}],

Cell[TextData[{
 "Rule 1b: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"b", " ", "A"}], "-", 
       RowBox[{"a", " ", "B"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{"0", "<", 
      RowBox[{"j", " ", "k", " ", "m"}], "<", "1"}], "  ", "\[And]", " ", 
     RowBox[{"n", "<", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501357957382189*^9, 3.50135795852219*^9}, {3.501358112502406*^9, 
   3.501358113912408*^9}, 3.501358177622497*^9, {3.501358226452565*^9, 
   3.50135822974257*^9}, 3.5013587175532527`*^9, {3.501359477874317*^9, 
   3.5013594968243437`*^9}, {3.5013598992049074`*^9, 3.501359907704919*^9}, {
   3.5027643770807753`*^9, 3.502764379015179*^9}, {3.5027682951140594`*^9, 
   3.5027682985460653`*^9}, {3.5040444264213743`*^9, 
   3.5040444272313757`*^9}, {3.504051718871584*^9, 3.5040517366516085`*^9}, {
   3.5041205238947134`*^9, 3.5041205286947203`*^9}, 3.504313308494599*^9, {
   3.504468281906513*^9, 3.504468310686553*^9}, 3.5047593049489765`*^9, {
   3.504906162322158*^9, 3.5049061627021585`*^9}, {3.5049064428125505`*^9, 
   3.5049064506925616`*^9}, {3.50533260661224*^9, 3.5053326074722414`*^9}, 
   3.509560858337617*^9, {3.5095625023699183`*^9, 3.509562503079919*^9}, {
   3.5101727198650475`*^9, 3.5101727198650475`*^9}, {3.510179319617087*^9, 
   3.510179320131888*^9}, {3.510961172200745*^9, 3.510961242840844*^9}, {
   3.511721203714892*^9, 3.511721203714892*^9}, {3.5121535943316607`*^9, 
   3.5121535948816614`*^9}, {3.5121868707099905`*^9, 
   3.5121868707099905`*^9}, {3.513121343771776*^9, 3.513121343771776*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "-", 
        RowBox[{"j", " ", "k"}]}]], "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "-", "1"}], "2"]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A"}], "-", 
           RowBox[{"b", " ", "B"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
           FractionBox[
            RowBox[{"k", "+", "3"}], "2"]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"2", "k"}]]}]}], ")"}], "\[CenterDot]", 
      "\[IndentingNewLine]", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.509560902857679*^9, 3.509560949397744*^9}, {3.5095609846277933`*^9, 
   3.509561101197957*^9}, {3.510172397162881*^9, 3.5101724322785425`*^9}, {
   3.5141605564162745`*^9, 3.514160558726278*^9}, {3.515188487773965*^9, 
   3.515188490963969*^9}, {3.515350796372014*^9, 3.5153508038444276`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.509479967012754*^9, 3.5094799793114576`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "A"}], "-", 
        RowBox[{"a", "*", "B"}]}], ")"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
     "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "A"}], "-", 
               RowBox[{"a", "*", "B"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "A"}], "-", 
               RowBox[{"b", "*", "B"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "-", "\n", 
            "        ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "A"}], "-", 
               RowBox[{"a", "*", "B"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "A"}], "-", 
      RowBox[{"a", "*", "B"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"j", "*", "k", "*", "m"}], "<", "1"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5026764690205073`*^9, {3.502676562960639*^9, 3.5026765748706555`*^9}, {
   3.502676709910845*^9, 3.502676745080894*^9}, {3.502677686692212*^9, 
   3.5026776934822216`*^9}, {3.5027670612250915`*^9, 
   3.5027670636898956`*^9}, {3.503071936858197*^9, 3.5030719454782095`*^9}, 
   3.50319810512*^9, {3.503549703821251*^9, 3.503549709891259*^9}, 
   3.50387619429158*^9, {3.5051554747458277`*^9, 3.5051554812558365`*^9}, 
   3.505344641353784*^9, {3.5053446929738564`*^9, 3.505344714963887*^9}, 
   3.505353544425192*^9, {3.50924009739312*^9, 3.509240125441969*^9}, {
   3.509240420719288*^9, 3.509240479234991*^9}, {3.5092405242254696`*^9, 
   3.509240529685479*^9}, 3.509240560292733*^9, 3.5092406309608574`*^9, {
   3.509240739193847*^9, 3.5092407562290773`*^9}, {3.5094733083539004`*^9, 
   3.50947331918552*^9}, {3.509475162067927*^9, 3.509475162249937*^9}, 
   3.509475333159713*^9, {3.5094799670517564`*^9, 3.5094799740681577`*^9}, 
   3.5094800542107415`*^9, {3.5095612456781588`*^9, 3.5095612748082*^9}, 
   3.5095620502492857`*^9, {3.510172404058093*^9, 3.5101724092061024`*^9}, {
   3.5101724458193665`*^9, 3.510172460951393*^9}, 3.510172592319224*^9, {
   3.510172636950902*^9, 3.5101726399773073`*^9}, 3.510179325857098*^9, 
   3.5101800555639796`*^9, {3.510960394235654*^9, 3.5109604170256853`*^9}, {
   3.510961297750921*^9, 3.5109613190309505`*^9}, 3.510961446411129*^9, {
   3.5121851888858356`*^9, 3.512185189806237*^9}, 3.513121332149756*^9, 
   3.5141604368361073`*^9, {3.5153508271664686`*^9, 3.5153508293660727`*^9}, 
   3.5166671825450573`*^9, 3.5168207049865303`*^9, 3.5168238163866005`*^9, 
   3.5170739316423454`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence ",
 "2",
 " with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "A"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", "B"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   RowBox[{"m", "-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.501722843012315*^9, 3.501722843651916*^9}, 
   3.505345104394432*^9, 3.51206422619235*^9}],

Cell[TextData[{
 "Rule 2: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], ">", "1"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"-", "1"}], "\[LessEqual]", "n", "<", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.502677309791684*^9, 3.502677315931693*^9}, {
   3.502767275678668*^9, 3.502767275678668*^9}, {3.5027682258967376`*^9, 
   3.502768240248763*^9}, 3.502768355688966*^9, {3.5033578653664684`*^9, 
   3.50335786655207*^9}, {3.5033582359295187`*^9, 3.5033582359295187`*^9}, {
   3.5040444363813887`*^9, 3.5040444374213896`*^9}, {3.5040517955416913`*^9, 
   3.5040517955416913`*^9}, {3.5041423703555098`*^9, 3.504142372414714*^9}, {
   3.5041598902074847`*^9, 3.5041598902074847`*^9}, 3.5043133121446037`*^9, {
   3.5095605626772027`*^9, 3.5095605681672106`*^9}, {3.5101727225170527`*^9, 
   3.5101727225170527`*^9}, {3.5101793335947113`*^9, 3.510179334015912*^9}, {
   3.510961549121273*^9, 3.5109615587012863`*^9}, {3.51096210431205*^9, 
   3.51096210431205*^9}, {3.511721241874945*^9, 3.511721241874945*^9}, {
   3.512186891317627*^9, 3.512186891317627*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"B", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "-", 
           RowBox[{"j", " ", "k"}]}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"b", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "-", 
        RowBox[{"2", "j", " ", "k"}]}]], "\[CenterDot]", 
      "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "B", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "-", "3"}], "2"]}], ")"}]}], "+", 
        RowBox[{"b", " ", "B", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
           FractionBox[
            RowBox[{"k", "-", "1"}], "2"]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", " ", "A"}], "-", 
              RowBox[{"a", " ", "B"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "-", "1"}], "2"]}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"2", "k"}]]}]}], ")"}], "\[CenterDot]", 
      "\[IndentingNewLine]", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5030149938276834`*^9, 
   3.5030149992252927`*^9}, 3.505344641363784*^9, {3.505344693023856*^9, 
   3.5053447149738874`*^9}, 3.5053535459551945`*^9, {3.5094696268243294`*^9, 
   3.509469698805446*^9}, {3.509469791674758*^9, 3.509469802752392*^9}, {
   3.509469914234768*^9, 3.5094699164558954`*^9}, {3.509470445456152*^9, 
   3.509470483604334*^9}, {3.5094706454305897`*^9, 3.50947066641179*^9}, {
   3.5094707559529114`*^9, 3.5094707698497066`*^9}, 3.5094708527324467`*^9, {
   3.5094710367959747`*^9, 3.5094710383620644`*^9}, 3.5094711873785877`*^9, 
   3.5094801966418877`*^9, {3.5095601616466413`*^9, 3.509560314986856*^9}, {
   3.509560348756903*^9, 3.50956035327691*^9}, {3.51017248196463*^9, 
   3.5101724878458405`*^9}, {3.5101727624843225`*^9, 3.510172767367131*^9}, {
   3.5101731141401405`*^9, 3.510173160207021*^9}, {3.5141605739862995`*^9, 
   3.514160576186302*^9}, {3.5151884938539734`*^9, 3.515188497033978*^9}, {
   3.515350843905298*^9, 3.515350849209307*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "B"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}], 
      ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"2", "*", "j", "*", "k"}]}], ")"}]}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "B", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "-", "3"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{"b", "*", "B", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", "\n", 
            "        ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "A", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"b", "*", "A"}], "-", 
                  RowBox[{"a", "*", "B"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], ">", "1"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", "n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, 3.50267709922139*^9, {3.502677262251618*^9, 
   3.502677280331643*^9}, 3.5027670673403025`*^9, {3.5030150059333043`*^9, 
   3.5030150148565197`*^9}, {3.503071953798221*^9, 3.5030719623082333`*^9}, {
   3.5035497609313307`*^9, 3.5035497734613485`*^9}, 3.503876194868781*^9, {
   3.504156461196662*^9, 3.5041564626786647`*^9}, 3.505344641373784*^9, {
   3.5053446930538564`*^9, 3.505344714983887*^9}, 3.5053535482551975`*^9, {
   3.5094719943757453`*^9, 3.509471999082014*^9}, {3.5094721711418557`*^9, 
   3.5094721778162374`*^9}, {3.50947240515324*^9, 3.509472413765733*^9}, 
   3.5094733026345735`*^9, {3.509475150960292*^9, 3.5094751544394903`*^9}, {
   3.5095604119769917`*^9, 3.5095604408470325`*^9}, 3.5099006613518543`*^9, 
   3.5101725950180283`*^9, {3.510172650132925*^9, 3.5101726506789265`*^9}, {
   3.510172769831936*^9, 3.510172774636744*^9}, 3.510173007264353*^9, 
   3.5101730481208243`*^9, {3.5101731721098423`*^9, 3.510173214229916*^9}, 
   3.510179337744319*^9, 3.5101800644715953`*^9, {3.5109614826411796`*^9, 
   3.510961489201189*^9}, 3.510962096552039*^9, 3.512185231926311*^9, {
   3.5141605842063136`*^9, 3.514160588366319*^9}, {3.5144130618427124`*^9, 
   3.514413064980892*^9}, {3.515207446670984*^9, 3.5152074512261915`*^9}, 
   3.5166671954306793`*^9, 3.5168207050265303`*^9, 3.516823816403601*^9, 
   3.517073936977555*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence ",
 "3",
 " with ",
 Cell[BoxData[
  RowBox[{"A", "=", 
   RowBox[{"a", " ", "A"}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", 
   RowBox[{
    RowBox[{"b", " ", "A"}], "+", 
    RowBox[{"a", " ", "B"}]}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", 
   RowBox[{"b", " ", "B"}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"n", "-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, 
   3.505345123294459*^9, 3.5120642383523664`*^9}],

Cell[TextData[{
 "Rule 3a: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "\[GreaterEqual]", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "\[NotEqual]", "1"}], " ", "\[And]", 
     " ", 
     RowBox[{"n", ">", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4993685152127995`*^9, 3.499368525272814*^9}, {3.5003196739046497`*^9, 
   3.5003196775646553`*^9}, {3.5004320218638687`*^9, 
   3.5004320229179287`*^9}, {3.5026773276717095`*^9, 
   3.5026773598217545`*^9}, {3.5027672801246758`*^9, 
   3.5027672801246758`*^9}, {3.5040286397141275`*^9, 
   3.5040286407749295`*^9}, {3.5040290157527885`*^9, 3.5040290170787907`*^9}, 
   3.5040318675893974`*^9, {3.504296981415786*^9, 3.5042969896257973`*^9}, 
   3.5043107563112917`*^9, {3.5047476042825956`*^9, 3.5047476056225977`*^9}, {
   3.5051011018466954`*^9, 3.5051011152867146`*^9}, {3.5094725039578915`*^9, 
   3.5094725039578915`*^9}, 3.509556239034717*^9, {3.5099022313560534`*^9, 
   3.5099022313560534`*^9}, {3.510172725153457*^9, 3.510172725153457*^9}, {
   3.5101793423307266`*^9, 3.5101793427675276`*^9}, {3.5117212484449544`*^9, 
   3.5117212484449544`*^9}, {3.512186902268846*^9, 3.512186903111247*^9}, {
   3.515211141301075*^9, 3.515211141301075*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "B", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"j", " ", "k"}]}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
     FractionBox[
      RowBox[{"k", "+", "1"}], "2"]}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
      "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A", " ", "n"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "A"}], "+", 
              RowBox[{"b", " ", "B"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "b", " ", "A"}], "+", 
              RowBox[{"a", " ", "B"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "B"}], "+", 
              RowBox[{"2", " ", "a", " ", "b", " ", "A"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "B"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
              FractionBox[
               RowBox[{"k", "-", "1"}], "2"]}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "B", " ", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", " ", "A"}], "+", 
              RowBox[{"a", " ", "B"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"2", "k"}]]}]}], ")"}], "\[CenterDot]", 
      "\[IndentingNewLine]", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
       RowBox[{"n", "-", "2"}]]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095562652147536`*^9, 3.5095563252848377`*^9}, {3.50955638387492*^9, 
   3.5095564136949615`*^9}, {3.5095564499650126`*^9, 
   3.5095565745651865`*^9}, {3.509556659575306*^9, 3.5095566816053367`*^9}, {
   3.5095567320554075`*^9, 3.5095567407354193`*^9}, {3.509556895905637*^9, 
   3.5095569251456776`*^9}, {3.510172496160655*^9, 3.510172513227085*^9}, {
   3.5101727774135485`*^9, 3.5101727805647545`*^9}, {3.5101732386595592`*^9, 
   3.51017323937716*^9}, {3.510173272480418*^9, 3.510173288844847*^9}, {
   3.5151885006339827`*^9, 3.5151885040139875`*^9}, {3.515350866353737*^9, 
   3.515350871033746*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}, {
   3.509557000785784*^9, 3.5095570051957893`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "B", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", "\[IndentingNewLine]", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "A", "*", "n"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"a", "*", "A"}], "+", 
                  RowBox[{"b", "*", "B"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}]}], "+", "\n", "        ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", "*", "b", "*", "A"}], "+", 
                  RowBox[{"a", "*", "B"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"a", "^", "2"}], "*", "B"}], "+", 
                  RowBox[{"2", "*", "a", "*", "b", "*", "A"}], "+", 
                  RowBox[{
                   RowBox[{"b", "^", "2"}], "*", "B"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
            "\[IndentingNewLine]", "        ", 
            RowBox[{"b", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "B", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "-", "1"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"b", "*", "A"}], "+", 
                  RowBox[{"a", "*", "B"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[GreaterEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[NotEqual]", "1"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500432015647513*^9, 
   3.5004320167615767`*^9}, {3.501043209599528*^9, 3.5010432350499835`*^9}, 
   3.5026771020013933`*^9, {3.502677180841504*^9, 3.5026772181615562`*^9}, {
   3.502677352241744*^9, 3.5026773539717464`*^9}, 3.5027670707255077`*^9, {
   3.503071968728242*^9, 3.503071977848255*^9}, 3.5038761956487827`*^9, {
   3.5040290099495783`*^9, 3.504029011478381*^9}, {3.5041565286043806`*^9, 
   3.504156530008383*^9}, {3.5042865784817295`*^9, 3.5042866008017607`*^9}, {
   3.5042870585024014`*^9, 3.5042870681924148`*^9}, {3.504287484912998*^9, 
   3.504287490763006*^9}, {3.5042940452901697`*^9, 3.5042940507501793`*^9}, 
   3.5042956788330393`*^9, {3.504296854565608*^9, 3.5042968614056177`*^9}, {
   3.505100941436471*^9, 3.505100953336488*^9}, {3.505101028776593*^9, 
   3.5051010300865946`*^9}, 3.505344641403784*^9, {3.5053446931238565`*^9, 
   3.5053447150138874`*^9}, 3.5053535519652023`*^9, 3.509472213767294*^9, 
   3.509472341770615*^9, {3.5094725099262333`*^9, 3.5094725194427776`*^9}, 
   3.50947329995942*^9, {3.5094751389386044`*^9, 3.5094751435978703`*^9}, 
   3.5095570491158514`*^9, {3.5095604499870453`*^9, 3.5095604530970497`*^9}, 
   3.509843216812952*^9, 3.509902227726048*^9, 3.510172597685633*^9, {
   3.5101726543449326`*^9, 3.5101726549065337`*^9}, {3.510172783045159*^9, 
   3.510172787787567*^9}, 3.5101730101503572`*^9, 3.51017304548442*^9, {
   3.5101732486279764`*^9, 3.5101732629176016`*^9}, 3.5101793461995335`*^9, {
   3.5121852599595604`*^9, 3.512185262127964*^9}, {3.514413090795368*^9, 
   3.5144130916084146`*^9}, {3.5152074367961664`*^9, 3.5152074419441757`*^9}, 
   3.515211120927439*^9, {3.5153509063522077`*^9, 3.515350908754612*^9}, {
   3.5166672044474955`*^9, 3.516667211093107*^9}, 3.51682070505653*^9, 
   3.5168238164436035`*^9, 3.517073944481168*^9, {3.517074845613551*^9, 
   3.5170748472671537`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence ",
 "2",
 " with ",
 Cell[BoxData[
  RowBox[{"A", "=", 
   RowBox[{"a", " ", "A"}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", 
   RowBox[{
    RowBox[{"b", " ", "A"}], "+", 
    RowBox[{"a", " ", "B"}]}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", 
   RowBox[{"b", " ", "B"}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"n", "-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, {
   3.505866068185237*^9, 3.505866068655238*^9}, 3.5058664962858367`*^9, {
   3.509986401026863*^9, 3.5099864013768635`*^9}, 3.512064224502348*^9, 
   3.5130500758863173`*^9}],

Cell[TextData[{
 "Derivation: Recurrence ",
 "3",
 " with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "A"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", "B"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   RowBox[{"m", "-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, 3.5053451233044586`*^9, 3.5120642388423676`*^9}],

Cell[TextData[{
 "Rule 3b: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], ">", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "\[NotEqual]", "1"}], " ", "\[And]", 
     " ", 
     RowBox[{"0", "<", "n", "<", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4993685152127995`*^9, 3.499368525272814*^9}, {3.5003196739046497`*^9, 
   3.5003196775646553`*^9}, {3.5004320218638687`*^9, 
   3.5004320229179287`*^9}, {3.5026773276717095`*^9, 
   3.5026773598217545`*^9}, {3.5027672801246758`*^9, 
   3.5027672801246758`*^9}, {3.502768130767771*^9, 3.5027681579118185`*^9}, {
   3.5027753310736456`*^9, 3.5027753310736456`*^9}, {3.504044442451397*^9, 
   3.5040444430813975`*^9}, {3.504120551404752*^9, 3.5041205549347568`*^9}, {
   3.5042162611015806`*^9, 3.504216266921589*^9}, {3.504216455131852*^9, 
   3.5042164557318535`*^9}, {3.504313318664613*^9, 3.504313319084614*^9}, {
   3.504930682330023*^9, 3.5049306835600243`*^9}, {3.504980193107036*^9, 
   3.5049802057270536`*^9}, {3.509555627863861*^9, 3.5095556354538717`*^9}, {
   3.5101727272438607`*^9, 3.5101727272438607`*^9}, {3.510179350863942*^9, 
   3.5101793514879427`*^9}, {3.5117212541649623`*^9, 
   3.5117212541649623`*^9}, {3.5121869264176884`*^9, 
   3.5121869264176884`*^9}, {3.5152069561677217`*^9, 
   3.5152069561677217`*^9}, {3.515207010393417*^9, 3.5152070207206345`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"B", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
     FractionBox[
      RowBox[{"k", "+", "1"}], "2"]}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "-", 
        RowBox[{"j", " ", "k"}]}]], "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "B", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "-", "1"}], "2"]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "A"}], "+", 
              RowBox[{"b", " ", "B"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
              FractionBox[
               RowBox[{"k", "-", "1"}], "2"]}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"n", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", " ", "A"}], "+", 
              RowBox[{"a", " ", "B"}]}], ")"}]}], "+", 
           RowBox[{"b", " ", "A", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"2", "k"}]]}]}], ")"}], "\[CenterDot]", 
      "\[IndentingNewLine]", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.509555746174027*^9, 3.509555943204303*^9}, {3.510172505473871*^9, 
   3.5101725090150776`*^9}, {3.5101727905331717`*^9, 3.510172794152378*^9}, {
   3.510173309249683*^9, 3.510173334771328*^9}, {3.513051092777741*^9, 
   3.5130511452278147`*^9}, {3.515188506993992*^9, 3.515188510443997*^9}, {
   3.5153509386910644`*^9, 3.515350944135474*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "B"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
     "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "B", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "A"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"a", "*", "A"}], "+", 
                  RowBox[{"b", "*", "B"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", "\n", 
            "        ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"n", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"b", "*", "A"}], "+", 
                  RowBox[{"a", "*", "B"}]}], ")"}]}], "+", 
               RowBox[{"b", "*", "A", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], ">", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[NotEqual]", "1"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500432015647513*^9, 
   3.5004320167615767`*^9}, {3.501043209599528*^9, 3.5010432350499835`*^9}, 
   3.5026771020013933`*^9, {3.502677180841504*^9, 3.5026772181615562`*^9}, {
   3.502677352241744*^9, 3.5026773539717464`*^9}, 3.5027670707255077`*^9, {
   3.503071968728242*^9, 3.503071977848255*^9}, 3.5038761956487827`*^9, {
   3.5040290099495783`*^9, 3.504029011478381*^9}, {3.5041565286043806`*^9, 
   3.504156530008383*^9}, {3.5042865784817295`*^9, 3.5042866008017607`*^9}, {
   3.5042870585024014`*^9, 3.5042870681924148`*^9}, {3.504287484912998*^9, 
   3.504287490763006*^9}, {3.5042940452901697`*^9, 3.5042940507501793`*^9}, 
   3.5042956788330393`*^9, {3.504296854565608*^9, 3.5042968614056177`*^9}, {
   3.505100941436471*^9, 3.505100953336488*^9}, {3.505101028776593*^9, 
   3.5051010300865946`*^9}, 3.505344641403784*^9, {3.5053446931238565`*^9, 
   3.5053447150138874`*^9}, 3.5053535519652023`*^9, 3.509472213767294*^9, 
   3.509472341770615*^9, {3.5094725099262333`*^9, 3.5094725194427776`*^9}, 
   3.50947329995942*^9, {3.5094751389386044`*^9, 3.5094751435978703`*^9}, {
   3.509555674813927*^9, 3.5095556878339453`*^9}, {3.5095559929943724`*^9, 
   3.509555993204373*^9}, 3.5095560919445114`*^9, {3.5095604623570623`*^9, 
   3.509560462547063*^9}, 3.510172600446838*^9, {3.5101726585257397`*^9, 
   3.5101726591185412`*^9}, {3.510172797334784*^9, 3.5101728215616264`*^9}, 
   3.5101730129271626`*^9, 3.5101730430040154`*^9, {3.5101733461749477`*^9, 
   3.510173369637389*^9}, 3.510179354873149*^9, 3.5101800773416176`*^9, {
   3.5121852793815947`*^9, 3.5121852869008074`*^9}, 3.5130511788578615`*^9, 
   3.5144131060242395`*^9, {3.5152069482273073`*^9, 3.51520694936611*^9}, {
   3.515207031515854*^9, 3.5152070374750643`*^9}, {3.5152074248309455`*^9, 
   3.515207428699752*^9}, {3.515350962855507*^9, 3.515350965086311*^9}, {
   3.5166672208587246`*^9, 3.5166672234951286`*^9}, 3.5168207050965304`*^9, 
   3.5168238164856057`*^9, 3.517073949909978*^9, {3.517074892164033*^9, 
   3.5170748937396355`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence ",
 "4",
 " with ",
 Cell[BoxData[
  RowBox[{"A", "=", 
   RowBox[{"a", " ", "A"}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", 
   RowBox[{
    RowBox[{"b", " ", "A"}], "+", 
    RowBox[{"a", " ", "B"}]}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"C", "=", 
   RowBox[{"b", " ", "B"}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"n", "-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, {
   3.504922869599085*^9, 3.504922870989087*^9}, 3.505345087564409*^9, 
   3.5120642499723835`*^9}],

Cell[TextData[{
 "Rule 4a: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "<", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.504028644986937*^9, 3.5040286460633388`*^9}, 
   3.504031871520604*^9, {3.5042969469757376`*^9, 3.504296966725765*^9}, 
   3.5043107598680983`*^9, {3.504747625602626*^9, 3.5047476267926273`*^9}, {
   3.5051010704066515`*^9, 3.505101092536682*^9}, {3.5094730728464303`*^9, 
   3.5094730728464303`*^9}, {3.5095545822823973`*^9, 
   3.5095545998824224`*^9}, {3.5101727293810644`*^9, 
   3.5101727293810644`*^9}, {3.5101793585079556`*^9, 
   3.5101793589291563`*^9}, {3.5117212591249695`*^9, 
   3.5117212591249695`*^9}, {3.5121869358089046`*^9, 3.512186937088107*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"a", " ", "A", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "1"}], "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "+", 
        RowBox[{"j", " ", "k"}]}]], "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", " ", "A"}], "+", 
              RowBox[{"a", " ", "B"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "-", 
           RowBox[{"b", " ", "A", " ", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "A"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "A"}], "+", 
              RowBox[{"2", " ", "a", " ", "b", " ", "B"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], "A"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A", " ", "n"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "A"}], "+", 
              RowBox[{"b", " ", "B"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"2", "k"}]]}]}], ")"}], "\[CenterDot]", 
      "\[IndentingNewLine]", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
       RowBox[{"n", "-", "2"}]]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095546485624905`*^9, 3.5095548310727463`*^9}, {3.509554944782905*^9, 
   3.509554978772953*^9}, {3.5095550311130257`*^9, 3.5095550406230392`*^9}, {
   3.5095551029731264`*^9, 3.509555110183137*^9}, {3.509555148833191*^9, 
   3.50955518414324*^9}, 3.5095552442833242`*^9, 3.5095554618336287`*^9, {
   3.5101725287803125`*^9, 3.51017253319512*^9}, {3.5101728354144506`*^9, 
   3.5101728382380557`*^9}, {3.5101734308362966`*^9, 3.510173455141139*^9}, {
   3.5151885139440017`*^9, 3.515188518274008*^9}, {3.515350981169939*^9, 
   3.515350984383545*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", "A", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"b", "*", "A"}], "+", 
                  RowBox[{"a", "*", "B"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], 
               "-", 
               RowBox[{"b", "*", "A", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "-", "1"}], ")"}]}]}], ")"}]}], "+", "\n", 
            "        ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"a", "^", "2"}], "*", "A"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"a", "^", "2"}], "*", "A"}], "+", 
                  RowBox[{"2", "*", "a", "*", "b", "*", "B"}], "+", 
                  RowBox[{
                   RowBox[{"b", "^", "2"}], "*", "A"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", "\n", 
            "        ", 
            RowBox[{"b", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "A", "*", "n"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"a", "*", "A"}], "+", 
                  RowBox[{"b", "*", "B"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5038761961479836`*^9, {3.504156546965613*^9, 
   3.504156548322815*^9}, {3.5042968954456654`*^9, 3.5042969168056955`*^9}, {
   3.5051010426366124`*^9, 3.505101050326623*^9}, 3.5053446414337845`*^9, {
   3.5053446931938567`*^9, 3.505344715043887*^9}, 3.50535355708521*^9, {
   3.509473076633647*^9, 3.509473117827003*^9}, 3.509473221522934*^9, {
   3.5094732830534534`*^9, 3.509473292318983*^9}, {3.5094751195374947`*^9, 
   3.5094751247597933`*^9}, 3.5095546021524253`*^9, {3.5095604705070734`*^9, 
   3.5095604739670787`*^9}, 3.509901170672567*^9, 3.509901379052859*^9, 
   3.5101726030676427`*^9, {3.5101726631121483`*^9, 3.510172663673749*^9}, {
   3.510172826725236*^9, 3.5101728304380417`*^9}, {3.510173018449572*^9, 
   3.5101730407264113`*^9}, {3.5101733867038193`*^9, 3.510173418621475*^9}, 
   3.5101793621427617`*^9, 3.5105917427974453`*^9, 3.5105925522585783`*^9, {
   3.510784548740075*^9, 3.5107845520472813`*^9}, {3.512185343432107*^9, 
   3.51218534510131*^9}, 3.514413111678563*^9, {3.5152074136301255`*^9, 
   3.5152074184973345`*^9}, {3.5153510002643723`*^9, 3.515351002557576*^9}, 
   3.5166672334479465`*^9, 3.5168207051365304`*^9, 3.516823816523608*^9, 
   3.5170739554635873`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence ",
 "4",
 " with ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017234466769753`*^9, 3.5053450875744085`*^9, 3.512064250422384*^9}],

Cell[TextData[{
 "Rule 4b: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "<", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"0", "<", "n", "\[LessEqual]", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, 
   3.501360698386026*^9, 3.502764465517331*^9, {3.502764564717905*^9, 
   3.5027645817219353`*^9}, {3.5040444512814093`*^9, 
   3.5040444521714106`*^9}, {3.504053340593854*^9, 3.504053349543867*^9}, {
   3.504066741697694*^9, 3.504066851700986*^9}, {3.504119823905727*^9, 
   3.504119823905727*^9}, {3.5041479977137966`*^9, 3.5041480034702067`*^9}, {
   3.504148210794571*^9, 3.504148226566199*^9}, {3.5041534502353735`*^9, 
   3.5041534502353735`*^9}, {3.504154534889679*^9, 3.504154536215681*^9}, {
   3.504216285491615*^9, 3.504216285731615*^9}, {3.5042166285920954`*^9, 
   3.504216629042096*^9}, {3.5042972939462233`*^9, 3.504297296396227*^9}, 
   3.504313351644659*^9, {3.5049153219428873`*^9, 3.5049153226136885`*^9}, {
   3.504925576302874*^9, 3.5049255770228753`*^9}, {3.5049308071301975`*^9, 
   3.5049308087401996`*^9}, {3.5049802806771584`*^9, 
   3.5049803320772305`*^9}, {3.5095544314221864`*^9, 
   3.5095544444322042`*^9}, {3.510172731908269*^9, 3.510172731908269*^9}, {
   3.5101793674311705`*^9, 3.5101793678679714`*^9}, {3.511721264494977*^9, 
   3.5117212645049767`*^9}, {3.5121869534213357`*^9, 
   3.5121869534213357`*^9}, {3.513101354846774*^9, 3.5131013674367914`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"A", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "1"}], "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "+", 
        RowBox[{"j", " ", "k"}]}]], "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "B", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "-", 
        RowBox[{"b", " ", "A", " ", "n"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "A"}], "+", 
              RowBox[{"b", " ", "B"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
        RowBox[{"b", " ", "A", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
           FractionBox[
            RowBox[{"k", "+", "3"}], "2"]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"2", "k"}]]}]}], ")"}], "\[CenterDot]", 
      "\[IndentingNewLine]", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095542513719344`*^9, 3.509554323542035*^9}, {3.510172539341531*^9, 
   3.5101725420403357`*^9}, {3.510173494983609*^9, 3.5101735152636447`*^9}, {
   3.5132807102182083`*^9, 3.5132807140282135`*^9}, {3.5141606351163845`*^9, 
   3.5141606376763887`*^9}, {3.515188521954013*^9, 3.5151885248640165`*^9}, {
   3.5153510207316084`*^9, 3.5153510245380154`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "B", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "-", 
            RowBox[{"b", "*", "A", "*", "n"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "A"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"a", "*", "A"}], "+", 
                  RowBox[{"b", "*", "B"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", "\n", 
            "        ", 
            RowBox[{"b", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5038761961479836`*^9, {3.504156546965613*^9, 
   3.504156548322815*^9}, {3.5042968954456654`*^9, 3.5042969168056955`*^9}, {
   3.5051010426366124`*^9, 3.505101050326623*^9}, 3.5053446414337845`*^9, {
   3.5053446931938567`*^9, 3.505344715043887*^9}, 3.50535355708521*^9, {
   3.509473076633647*^9, 3.509473117827003*^9}, 3.509473221522934*^9, {
   3.5094732830534534`*^9, 3.509473292318983*^9}, {3.5094751195374947`*^9, 
   3.5094751247597933`*^9}, {3.5095542554019403`*^9, 
   3.5095542862019835`*^9}, {3.509554360482087*^9, 3.509554381662117*^9}, 
   3.509554414102162*^9, 3.5101726059536476`*^9, {3.510172667168155*^9, 
   3.5101726677609563`*^9}, {3.510172847083271*^9, 3.510172851123678*^9}, {
   3.510173021787978*^9, 3.510173038386407*^9}, {3.510173532330075*^9, 
   3.5101735756201506`*^9}, 3.510179372235979*^9, 3.510180086077633*^9, 
   3.51059079396611*^9, {3.5105915658871975`*^9, 3.5105915675671997`*^9}, {
   3.510591650907316*^9, 3.5105916535873203`*^9}, {3.5121853535721245`*^9, 
   3.5121853594377356`*^9}, {3.5131013736668005`*^9, 3.5131013937268286`*^9}, 
   3.5141604394761105`*^9, 3.514413118327943*^9, {3.5152073899648843`*^9, 
   3.515207394223692*^9}, 3.516667239422757*^9, 3.5168207051665306`*^9, 
   3.51682381655961*^9, 3.5170739564463887`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence ",
 "5",
 " with ",
 Cell[BoxData[
  RowBox[{"C", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.5017229277048635`*^9, 
   3.5017229327592726`*^9}, 3.5017234488453794`*^9, 3.5053451044044323`*^9, 
   3.5120642616723995`*^9}],

Cell[TextData[{
 "Rule 5: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", 
     " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "\[LessEqual]", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"-", "1"}], "\[LessEqual]", "n", "<", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4992133873636045`*^9, 3.4992133892036066`*^9}, {3.4992162641476316`*^9, 
   3.499216265707634*^9}, {3.4993685410928354`*^9, 3.4993685488628464`*^9}, {
   3.50031970240469*^9, 3.5003197069046965`*^9}, {3.5004320341975737`*^9, 
   3.5004320353096375`*^9}, {3.5026784535032854`*^9, 3.502678461573297*^9}, {
   3.5027657904804587`*^9, 3.5027657904804587`*^9}, {3.5027672190193686`*^9, 
   3.5027672190193686`*^9}, {3.5035496199411335`*^9, 
   3.5035496486311736`*^9}, {3.504028649276944*^9, 3.5040286502597466`*^9}, 
   3.50403187501501*^9, 3.5043107662485094`*^9, {3.5047476342426376`*^9, 
   3.504747635372639*^9}, {3.509473798840955*^9, 3.509473798840955*^9}, {
   3.510172734170273*^9, 3.510172734170273*^9}, {3.510179376401187*^9, 
   3.5101793768535876`*^9}, {3.5117212692449837`*^9, 
   3.5117212692449837`*^9}, {3.5121869691929636`*^9, 
   3.5121869691929636`*^9}, {3.5152072965051203`*^9, 3.515207315271953*^9}, {
   3.516667283929635*^9, 3.5166672849280367`*^9}, {3.517075006387433*^9, 
   3.517075006387433*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"A", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "+", 
        RowBox[{"j", " ", "k"}]}]], "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "B"}], "-", 
           RowBox[{"b", " ", "A"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "-", 
        RowBox[{"b", " ", "A", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], "+", 
        RowBox[{"a", " ", "A", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "3"}], "2"]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
        RowBox[{"b", " ", "A", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
           FractionBox[
            RowBox[{"k", "+", "3"}], "2"]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"2", "k"}]]}]}], " ", ")"}], "\[CenterDot]", 
      "\[IndentingNewLine]", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, 
   3.4991797926481485`*^9, {3.4991798252678056`*^9, 3.499179837935028*^9}, {
   3.499180927976143*^9, 3.499180938599762*^9}, {3.4991810132614927`*^9, 
   3.4991810250395136`*^9}, {3.4991962578715715`*^9, 
   3.4991962790096083`*^9}, {3.499196703083153*^9, 3.4991967615208554`*^9}, {
   3.499197192643613*^9, 3.499197222845266*^9}, {3.4991977240625467`*^9, 
   3.4991977407233753`*^9}, {3.499197780737446*^9, 3.4991977890990605`*^9}, {
   3.4991980290346823`*^9, 3.4991980546967273`*^9}, {3.499198191403367*^9, 
   3.499198208017396*^9}, {3.499198305326367*^9, 3.4991983055447674`*^9}, {
   3.499198375223689*^9, 3.4991983899189153`*^9}, 3.499198439702202*^9, {
   3.4992136675539966`*^9, 3.4992137193140693`*^9}, 3.499213754044118*^9, {
   3.4992161931675324`*^9, 3.499216193677533*^9}, {3.4992162414576*^9, 
   3.4992163332577286`*^9}, {3.4992164987579603`*^9, 
   3.4992165531380367`*^9}, {3.4993646678093863`*^9, 
   3.4993647284894705`*^9}, {3.499364780039543*^9, 3.499364804929578*^9}, {
   3.499364846769636*^9, 3.4993648633396597`*^9}, {3.499404320916315*^9, 
   3.499404323956319*^9}, {3.499404813317004*^9, 3.499404815097007*^9}, {
   3.5003179817729173`*^9, 3.5003179820537176`*^9}, 3.5003181967000947`*^9, 
   3.505344641443784*^9, {3.505344693233857*^9, 3.5053447150538874`*^9}, 
   3.5053535583452115`*^9, {3.509473422445426*^9, 3.5094734793846827`*^9}, {
   3.509473628380205*^9, 3.5094737191313953`*^9}, {3.50955395557152*^9, 
   3.509554016341605*^9}, {3.5101725470635443`*^9, 3.510172549590749*^9}, {
   3.510172854181284*^9, 3.5101728584868913`*^9}, {3.510173604059001*^9, 
   3.5101736052134027`*^9}, 3.5102536390285225`*^9, {3.510255314510868*^9, 
   3.510255317350872*^9}, {3.5102553707309465`*^9, 3.5102553757509537`*^9}, {
   3.5141606459863997`*^9, 3.5141606545564117`*^9}, {3.5151885293040233`*^9, 
   3.515188531944027*^9}, {3.5153510465184536`*^9, 3.51535105016886*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
   